/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.dialogs.style.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import sun.font.Font2D;
import sun.font.FontManager;

public class TdkStyleCharacterTableRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 9015245178138276622L;
    private Color color_ = new Color(0, 0, 0);
    private Object[][] values_ = null;
    private Font font_ = null;
    private int fontSize = 25;
    private static String allNormalChars = "1234567890qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM";

    TdkStyleCharacterTableRenderer(Object[][] objectArray, Font font, Color color) {
        this.font_ = font;
        this.values_ = objectArray;
        this.color_ = color;
        this.fontSize = this.font_.getSize();
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Color color = this.color_;
        if (bl) {
            color = new Color(0, 255, 0);
        }
        Font font = new Font(this.font_.getName(), this.font_.getStyle(), 18);
        if (((String)this.values_[n2][n]).length() > 0) {
            int c;
            int n3 = c = ((String)this.values_[n2][n]).charAt(0);
            char jLabel = Character.toChars(n3 |= 0xF000)[0];
            return new TdkCharPanel(font, jLabel, color);
        }
        JLabel jLabel = new JLabel();
        jLabel.setForeground(color);
        return jLabel;
    }

    public Color getColor() {
        return this.color_;
    }

    public void setColor(Color color) {
        this.color_ = color;
        this.repaint();
    }

    public class TdkCharPanel
    extends JPanel {
        private Font font;
        private char character;
        private Color color;

        public TdkCharPanel(Font font, char c, Color color) {
            this.font = font;
            this.character = c;
            this.color = color;
        }

        @Override
        public void paint(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setColor(this.color);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            Font2D font2D = FontManager.findFont2D(this.font.getName(), this.font.getStyle(), 2);
            int[] nArray = new int[]{font2D.charToGlyph(this.character)};
            GlyphVector glyphVector = this.font.createGlyphVector(fontRenderContext, nArray);
            graphics2D.drawGlyphVector(glyphVector, 0.0f, this.getHeight());
        }
    }
}

