/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.dialogs.style.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.tecgraf.jtdk.core.swig.TdkLineStyle;
import org.tecgraf.jtdk.core.swig.TdkLineStyleBasic;
import org.tecgraf.jtdk.desktop.components.TdkComponentsI18n;
import org.tecgraf.jtdk.desktop.components.dialogs.style.table.TdkStyleColorPanel;
import org.tecgraf.jtdk.desktop.components.dialogs.style.table.TdkStyleSpinner;

public class TdkStyleLineBasicTableRenderer
extends DefaultTableCellRenderer
implements Observer {
    private TdkLineStyle currStyle_ = null;
    private JComboBox cbAlpha_ = new JComboBox();
    private TdkStyleSpinner spWidth_ = new TdkStyleSpinner(false, this);
    private RendererObsever rendererObsever_ = new RendererObsever();
    private TdkStyleColorPanel colorChooser_ = new TdkStyleColorPanel(this);
    private static final long serialVersionUID = 8645821276853207693L;
    private boolean isObserving = false;

    public TdkStyleLineBasicTableRenderer(Observer observer) {
        this.rendererObsever_.addObserver(observer);
        this.spWidth_.setMaxMinValue(new Integer(20), new Integer(1), new Integer(1));
        for (int i = 0; i < 101; ++i) {
            this.cbAlpha_.addItem(new Integer(i));
        }
        this.initializeListeners();
    }

    public void updateRenderer(TdkLineStyleBasic tdkLineStyleBasic) {
        if (this.isObserving) {
            return;
        }
        if (tdkLineStyleBasic == null) {
            return;
        }
        this.currStyle_ = tdkLineStyleBasic;
        this.spWidth_.setValue(new Integer(tdkLineStyleBasic.width()));
        this.cbAlpha_.setSelectedItem(new Integer(tdkLineStyleBasic.transparency()));
        this.colorChooser_.setColor(tdkLineStyleBasic.color());
    }

    private void initializeListeners() {
        this.cbAlpha_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TdkStyleLineBasicTableRenderer.this.isObserving) {
                    return;
                }
                TdkStyleLineBasicTableRenderer.this.currStyle_.transparency(((Integer)TdkStyleLineBasicTableRenderer.this.cbAlpha_.getSelectedItem()).intValue());
                TdkStyleLineBasicTableRenderer.this.rendererObsever_.firechange(TdkStyleLineBasicTableRenderer.this.currStyle_);
            }
        });
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object instanceof Color) {
            this.currStyle_.setColor((Color)object);
        } else if (object instanceof Integer) {
            this.currStyle_.width(((Integer)object).intValue());
        }
        this.rendererObsever_.firechange(this.currStyle_);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (n == 0 && n2 == 0) {
            component = new JLabel(TdkComponentsI18n.getString("PNL_STYLE_LINE_WIDTH_LABEL"));
        } else if (n == 1 && n2 == 0) {
            component = new JLabel(TdkComponentsI18n.getString("PNL_STYLE_COLOR_LABEL"));
        } else if (n == 2 && n2 == 0) {
            component = new JLabel(TdkComponentsI18n.getString("PNL_STYLE_TRANSPARENCY_LABEL"));
        } else if (n == 0 && n2 == 1) {
            component = this.spWidth_;
        } else if (n == 1 && n2 == 1) {
            component = this.colorChooser_;
        } else if (n == 2 && n2 == 1) {
            component = this.cbAlpha_;
        }
        return component;
    }

    public TdkStyleColorPanel getColorChooser() {
        return this.colorChooser_;
    }

    public void setColorChooser(TdkStyleColorPanel tdkStyleColorPanel) {
        this.colorChooser_ = tdkStyleColorPanel;
    }

    public JComboBox getSlAlpha() {
        return this.cbAlpha_;
    }

    public void setSlAlpha(JComboBox jComboBox) {
        this.cbAlpha_ = jComboBox;
    }

    public TdkStyleSpinner getCbWidth() {
        return this.spWidth_;
    }

    public void setCbWidth(TdkStyleSpinner tdkStyleSpinner) {
        this.spWidth_ = tdkStyleSpinner;
    }

    private class RendererObsever
    extends Observable {
        private RendererObsever() {
        }

        public void firechange(Object object) {
            TdkStyleLineBasicTableRenderer.this.isObserving = true;
            this.setChanged();
            this.notifyObservers(object);
            this.clearChanged();
            TdkStyleLineBasicTableRenderer.this.isObserving = false;
        }
    }
}

