/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.dialogs.style.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import org.tecgraf.jtdk.core.swig.TdkPointStyle;
import org.tecgraf.jtdk.core.swig.TdkPointStyleBasic;
import org.tecgraf.jtdk.desktop.components.dialogs.style.table.TdkStyleColorPanel;
import org.tecgraf.jtdk.desktop.components.dialogs.style.table.TdkStyleSpinner;

public class TdkStylePointBasicTableRenderer
extends DefaultTableCellRenderer
implements Observer {
    private static final long serialVersionUID = 8645821276853207693L;
    private JLabel lbSize_ = new JLabel("Tamanho");
    private TdkStyleSpinner spSize_ = new TdkStyleSpinner(false, this);
    private JLabel lbCor_ = new JLabel("Cor");
    private TdkStyleColorPanel colorChooser_ = new TdkStyleColorPanel(this);
    private JLabel lbAlpha_ = new JLabel("Transpar\u00eancia");
    private JComboBox cbAlpha_ = new JComboBox();
    private JLabel lbOffsetX_ = new JLabel("OffSet X");
    private TdkStyleSpinner spOffSetX_ = new TdkStyleSpinner(true, this);
    private JLabel lbOffsetY_ = new JLabel("OffSet Y");
    private TdkStyleSpinner spOffSetY_ = new TdkStyleSpinner(true, this);
    private JCheckBox ckFixedSize_ = new JCheckBox();
    private TdkPointStyle currStyle_ = null;
    private RendererObsever rendererObsever_ = new RendererObsever();
    private boolean isObserving = false;

    public TdkStylePointBasicTableRenderer(Observer observer) {
        this.rendererObsever_.addObserver(observer);
        this.spSize_.setMaxMinValue(new Integer(10000), new Integer(0), new Integer(1));
        this.spOffSetX_.setMaxMinValue(new Double(100.0), new Double(-100.0), new Double(0.1));
        this.spOffSetY_.setMaxMinValue(new Double(100.0), new Double(-100.0), new Double(0.1));
        for (int i = 0; i < 101; ++i) {
            this.cbAlpha_.addItem(new Integer(i));
        }
        this.cbAlpha_.setEditable(false);
        this.ckFixedSize_.setBackground(Color.WHITE);
        this.initializeListeners();
    }

    public void updateRenderer(TdkPointStyleBasic tdkPointStyleBasic) {
        if (tdkPointStyleBasic == null) {
            return;
        }
        this.currStyle_ = tdkPointStyleBasic;
        this.cbAlpha_.setSelectedItem(new Integer(tdkPointStyleBasic.getTransparency()));
        this.spOffSetX_.setValue(new Double(tdkPointStyleBasic.getOffsetX()));
        this.spOffSetY_.setValue(new Double(tdkPointStyleBasic.getOffsetY()));
        this.spSize_.setValue(new Integer(tdkPointStyleBasic.getSize()));
        this.colorChooser_.setColor(tdkPointStyleBasic.getColor());
        this.ckFixedSize_.setSelected(this.currStyle_.getFixedSize());
    }

    private void initializeListeners() {
        this.cbAlpha_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TdkStylePointBasicTableRenderer.this.isObserving) {
                    return;
                }
                int n = 0;
                try {
                    n = (Integer)TdkStylePointBasicTableRenderer.this.cbAlpha_.getSelectedItem();
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, "Somente \u00e9 permitida a antrada de valores num\u00e9ricos");
                    return;
                }
                if (n < 0 || n > 100) {
                    JOptionPane.showMessageDialog(null, "Somente s\u00e3o suportados valores entre 0 e 100.");
                    return;
                }
                TdkStylePointBasicTableRenderer.this.currStyle_.setTransparency(((Integer)TdkStylePointBasicTableRenderer.this.cbAlpha_.getSelectedItem()).intValue());
                TdkStylePointBasicTableRenderer.this.rendererObsever_.firechange(TdkStylePointBasicTableRenderer.this.currStyle_);
            }
        });
        this.ckFixedSize_.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (TdkStylePointBasicTableRenderer.this.isObserving) {
                    return;
                }
                TdkStylePointBasicTableRenderer.this.currStyle_.setFixedSize(TdkStylePointBasicTableRenderer.this.ckFixedSize_.isSelected());
                TdkStylePointBasicTableRenderer.this.rendererObsever_.firechange(TdkStylePointBasicTableRenderer.this.currStyle_);
            }
        });
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object instanceof Color) {
            this.currStyle_.setColor((Color)object);
        } else {
            this.currStyle_.setSize(this.spSize_.getIntegerValue());
            this.currStyle_.setOffsetX(this.spOffSetX_.getDoubleValue());
            this.currStyle_.setOffsetY(this.spOffSetY_.getDoubleValue());
        }
        this.rendererObsever_.firechange(this.currStyle_);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (this.currStyle_ == null) {
            return component;
        }
        if (n == 0 && n2 == 0) {
            component = this.lbSize_;
        } else if (n == 1 && n2 == 0) {
            component = this.lbCor_;
        } else if (n == 2 && n2 == 0) {
            component = this.lbAlpha_;
        } else if (n == 3 && n2 == 0) {
            component = this.lbOffsetX_;
        } else if (n == 4 && n2 == 0) {
            component = this.lbOffsetY_;
        } else if (n == 5 && n2 == 0) {
            component = new JLabel("Tamanho fixo");
        } else if (n == 0 && n2 == 1) {
            component = this.spSize_;
        } else if (n == 1 && n2 == 1) {
            component = this.colorChooser_;
        } else if (n == 2 && n2 == 1) {
            component = this.cbAlpha_;
        } else if (n == 3 && n2 == 1) {
            component = this.spOffSetX_;
        } else if (n == 4 && n2 == 1) {
            component = this.spOffSetY_;
        } else if (n == 5 && n2 == 1) {
            component = this.ckFixedSize_;
        }
        return component;
    }

    public TdkStyleColorPanel getColorChooser() {
        return this.colorChooser_;
    }

    public JComboBox getSlAlpha() {
        return this.cbAlpha_;
    }

    public void setSlAlpha(JComboBox jComboBox) {
        this.cbAlpha_ = jComboBox;
    }

    public TdkStyleSpinner getSlOffSetX() {
        return this.spOffSetX_;
    }

    public void setSlOffSetX(TdkStyleSpinner tdkStyleSpinner) {
        this.spOffSetX_ = tdkStyleSpinner;
    }

    public TdkStyleSpinner getSlOffSetY() {
        return this.spOffSetY_;
    }

    public void setSlOffSetY(TdkStyleSpinner tdkStyleSpinner) {
        this.spOffSetY_ = tdkStyleSpinner;
    }

    public TdkStyleSpinner getCbSize() {
        return this.spSize_;
    }

    public void setCbSize(TdkStyleSpinner tdkStyleSpinner) {
        this.spSize_ = tdkStyleSpinner;
    }

    public JCheckBox getCkFixedSize_() {
        return this.ckFixedSize_;
    }

    public void setCkFixedSize(JCheckBox jCheckBox) {
        this.ckFixedSize_ = jCheckBox;
    }

    private class RendererObsever
    extends Observable {
        private RendererObsever() {
        }

        public void firechange(Object object) {
            this.setChanged();
            TdkStylePointBasicTableRenderer.this.isObserving = true;
            this.notifyObservers(object);
            TdkStylePointBasicTableRenderer.this.isObserving = false;
        }
    }
}

