/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.dialogs.style.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.tecgraf.jtdk.core.swig.TdkPointStyleBitmap;
import org.tecgraf.jtdk.desktop.components.TdkComponentsI18n;
import org.tecgraf.jtdk.desktop.components.dialogs.style.table.TdkStyleColorPanel;
import org.tecgraf.jtdk.desktop.components.dialogs.style.table.TdkStyleSpinner;

public class TdkStylePointBitmapTableRenderer
extends DefaultTableCellRenderer
implements Observer {
    private static final long serialVersionUID = 8645821276853207693L;
    private TdkStyleSpinner cbSize_ = new TdkStyleSpinner(false, this);
    private TdkStyleColorPanel chooser = new TdkStyleColorPanel(this);
    private JComboBox cbWidth_ = new JComboBox();
    private JComboBox cbHeight_ = new JComboBox();
    private TdkStyleSpinner spOffSetX_ = new TdkStyleSpinner(true, this);
    private TdkStyleSpinner spOffSetY_ = new TdkStyleSpinner(true, this);
    private TdkPointStyleBitmap currStyle_ = null;
    private RendererObsever rendererObsever_ = new RendererObsever();
    boolean isObserving = false;

    public TdkStylePointBitmapTableRenderer(Observer observer) {
        this.rendererObsever_.addObserver(observer);
        this.initializeListeners();
        this.spOffSetX_.setMaxMinValue(new Double(100.0), new Double(-100.0), new Double(0.1));
        this.spOffSetY_.setMaxMinValue(new Double(100.0), new Double(-100.0), new Double(0.1));
    }

    private void initializeListeners() {
        this.cbWidth_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TdkStylePointBitmapTableRenderer.this.isObserving) {
                    return;
                }
                if (TdkStylePointBitmapTableRenderer.this.cbHeight_.getSelectedItem() == null) {
                    return;
                }
                if (TdkStylePointBitmapTableRenderer.this.cbWidth_.getSelectedItem() == null) {
                    return;
                }
                int n = Integer.parseInt((String)TdkStylePointBitmapTableRenderer.this.cbWidth_.getSelectedItem());
                int n2 = Integer.parseInt((String)TdkStylePointBitmapTableRenderer.this.cbHeight_.getSelectedItem());
                TdkStylePointBitmapTableRenderer.this.currStyle_.setDimensions(n, n2);
                TdkStylePointBitmapTableRenderer.this.clearBitmap(TdkStylePointBitmapTableRenderer.this.currStyle_);
            }
        });
        this.cbHeight_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TdkStylePointBitmapTableRenderer.this.isObserving) {
                    return;
                }
                if (TdkStylePointBitmapTableRenderer.this.cbHeight_.getSelectedItem() == null) {
                    return;
                }
                if (TdkStylePointBitmapTableRenderer.this.cbWidth_.getSelectedItem() == null) {
                    return;
                }
                int n = Integer.parseInt((String)TdkStylePointBitmapTableRenderer.this.cbWidth_.getSelectedItem());
                int n2 = Integer.parseInt((String)TdkStylePointBitmapTableRenderer.this.cbHeight_.getSelectedItem());
                TdkStylePointBitmapTableRenderer.this.currStyle_.setDimensions(n, n2);
                TdkStylePointBitmapTableRenderer.this.clearBitmap(TdkStylePointBitmapTableRenderer.this.currStyle_);
            }
        });
    }

    public void clearBitmap(TdkPointStyleBitmap tdkPointStyleBitmap) {
        if (tdkPointStyleBitmap == null) {
            return;
        }
        int n = tdkPointStyleBitmap.getWidth();
        int n2 = tdkPointStyleBitmap.getHeight();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                tdkPointStyleBitmap.setBit(n, n2, true);
            }
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (this.currStyle_ == null) {
            return component;
        }
        if (n == 0 && n2 == 0) {
            component = new JLabel(TdkComponentsI18n.getString("PNL_STYLE_SIZE_LABEL"));
        } else if (n == 1 && n2 == 0) {
            component = new JLabel(TdkComponentsI18n.getString("PNL_STYLE_COLOR_LABEL"));
        } else if (n == 2 && n2 == 0) {
            component = new JLabel(TdkComponentsI18n.getString("PNL_STYLE_COLUMNS_LABEL"));
        } else if (n == 3 && n2 == 0) {
            component = new JLabel(TdkComponentsI18n.getString("PNL_STYLE_ROWS_LABEL"));
        } else if (n == 4 && n2 == 0) {
            component = new JLabel(TdkComponentsI18n.getString("PNL_STYLE_POINT_OFFSET_X_LABEL"));
        } else if (n == 5 && n2 == 0) {
            component = new JLabel(TdkComponentsI18n.getString("PNL_STYLE_POINT_OFFSET_Y_LABEL"));
        } else if (n == 0 && n2 == 1) {
            component = this.cbSize_;
        } else if (n == 1 && n2 == 1) {
            component = this.chooser;
        } else if (n == 2 && n2 == 1) {
            component = this.cbWidth_;
        } else if (n == 3 && n2 == 1) {
            component = this.cbHeight_;
        } else if (n == 4 && n2 == 1) {
            component = this.spOffSetX_;
        } else if (n == 5 && n2 == 1) {
            component = this.spOffSetY_;
        }
        return component;
    }

    public TdkStyleSpinner getCbSize() {
        return this.cbSize_;
    }

    public void setCbSize(TdkStyleSpinner tdkStyleSpinner) {
        this.cbSize_ = tdkStyleSpinner;
    }

    public JComboBox getCbHeight() {
        return this.cbHeight_;
    }

    public void setCbHeight(JComboBox jComboBox) {
        this.cbHeight_ = jComboBox;
    }

    public JComboBox getCbWidth() {
        return this.cbWidth_;
    }

    public void setCbWidth(JComboBox jComboBox) {
        this.cbWidth_ = jComboBox;
    }

    public TdkStyleColorPanel getChooser() {
        return this.chooser;
    }

    public void setChooser(TdkStyleColorPanel tdkStyleColorPanel) {
        this.chooser = tdkStyleColorPanel;
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object instanceof Double) {
            this.currStyle_.setOffsetX(this.spOffSetX_.getDoubleValue());
            this.currStyle_.setOffsetY(this.spOffSetY_.getDoubleValue());
        } else if (object instanceof Color) {
            this.currStyle_.setColor((Color)object);
        } else if (object instanceof Integer) {
            this.currStyle_.setSize(this.cbSize_.getIntegerValue());
            if (this.cbWidth_.getSelectedItem() != null && this.cbHeight_.getSelectedItem() != null) {
                int n = Integer.parseInt((String)this.cbWidth_.getSelectedItem());
                int n2 = Integer.parseInt((String)this.cbHeight_.getSelectedItem());
                this.currStyle_.setDimensions(n, n2);
            }
        }
        this.rendererObsever_.firechange(this.currStyle_);
    }

    public void updateRenderer(TdkPointStyleBitmap tdkPointStyleBitmap) {
        int n;
        if (tdkPointStyleBitmap == null) {
            return;
        }
        this.isObserving = true;
        this.currStyle_ = tdkPointStyleBitmap;
        this.cbSize_.setValue(new Integer(this.currStyle_.getSize()));
        this.chooser.setColor(this.currStyle_.getColor());
        this.spOffSetX_.setValue(new Double(this.currStyle_.getOffsetX()));
        this.spOffSetY_.setValue(new Double(this.currStyle_.getOffsetY()));
        for (n = 8; n <= 40; ++n) {
            this.cbWidth_.addItem(String.valueOf(n));
            this.cbHeight_.addItem(String.valueOf(n));
        }
        n = this.currStyle_.getWidth();
        int n2 = this.currStyle_.getHeight();
        if (n2 < 8) {
            n2 = 8;
        }
        if (n < 8) {
            n = 8;
        }
        this.cbWidth_.setSelectedItem(String.valueOf(n));
        this.cbHeight_.setSelectedItem(String.valueOf(n2));
        this.isObserving = false;
    }

    public TdkStyleSpinner getSpOffSetX_() {
        return this.spOffSetX_;
    }

    public void setSpOffSetX_(TdkStyleSpinner tdkStyleSpinner) {
        this.spOffSetX_ = tdkStyleSpinner;
    }

    public TdkStyleSpinner getSpOffSetY_() {
        return this.spOffSetY_;
    }

    public void setSpOffSetY_(TdkStyleSpinner tdkStyleSpinner) {
        this.spOffSetY_ = tdkStyleSpinner;
    }

    private class RendererObsever
    extends Observable {
        private RendererObsever() {
        }

        public void firechange(Object object) {
            TdkStylePointBitmapTableRenderer.this.isObserving = true;
            this.setChanged();
            this.notifyObservers(object);
            TdkStylePointBitmapTableRenderer.this.isObserving = false;
        }
    }
}

