/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.dialogs.style.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import org.tecgraf.jtdk.core.swig.TdkPointStyle;
import org.tecgraf.jtdk.core.swig.TdkPointStyleChar;
import org.tecgraf.jtdk.desktop.components.TdkComponentsI18n;
import org.tecgraf.jtdk.desktop.components.dialogs.style.table.TdkStyleColorPanel;
import org.tecgraf.jtdk.desktop.components.dialogs.style.table.TdkStyleSpinner;

public class TdkStylePointCharTableRenderer
extends DefaultTableCellRenderer
implements Observer {
    private static final long serialVersionUID = 5349561057699741622L;
    private JComboBox cbFont = new JComboBox();
    private JComboBox cbStyle = new JComboBox();
    private TdkStyleSpinner spSize = new TdkStyleSpinner(false, this);
    private TdkStyleColorPanel colorChooser_ = new TdkStyleColorPanel(this);
    private TdkStyleSpinner spOffSetX_ = new TdkStyleSpinner(true, this);
    private TdkStyleSpinner spOffSetY_ = new TdkStyleSpinner(true, this);
    private TdkPointStyleChar currStyle_ = null;
    private RendererObsever rendererObsever_ = new RendererObsever();
    private JCheckBox ckFixedSize_ = new JCheckBox();
    private boolean isObserving = false;

    public TdkStylePointCharTableRenderer(Observer observer) {
        this.rendererObsever_.addObserver(observer);
        this.spOffSetX_.setMaxMinValue(new Double(100.0), new Double(-100.0), new Double(0.1));
        this.spOffSetY_.setMaxMinValue(new Double(100.0), new Double(-100.0), new Double(0.1));
        this.spSize.setMaxMinValue(new Integer(48), new Integer(10), new Integer(1));
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] fontArray = graphicsEnvironment.getAllFonts();
        for (int i = 0; i < fontArray.length; ++i) {
            this.cbFont.addItem(fontArray[i].getName());
        }
        this.cbStyle.addItem(TdkComponentsI18n.getString("PNL_STYLE_TEXT_TYPE_PLAIN"));
        this.cbStyle.addItem(TdkComponentsI18n.getString("PNL_STYLE_TEXT_TYPE_ITALIC"));
        this.cbStyle.addItem(TdkComponentsI18n.getString("PNL_STYLE_TEXT_TYPE_BOLD"));
        this.cbStyle.addItem(TdkComponentsI18n.getString("PNL_STYLE_TEXT_TYPE_ITALIC_BOLD"));
        this.ckFixedSize_.setBackground(Color.WHITE);
        this.initializeListeners();
    }

    private void initializeListeners() {
        this.cbFont.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TdkStylePointCharTableRenderer.this.isObserving) {
                    return;
                }
                TdkStylePointCharTableRenderer.this.currStyle_.setFont((String)TdkStylePointCharTableRenderer.this.cbFont.getSelectedItem());
                TdkStylePointCharTableRenderer.this.rendererObsever_.firechange(TdkStylePointCharTableRenderer.this.currStyle_);
            }
        });
        this.cbStyle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TdkStylePointCharTableRenderer.this.isObserving) {
                    return;
                }
                Font font = null;
                switch (TdkStylePointCharTableRenderer.this.cbStyle.getSelectedIndex()) {
                    case 0: {
                        font = new Font((String)TdkStylePointCharTableRenderer.this.cbFont.getSelectedItem(), 0, TdkStylePointCharTableRenderer.this.spSize.getIntegerValue());
                        break;
                    }
                    case 1: {
                        font = new Font((String)TdkStylePointCharTableRenderer.this.cbFont.getSelectedItem(), 2, TdkStylePointCharTableRenderer.this.spSize.getIntegerValue());
                        break;
                    }
                    case 2: {
                        font = new Font((String)TdkStylePointCharTableRenderer.this.cbFont.getSelectedItem(), 1, TdkStylePointCharTableRenderer.this.spSize.getIntegerValue());
                        break;
                    }
                    case 3: {
                        font = new Font((String)TdkStylePointCharTableRenderer.this.cbFont.getSelectedItem(), 0, TdkStylePointCharTableRenderer.this.spSize.getIntegerValue());
                        break;
                    }
                    default: {
                        return;
                    }
                }
                TdkStylePointCharTableRenderer.this.currStyle_.setFont(font.getName());
                TdkStylePointCharTableRenderer.this.rendererObsever_.firechange(TdkStylePointCharTableRenderer.this.currStyle_);
            }
        });
        this.ckFixedSize_.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (TdkStylePointCharTableRenderer.this.isObserving) {
                    return;
                }
                TdkStylePointCharTableRenderer.this.currStyle_.setFixedSize(TdkStylePointCharTableRenderer.this.ckFixedSize_.isSelected());
                TdkStylePointCharTableRenderer.this.rendererObsever_.firechange(TdkStylePointCharTableRenderer.this.currStyle_);
            }
        });
    }

    public void updateRenderer(TdkPointStyleChar tdkPointStyleChar) {
        if (tdkPointStyleChar == null) {
            return;
        }
        this.currStyle_ = tdkPointStyleChar;
        this.colorChooser_.setColor(this.currStyle_.getColor());
        this.cbFont.setSelectedItem(this.currStyle_.getFont());
        this.spSize.setValue(new Integer(this.currStyle_.getSize()));
        this.spOffSetX_.setValue(new Double(this.currStyle_.getOffsetX()));
        this.spOffSetY_.setValue(new Double(this.currStyle_.getOffsetY()));
        this.ckFixedSize_.setSelected(this.currStyle_.getFixedSize());
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (this.currStyle_ == null) {
            return component;
        }
        if (n == 0 && n2 == 0) {
            component = new JLabel(TdkComponentsI18n.getString("PNL_STYLE_FONT_LABEL"));
        } else if (n == 0 && n2 == 1) {
            component = this.cbFont;
        } else if (n == 1 && n2 == 0) {
            component = new JLabel(TdkComponentsI18n.getString("PNL_STYLE_TEXT_STYLE_LABEL"));
        } else if (n == 1 && n2 == 1) {
            component = this.cbStyle;
        } else if (n == 2 && n2 == 0) {
            component = new JLabel(TdkComponentsI18n.getString("PNL_STYLE_SIZE_LABEL"));
        } else if (n == 2 && n2 == 1) {
            component = this.spSize;
        } else if (n == 3 && n2 == 0) {
            component = new JLabel(TdkComponentsI18n.getString("PNL_STYLE_COLOR_LABEL"));
        } else if (n == 3 && n2 == 1) {
            component = this.colorChooser_;
        } else if (n == 4 && n2 == 0) {
            component = new JLabel(TdkComponentsI18n.getString("PNL_STYLE_POINT_OFFSET_X_LABEL"));
        } else if (n == 4 && n2 == 1) {
            component = this.spOffSetX_;
        } else if (n == 5 && n2 == 0) {
            component = new JLabel(TdkComponentsI18n.getString("PNL_STYLE_POINT_OFFSET_Y_LABEL"));
        } else if (n == 5 && n2 == 1) {
            component = this.spOffSetY_;
        } else if (n == 6 && n2 == 0) {
            component = new JLabel(TdkComponentsI18n.getString("PNL_STYLE_POINT_FIXED_SIZE_LABEL"));
        } else if (n == 6 && n2 == 1) {
            component = this.ckFixedSize_;
        }
        return component;
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object instanceof Color) {
            this.currStyle_.setColor((Color)object);
        } else if (object instanceof Integer) {
            this.currStyle_.setSize(this.spSize.getIntegerValue());
        } else if (object instanceof Double) {
            this.currStyle_.setOffsetX(this.spOffSetX_.getDoubleValue());
            this.currStyle_.setOffsetY(this.spOffSetY_.getDoubleValue());
        }
        this.rendererObsever_.firechange(this.currStyle_);
    }

    public TdkPointStyle getCurrStyle_() {
        return this.currStyle_;
    }

    public void setCurrStyle(TdkPointStyleChar tdkPointStyleChar) {
        this.currStyle_ = tdkPointStyleChar;
    }

    public RendererObsever getRendererObsever_() {
        return this.rendererObsever_;
    }

    public void setRendererObsever_(RendererObsever rendererObsever) {
        this.rendererObsever_ = rendererObsever;
    }

    public TdkStyleSpinner getSpOffSetX_() {
        return this.spOffSetX_;
    }

    public void setSpOffSetX_(TdkStyleSpinner tdkStyleSpinner) {
        this.spOffSetX_ = tdkStyleSpinner;
    }

    public TdkStyleSpinner getSpOffSetY_() {
        return this.spOffSetY_;
    }

    public void setSpOffSetY_(TdkStyleSpinner tdkStyleSpinner) {
        this.spOffSetY_ = tdkStyleSpinner;
    }

    public JComboBox getCbFont() {
        return this.cbFont;
    }

    public void setCbFont(JComboBox jComboBox) {
        this.cbFont = jComboBox;
    }

    public JComboBox getCbStyle() {
        return this.cbStyle;
    }

    public void setCbStyle(JComboBox jComboBox) {
        this.cbStyle = jComboBox;
    }

    public TdkStyleSpinner getSpSize() {
        return this.spSize;
    }

    public void setSpSize(TdkStyleSpinner tdkStyleSpinner) {
        this.spSize = tdkStyleSpinner;
    }

    public TdkStyleColorPanel getColorChooser_() {
        return this.colorChooser_;
    }

    public void setColorChooser(TdkStyleColorPanel tdkStyleColorPanel) {
        this.colorChooser_ = tdkStyleColorPanel;
    }

    public JCheckBox getCkFixedSize_() {
        return this.ckFixedSize_;
    }

    private class RendererObsever
    extends Observable {
        private RendererObsever() {
        }

        public void firechange(Object object) {
            TdkStylePointCharTableRenderer.this.isObserving = true;
            this.setChanged();
            this.notifyObservers(object);
            TdkStylePointCharTableRenderer.this.isObserving = false;
        }
    }
}

