/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.dialogs.style.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.tecgraf.jtdk.core.swig.TdkPolygonStyleBasic;
import org.tecgraf.jtdk.desktop.components.TdkComponentsI18n;
import org.tecgraf.jtdk.desktop.components.dialogs.style.table.TdkStyleColorPanel;

public class TdkStylePolygonBasicTableRenderer
extends DefaultTableCellRenderer
implements Observer {
    private static final long serialVersionUID = 8645821276853207693L;
    private TdkStyleColorPanel colorChooser_ = new TdkStyleColorPanel(this);
    private JComboBox cbAlpha_ = new JComboBox();
    private RendererObsever rendererObsever_ = new RendererObsever();
    private TdkPolygonStyleBasic currStyle_ = null;
    private boolean isObserving = false;

    public TdkStylePolygonBasicTableRenderer(Observer observer) {
        for (int i = 0; i < 101; ++i) {
            this.cbAlpha_.addItem(new Integer(i));
        }
        this.initializeListners();
        this.rendererObsever_.addObserver(observer);
    }

    private void initializeListners() {
        this.cbAlpha_.setBackground(Color.WHITE);
        this.cbAlpha_.setForeground(Color.BLACK);
        this.cbAlpha_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TdkStylePolygonBasicTableRenderer.this.isObserving) {
                    return;
                }
                TdkStylePolygonBasicTableRenderer.this.currStyle_.setTransparency(((Integer)TdkStylePolygonBasicTableRenderer.this.cbAlpha_.getSelectedItem()).intValue());
                TdkStylePolygonBasicTableRenderer.this.rendererObsever_.firechange(TdkStylePolygonBasicTableRenderer.this.currStyle_);
            }
        });
    }

    public void updateRenderer(TdkPolygonStyleBasic tdkPolygonStyleBasic) {
        if (this.isObserving) {
            return;
        }
        this.currStyle_ = tdkPolygonStyleBasic;
        this.cbAlpha_.setSelectedItem(new Integer(tdkPolygonStyleBasic.getTransparency()));
        this.colorChooser_.setColor(tdkPolygonStyleBasic.getColor());
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (n == 0 && n2 == 0) {
            component = new JLabel(TdkComponentsI18n.getString("PNL_STYLE_COLOR_LABEL"));
        } else if (n == 1 && n2 == 0) {
            component = new JLabel(TdkComponentsI18n.getString("PNL_STYLE_TRANSPARENCY_LABEL"));
        } else if (n == 0 && n2 == 1) {
            component = this.colorChooser_;
        } else if (n == 1 && n2 == 1) {
            component = this.cbAlpha_;
        }
        return component;
    }

    public TdkStyleColorPanel getColorChooser() {
        return this.colorChooser_;
    }

    public void setColorChooser(TdkStyleColorPanel tdkStyleColorPanel) {
        this.colorChooser_ = tdkStyleColorPanel;
    }

    public JComboBox getSlAlpha() {
        return this.cbAlpha_;
    }

    public void setSlAlpha(JComboBox jComboBox) {
        this.cbAlpha_ = jComboBox;
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object instanceof Color) {
            this.currStyle_.setColor((Color)object);
        }
        this.rendererObsever_.firechange(this.currStyle_);
    }

    private class RendererObsever
    extends Observable {
        private RendererObsever() {
        }

        public void firechange(Object object) {
            TdkStylePolygonBasicTableRenderer.this.isObserving = true;
            this.setChanged();
            this.notifyObservers(object);
            TdkStylePolygonBasicTableRenderer.this.isObserving = false;
        }
    }
}

