/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.dialogs.style.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.tecgraf.jtdk.core.swig.TdkPolygonStyle;
import org.tecgraf.jtdk.core.swig.TdkPolygonStyleBitmap;
import org.tecgraf.jtdk.desktop.components.TdkComponentsI18n;
import org.tecgraf.jtdk.desktop.components.dialogs.style.table.TdkStyleColorPanel;

public class TdkStylePolygonBitmapTableRenderer
extends DefaultTableCellRenderer
implements Observer {
    private static final long serialVersionUID = 8893656864204650915L;
    private JLabel lbFCor_ = new JLabel(TdkComponentsI18n.getString("PNL_STYLE_COLOR_LABEL"));
    private TdkStyleColorPanel fColorPanel = new TdkStyleColorPanel(this);
    private Color fOldColor = new Color(255, 255, 255);
    private JLabel lbWidth_ = new JLabel(TdkComponentsI18n.getString("PNL_STYLE_COLUMNS_LABEL"));
    private JComboBox cbWidth_ = new JComboBox();
    private JLabel lbHeight_ = new JLabel(TdkComponentsI18n.getString("PNL_STYLE_ROWS_LABEL"));
    private JComboBox cbHeight_ = new JComboBox();
    private JLabel lbBCor_ = new JLabel(TdkComponentsI18n.getString("PNL_STYLE_BACKGROUND_COLOR_LABEL"));
    private TdkStyleColorPanel bColorPanel = new TdkStyleColorPanel(this);
    private Color bOldColor = new Color(255, 128, 0);
    private TdkPolygonStyleBitmap currStyle_ = null;
    private RendererObsever rendererObsever_ = new RendererObsever();
    boolean actionFlag = false;

    public TdkStylePolygonBitmapTableRenderer(Observer observer) {
        this.rendererObsever_.addObserver(observer);
        this.initializeListeners();
    }

    public void load(TdkPolygonStyle tdkPolygonStyle) {
        int n;
        if (!(tdkPolygonStyle instanceof TdkPolygonStyleBitmap)) {
            return;
        }
        this.currStyle_ = (TdkPolygonStyleBitmap)tdkPolygonStyle;
        this.fColorPanel.setColor(this.currStyle_.getColor());
        this.bColorPanel.setColor(this.currStyle_.getBackgroundColor());
        for (n = 10; n <= 50; ++n) {
            this.cbWidth_.addItem(String.valueOf(n));
            this.cbHeight_.addItem(String.valueOf(n));
        }
        n = this.currStyle_.getWidth();
        int n2 = this.currStyle_.getHeight();
        if (n2 < 10) {
            n2 = 10;
        }
        if (n < 10) {
            n = 10;
        }
        this.cbWidth_.setSelectedItem(String.valueOf(10));
        this.cbHeight_.setSelectedIndex(n2 - 10);
    }

    private void initializeListeners() {
        this.cbWidth_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!TdkStylePolygonBitmapTableRenderer.this.actionFlag) {
                    return;
                }
                if (TdkStylePolygonBitmapTableRenderer.this.cbHeight_.getSelectedItem() == null) {
                    return;
                }
                if (TdkStylePolygonBitmapTableRenderer.this.cbWidth_.getSelectedItem() == null) {
                    return;
                }
                int n = Integer.parseInt((String)TdkStylePolygonBitmapTableRenderer.this.cbWidth_.getSelectedItem());
                int n2 = Integer.parseInt((String)TdkStylePolygonBitmapTableRenderer.this.cbHeight_.getSelectedItem());
                TdkStylePolygonBitmapTableRenderer.this.clearBitmap(TdkStylePolygonBitmapTableRenderer.this.currStyle_);
                TdkStylePolygonBitmapTableRenderer.this.actionFlag = false;
            }
        });
        this.cbHeight_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!TdkStylePolygonBitmapTableRenderer.this.actionFlag) {
                    return;
                }
                if (TdkStylePolygonBitmapTableRenderer.this.cbHeight_.getSelectedItem() == null) {
                    return;
                }
                if (TdkStylePolygonBitmapTableRenderer.this.cbWidth_.getSelectedItem() == null) {
                    return;
                }
                int n = Integer.parseInt((String)TdkStylePolygonBitmapTableRenderer.this.cbWidth_.getSelectedItem());
                int n2 = Integer.parseInt((String)TdkStylePolygonBitmapTableRenderer.this.cbHeight_.getSelectedItem());
                TdkStylePolygonBitmapTableRenderer.this.clearBitmap(TdkStylePolygonBitmapTableRenderer.this.currStyle_);
                TdkStylePolygonBitmapTableRenderer.this.actionFlag = false;
            }
        });
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (this.currStyle_ == null) {
            return component;
        }
        if (n == 0 && n2 == 0) {
            component = this.lbFCor_;
        } else if (n == 1 && n2 == 0) {
            component = this.lbBCor_;
        } else if (n == 2 && n2 == 0) {
            component = this.lbWidth_;
        } else if (n == 3 && n2 == 0) {
            component = this.lbHeight_;
        } else if (n == 0 && n2 == 1) {
            component = this.fColorPanel;
        } else if (n == 1 && n2 == 1) {
            component = this.bColorPanel;
        } else if (n == 2 && n2 == 1) {
            component = this.cbWidth_;
        } else if (n == 3 && n2 == 1) {
            component = this.cbHeight_;
        }
        this.fOldColor = this.fColorPanel.getColor();
        this.bOldColor = this.bColorPanel.getColor();
        this.actionFlag = true;
        return component;
    }

    @Override
    public void update(Observable observable, Object object) {
        if (!this.fColorPanel.getColor().equals(this.fOldColor)) {
            this.currStyle_.setColor((Color)object);
        } else if (!this.bColorPanel.getColor().equals(this.bOldColor)) {
            this.currStyle_.setBackgroundColor((Color)object);
        }
        this.rendererObsever_.firechange(this.currStyle_);
    }

    public void updateRenderer(TdkPolygonStyleBitmap tdkPolygonStyleBitmap) {
        this.fColorPanel.setColor(tdkPolygonStyleBitmap.getColor());
        this.bColorPanel.setColor(tdkPolygonStyleBitmap.getBackgroundColor());
        this.cbWidth_.setSelectedItem(String.valueOf(tdkPolygonStyleBitmap.getWidth()));
        this.cbHeight_.setSelectedItem(String.valueOf(tdkPolygonStyleBitmap.getHeight()));
    }

    public JComboBox getCbHeight() {
        return this.cbHeight_;
    }

    public void setCbHeight(JComboBox jComboBox) {
        this.cbHeight_ = jComboBox;
    }

    public JComboBox getCbWidth() {
        return this.cbWidth_;
    }

    public void setCbWidth(JComboBox jComboBox) {
        this.cbWidth_ = jComboBox;
    }

    public TdkStyleColorPanel getBColorPanel() {
        return this.bColorPanel;
    }

    public void setBColorPanel(TdkStyleColorPanel tdkStyleColorPanel) {
        this.bColorPanel = tdkStyleColorPanel;
    }

    public TdkStyleColorPanel getFColorPanel() {
        return this.fColorPanel;
    }

    public void setFColorPanel(TdkStyleColorPanel tdkStyleColorPanel) {
        this.fColorPanel = tdkStyleColorPanel;
    }

    public void clearBitmap(TdkPolygonStyleBitmap tdkPolygonStyleBitmap) {
        if (tdkPolygonStyleBitmap == null) {
            return;
        }
        int n = tdkPolygonStyleBitmap.getWidth();
        int n2 = tdkPolygonStyleBitmap.getHeight();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                tdkPolygonStyleBitmap.setBit(n, n2, true);
            }
        }
    }

    private class RendererObsever
    extends Observable {
        private RendererObsever() {
        }

        public void firechange(Object object) {
            this.setChanged();
            this.notifyObservers(object);
        }
    }
}

