/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.dialogs.thematic;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class TdkNumberTableCell
extends AbstractCellEditor
implements TableCellRenderer,
TableCellEditor {
    private Comparable minimum_;
    private Comparable maximum_;
    private JComponent objSpn_;
    private Number stepSize_;

    public TdkNumberTableCell(Comparable comparable, Comparable comparable2, Number number) {
        this.minimum_ = comparable;
        this.maximum_ = comparable2;
        this.objSpn_ = null;
        this.stepSize_ = number;
    }

    public TdkNumberTableCell(double d, double d2, double d3) {
        this(new Double(d), new Double(d2), new Double(d3));
    }

    public TdkNumberTableCell(int n, int n2, int n3) {
        this(new Integer(n), new Integer(n2), new Integer(n3));
    }

    public TdkNumberTableCell() {
        this(null, null, null);
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            return ((MouseEvent)eventObject).getClickCount() >= 2;
        }
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        return ((JSpinner)this.objSpn_).getValue();
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.objSpn_ = new JTextField(((Number)object).toString(), 15);
        ((JTextField)this.objSpn_).setHorizontalAlignment(4);
        this.objSpn_.setFont(jTable.getFont());
        this.objSpn_.setBorder(bl2 ? UIManager.getBorder("Table.focusCellHighlightBorder") : new EmptyBorder(1, 1, 1, 1));
        if (!bl2 && bl && jTable.isCellEditable(n, n2)) {
            this.objSpn_.setBackground(new Color(jTable.getSelectionBackground().getRGB()));
            this.objSpn_.setForeground(new Color(jTable.getSelectionForeground().getRGB()));
        } else {
            this.objSpn_.setBackground(new Color(jTable.getBackground().getRGB()));
            this.objSpn_.setForeground(new Color(jTable.getForeground().getRGB()));
        }
        return this.objSpn_;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        if (bl && jTable.isCellEditable(n, n2)) {
            SpinnerNumberModel spinnerNumberModel;
            if (this.minimum_ == null && this.maximum_ == null && this.stepSize_ == null) {
                spinnerNumberModel = new SpinnerNumberModel();
                spinnerNumberModel.setValue(object);
            } else {
                spinnerNumberModel = new SpinnerNumberModel((Number)object, this.minimum_, this.maximum_, this.stepSize_);
            }
            this.objSpn_ = new JSpinner(spinnerNumberModel);
            this.objSpn_.setFont(jTable.getFont());
            this.objSpn_.setBorder(new LineBorder(Color.black));
        }
        return this.objSpn_;
    }
}

