/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.dialogs.thematic;

import java.awt.Color;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import org.tecgraf.jtdk.desktop.components.dialogs.thematic.TdkTableHeader;
import org.tecgraf.jtdk.desktop.components.dialogs.thematic.TdkTableModel;

public class TdkTable
extends JTable {
    protected TdkTableHeader headerRenderer_;

    public TdkTable(TdkTableModel tdkTableModel) {
        super(tdkTableModel);
        this.setRowHeight(20);
        this.headerRenderer_ = new TdkTableHeader();
        this.getTableHeader().addMouseListener(this.headerRenderer_.getHeaderListener());
    }

    public void deleteRow() {
        ((TdkTableModel)this.getModel()).removeRows(this.getSelectedRows());
        if (this.getRowCount() > 0) {
            this.setRowSelectionInterval(this.getRowCount() - 1, this.getRowCount() - 1);
        }
        this.headerRenderer_.clearState();
        this.getTableHeader().resizeAndRepaint();
    }

    protected static ImageIcon createImageIcon(URL uRL) {
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        return null;
    }

    public void insertRow() {
        ((TdkTableModel)this.getModel()).addNewRow();
        if (this.getRowCount() > 0) {
            this.setRowSelectionInterval(this.getRowCount() - 1, this.getRowCount() - 1);
        }
        this.headerRenderer_.clearState();
        this.getTableHeader().resizeAndRepaint();
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        if (TdkTableHeader.getColChecked() == this.getEditingColumn()) {
            this.headerRenderer_.setStateImgChecked(this.getEditingColumn(), true);
            this.getTableHeader().resizeAndRepaint();
        }
        super.editingStopped(changeEvent);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.setForeground(bl ? UIManager.getColor("Table.foreground") : Color.lightGray);
        this.setGridColor(bl ? UIManager.getColor("Table.gridColor") : Color.lightGray);
        super.setEnabled(bl);
    }
}

