/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.dialogs.thematic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import org.tecgraf.jtdk.desktop.components.dialogs.thematic.TdkTableModel;

public class TdkTableHeader
extends JLabel
implements TableCellRenderer,
Icon {
    private static final Color EDGE1 = UIManager.getColor("controlShadow");
    private static final Color EDGE2 = UIManager.getColor("controlHighlight");
    private static final Color FILL = UIManager.getColor("control");
    private static final Icon CHECKED = TdkTableHeader.createImageIcon("/org/tecgraf/jvipe/dialogs/icons/removeChecked.gif");
    private static final Icon UNCHECKED = TdkTableHeader.createImageIcon("/org/tecgraf/jvipe/dialogs/icons/removeUnchecked.gif");
    private static final int NO_COLCHECKED = -1;
    private static final int DEFAULT_SIZE = 9;
    public static final int NONE = 0;
    public static final int DOWN = 1;
    public static final int UP = 2;
    private static boolean enabled_;
    private static Hashtable stateDirection_;
    private static Hashtable stateImgChecked_;
    private static int colChecked_;
    private int direction_;
    private MouseAdapter headerListener_;

    public TdkTableHeader(int n, int n2) {
        enabled_ = true;
        stateDirection_ = new Hashtable();
        stateImgChecked_ = new Hashtable();
        if (n2 > -1) {
            colChecked_ = n2;
        }
        this.direction_ = 0;
        this.headerListener_ = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (enabled_ && mouseEvent.getSource() instanceof JTableHeader) {
                    JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
                    int n = jTableHeader.columnAtPoint(mouseEvent.getPoint());
                    TdkTableHeader.this.setState(n);
                    if (colChecked_ != n) {
                        ((TdkTableModel)jTableHeader.getTable().getModel()).sort(n, 1 == (Integer)TdkTableHeader.this.getState(n));
                    } else {
                        ((TdkTableModel)jTableHeader.getTable().getModel()).checkedAll(n, ((Icon)TdkTableHeader.this.getState(n)).equals(CHECKED));
                    }
                }
            }
        };
        this.setHorizontalAlignment(n);
        this.setHorizontalTextPosition(n);
        this.setIcon(colChecked_ > -1 ? UNCHECKED : null);
        LookAndFeel.installColorsAndFont(this, "TableHeader.background", "TableHeader.foreground", "TableHeader.font");
        LookAndFeel.installBorder(this, "TableHeader.cellBorder");
    }

    public TdkTableHeader(int n) {
        this(n, -1);
    }

    public TdkTableHeader() {
        this(2, -1);
    }

    public void clearState() {
        stateDirection_ = new Hashtable();
        stateImgChecked_ = new Hashtable();
    }

    protected static ImageIcon createImageIcon(String string) {
        URL uRL = TdkTableHeader.class.getClassLoader().getResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        return null;
    }

    private void drawDownArrow(Graphics graphics, int n, int n2) {
        graphics.setColor(EDGE1);
        graphics.drawLine(n, n2, n + 9 - 1, n2);
        graphics.drawLine(n, n2 + 1, n + 9 - 3, n2 + 1);
        graphics.setColor(EDGE2);
        graphics.drawLine(n + 9 - 2, n2 + 1, n + 9 - 1, n2 + 1);
        int n3 = n + 1;
        int n4 = n2 + 2;
        int n5 = 3;
        while (n4 + 1 < n2 + 9) {
            graphics.setColor(EDGE1);
            graphics.drawLine(n3, n4, n3 + 1, n4);
            graphics.drawLine(n3, n4 + 1, n3 + 1, n4 + 1);
            if (0 < n5) {
                graphics.setColor(FILL);
                graphics.drawLine(n3 + 2, n4, n3 + 1 + n5, n4);
                graphics.drawLine(n3 + 2, n4 + 1, n3 + 1 + n5, n4 + 1);
            }
            graphics.setColor(EDGE2);
            graphics.drawLine(n3 + n5 + 2, n4, n3 + n5 + 3, n4);
            graphics.drawLine(n3 + n5 + 2, n4 + 1, n3 + n5 + 3, n4 + 1);
            ++n3;
            n4 += 2;
            n5 -= 2;
        }
        graphics.setColor(EDGE1);
        graphics.drawLine(n + 4, n2 + 9 - 1, n + 4, n2 + 9 - 1);
    }

    private void drawUpArrow(Graphics graphics, int n, int n2) {
        graphics.setColor(EDGE1);
        int n3 = n + 4;
        graphics.drawLine(n3, n2, n3, n2);
        --n3;
        int n4 = n2 + 1;
        int n5 = 0;
        while (n4 + 3 < n2 + 9) {
            graphics.setColor(EDGE1);
            graphics.drawLine(n3, n4, n3 + 1, n4);
            graphics.drawLine(n3, n4 + 1, n3 + 1, n4 + 1);
            if (0 < n5) {
                graphics.setColor(FILL);
                graphics.drawLine(n3 + 2, n4, n3 + 1 + n5, n4);
                graphics.drawLine(n3 + 2, n4 + 1, n3 + 1 + n5, n4 + 1);
            }
            graphics.setColor(EDGE2);
            graphics.drawLine(n3 + n5 + 2, n4, n3 + n5 + 3, n4);
            graphics.drawLine(n3 + n5 + 2, n4 + 1, n3 + n5 + 3, n4 + 1);
            --n3;
            n4 += 2;
            n5 += 2;
        }
        graphics.setColor(EDGE1);
        graphics.drawLine(n, n2 + 9 - 3, n + 1, n2 + 9 - 3);
        graphics.setColor(EDGE2);
        graphics.drawLine(n + 2, n2 + 9 - 2, n + 9 - 1, n2 + 9 - 2);
        graphics.drawLine(n, n2 + 9 - 1, n + 9, n2 + 9 - 1);
    }

    public static int getColChecked() {
        return colChecked_;
    }

    public MouseAdapter getHeaderListener() {
        return this.headerListener_;
    }

    public Object getState(int n) {
        if (colChecked_ == n) {
            return this.getStateImgChecked(n);
        }
        return this.getStateDirection(n);
    }

    public void setState(int n) {
        if (n >= 0) {
            if (colChecked_ == n) {
                this.setStateImgChecked(n);
            } else {
                this.setStateDirection(n);
            }
        }
    }

    public Object getStateDirection(int n) {
        Object v = stateDirection_.get(new Integer(n));
        return new Integer(v == null ? 0 : ((Integer)v == 1 ? 1 : 2));
    }

    public void setStateDirection(int n) {
        Object v = stateDirection_.get(new Integer(n));
        stateDirection_.clear();
        stateDirection_.put(new Integer(n), v == null ? new Integer(1) : ((Integer)v == 1 ? new Integer(2) : new Integer(1)));
    }

    public Object getStateImgChecked(int n) {
        Object v = stateImgChecked_.get(new Integer(n));
        return v == null ? UNCHECKED : (((Icon)v).equals(CHECKED) ? CHECKED : UNCHECKED);
    }

    public void setStateImgChecked(int n, boolean bl) {
        Object v = stateImgChecked_.get(new Integer(n));
        stateImgChecked_.put(new Integer(n), bl ? UNCHECKED : (v == null ? CHECKED : (((Icon)v).equals(CHECKED) ? UNCHECKED : CHECKED)));
    }

    public void setStateImgChecked(int n) {
        this.setStateImgChecked(n, false);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.setText(object == null ? "" : object.toString());
        if (!bl2 && !bl && jTable.isCellEditable(n, n2) && jTable.isEnabled()) {
            enabled_ = true;
            this.setEnabled(true);
            if (colChecked_ == n2) {
                this.setIcon((Icon)this.getState(n2));
            } else {
                this.direction_ = (Integer)this.getState(n2);
                this.setIcon(this);
            }
        } else {
            enabled_ = false;
            this.setEnabled(false);
        }
        return this;
    }

    @Override
    public int getIconHeight() {
        return 9;
    }

    @Override
    public int getIconWidth() {
        return 9;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        if (component instanceof TdkTableHeader) {
            switch (this.direction_) {
                case 1: {
                    this.drawDownArrow(graphics, n, n2);
                    return;
                }
                case 2: {
                    this.drawUpArrow(graphics, n, n2);
                    return;
                }
            }
        }
    }

    static {
        colChecked_ = -1;
    }
}

