/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.dialogs.thematic;

import java.util.Date;
import javax.swing.table.DefaultTableModel;

public class TdkTableModel
extends DefaultTableModel {
    protected int[] indexes_;

    public TdkTableModel(Object[][] objectArray, Object[] objectArray2) {
        this.setDataVector(objectArray, objectArray2);
        this.allocateIndex();
    }

    public TdkTableModel() {
        this(new Object[0][0], new Object[0]);
    }

    public void addNewRow() {
        this.addRow(this.getNewRow());
        this.allocateIndex();
    }

    private void allocateIndex() {
        int n = this.getRowCount();
        this.indexes_ = new int[n];
        for (int i = 0; i < n; ++i) {
            this.indexes_[i] = i;
        }
    }

    public void checkedAll(int n, boolean bl) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.setValueAt(new Boolean(bl), i, n);
        }
        this.fireTableDataChanged();
    }

    private int compare(int n, int n2, int n3) {
        Object object = this.getValueAt(n2, n);
        Object object2 = this.getValueAt(n3, n);
        if (object == null && object2 == null) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        Class<?> clazz = this.getColumnClass(n);
        if (clazz.getSuperclass() == Number.class) {
            return this.compareValue((Number)object, (Number)object2);
        }
        if (clazz == Date.class) {
            return this.compareValue((Date)object, (Date)object2);
        }
        if (clazz == Boolean.class) {
            return this.compareValue((Boolean)object, (Boolean)object2);
        }
        return object.toString().compareTo(object2.toString());
    }

    private int compareValue(Number number, Number number2) {
        double d;
        double d2 = number.doubleValue();
        return d2 < (d = number2.doubleValue()) ? -1 : (d2 > d ? 1 : 0);
    }

    private int compareValue(Date date, Date date2) {
        long l;
        long l2 = date.getTime();
        return l2 < (l = date2.getTime()) ? -1 : (l2 > l ? 1 : 0);
    }

    private int compareValue(Boolean bl, Boolean bl2) {
        boolean bl3;
        boolean bl4 = bl;
        return bl4 == (bl3 = bl2.booleanValue()) ? 0 : (bl4 ? 1 : -1);
    }

    public void removeAllRows() {
        this.removeRows(this.getIndexes());
    }

    public void removeRows(int[] nArray) {
        this.allocateIndex();
        for (int i = nArray.length - 1; i >= 0; --i) {
            this.removeRow(nArray[i]);
        }
    }

    public void sort(int n, boolean bl) {
        int n2 = this.getRowCount();
        int[] nArray = this.getIndexes();
        for (int i = 0; i < n2 - 1; ++i) {
            int n3;
            int n4 = i;
            for (n3 = i + 1; n3 < n2; ++n3) {
                if (bl) {
                    if (this.compare(n, n3, n4) >= 0) continue;
                    n4 = n3;
                    continue;
                }
                if (this.compare(n, n3, n4) <= 0) continue;
                n4 = n3;
            }
            n3 = nArray[i];
            nArray[i] = nArray[n4];
            nArray[n4] = n3;
        }
        this.fireTableDataChanged();
    }

    private int[] getIndexes() {
        if (this.indexes_ != null && this.indexes_.length == this.getRowCount()) {
            return this.indexes_;
        }
        this.allocateIndex();
        return this.indexes_;
    }

    public Object[] getNewRow() {
        return new Object[0];
    }

    public Object[][] getCells() {
        if (this.getRowCount() <= 0 || this.getColumnCount() <= 0) {
            return new Object[0][0];
        }
        Object[][] objectArray = new Object[this.getRowCount()][this.getColumnCount()];
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                objectArray[i][j] = this.getValueAt(i, j);
            }
        }
        return objectArray;
    }

    public void setCells(Object[][] objectArray, Object[] objectArray2) {
        this.setDataVector(objectArray, objectArray2);
        this.allocateIndex();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return super.getValueAt(this.indexes_ != null ? this.indexes_[n] : n, n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        super.setValueAt(object, this.indexes_ != null ? this.indexes_[n] : n, n2);
    }
}

