/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.dialogs.thematic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.core.swig.TdkSetup;
import org.tecgraf.jtdk.core.swig.TdkTheme;
import org.tecgraf.jtdk.core.swig.TdkThemeGID;
import org.tecgraf.jtdk.core.swig.TeAttributeDataType;
import org.tecgraf.jtdk.core.swig.TeGroupingMode;
import org.tecgraf.jtdk.core.swig.TeLegendEntryVector;
import org.tecgraf.jtdk.desktop.components.TdkComponentsI18n;
import org.tecgraf.jtdk.desktop.components.dialogs.thematic.TdkGroupingModeDesc;
import org.tecgraf.jtdk.desktop.components.dialogs.thematic.TdkItemComboBox;
import org.tecgraf.jtdk.desktop.components.dialogs.thematic.TdkItemComboBoxRenderer;
import org.tecgraf.jtdk.desktop.components.dialogs.thematic.TdkThematicDialogCallback;
import org.tecgraf.jtdk.desktop.components.dialogs.thematic.TdkThematicDialogInput;
import org.tecgraf.jtdk.desktop.components.dialogs.thematic.TdkThematicDialogState;
import org.tecgraf.jtdk.desktop.components.dialogs.thematic.TdkThematicTable;
import org.tecgraf.jtdk.desktop.components.dialogs.thematic.TdkThematicTableModel;
import org.tecgraf.jtdk.desktop.components.util.TdkColorDefaultPallete;
import org.tecgraf.jtdk.desktop.components.util.TdkStyleButton;

public class TdkThematicDialog
extends JDialog {
    private static final String DEFAULT_THEMATIC_FUCNTION = "MIN";
    private static Logger _logger = Logger.getLogger(TdkThematicDialog.class);
    private static final int RETURNTYPE_CANCELED = 0;
    private static final int RETURNTYPE_CONFIRMED = 1;
    private static final int RETURNTYPE_APPLIED = 2;
    private int returnType_;
    private TdkThematicDialogCallback callback_;
    private JButton applyBtn_;
    private JButton cancelBtn_;
    private JButton okBtn_;
    private Dimension classDms_;
    private Dimension classificationDms_;
    private Dimension lateralBtnDms_;
    private Dimension styleDms_;
    private JButton applyColorBtn_;
    private JButton generateBtn_;
    private JButton mixColorBtn_;
    private JButton rowInsertAfterBtn_;
    private JButton rowDeleteBtn_;
    private JComboBox attributeCmb_;
    private JComboBox partitionCmb_;
    private JComboBox schemeCmb_;
    private JComboBox tableCmb_;
    private JLabel sliceLbl_;
    private JLabel tableLbl_;
    private JLabel attributeLbl_;
    private JLabel schemeLbl_;
    private JSpinner sliceSpn_;
    private Map<String, Map<String, TeAttributeDataType>> tableAttributeMap_;
    private TdkThemeGID gid_;
    private TdkStyleButton basicOneSbt_;
    private TdkStyleButton basicTwoSbt_;
    private TdkStyleButton optionalOneSbt_;
    private TdkStyleButton optionalTwoSbt_;
    private TdkThematicTable classTbl_;
    private Dimension bottonDms_;
    private Dimension bodyDms_;
    private Frame _owner;
    protected Object _lastGeneratedAttribute;

    public TdkThematicDialog(Frame frame, TdkThematicDialogCallback tdkThematicDialogCallback, TdkThemeGID tdkThemeGID) {
        super(frame);
        this._owner = frame;
        this.returnType_ = 0;
        if (tdkThematicDialogCallback == null) {
            System.out.println("callBack == null || config == null");
            return;
        }
        this.callback_ = tdkThematicDialogCallback;
        this.gid_ = tdkThemeGID;
        this.initComponents();
        this.createListeners();
    }

    private void createListeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (windowEvent.getSource() instanceof JDialog) {
                    TdkThematicDialog.this.closeDialog(0);
                }
            }
        });
        this.createBodyListeners();
        this.createBottomListeners();
    }

    protected void createBottomListeners() {
        this.okBtn_.addActionListener(new DefaultButtonListener(1));
        this.cancelBtn_.addActionListener(new DefaultButtonListener(0));
        this.applyBtn_.addActionListener(new DefaultButtonListener(2));
    }

    @Override
    protected void dialogInit() {
        super.dialogInit();
        JLayeredPane jLayeredPane = this.getLayeredPane();
        jLayeredPane.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "close-it");
        jLayeredPane.getActionMap().put("close-it", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() instanceof JLayeredPane) {
                    TdkThematicDialog.this.closeDialog(0);
                }
            }
        });
    }

    private void closeDialog(int n) {
        this.returnType_ = n;
        if (this.callback_ != null) {
            switch (this.returnType_) {
                case 2: {
                    _logger.debug((Object)"action performed: apply button");
                    this.callback_.fireApplied(this);
                    return;
                }
                case 0: {
                    _logger.debug((Object)"action performed: cancel button");
                    this.callback_.fireCanceled(this);
                    break;
                }
                case 1: {
                    this.callback_.fireConfirmed(this);
                    _logger.debug((Object)"action performed: ok button");
                }
            }
        }
        this.setVisible(false);
    }

    public void centerDialog() {
        Dimension dimension = this.getToolkit().getScreenSize();
        this.setLocation(dimension.width / 2 - this.getWidth() / 2, dimension.height / 2 - this.getHeight() / 2);
    }

    protected void configContentPane() {
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(this.createBodyPanel());
        this.getContentPane().add(this.createBottomPanel());
    }

    protected JPanel createBottomPanel() {
        this.okBtn_ = new JButton(TdkComponentsI18n.getString("DLG_BTN_OK"));
        this.okBtn_.setMnemonic(TdkComponentsI18n.getString("DLG_BTN_OK_MNEMONIC").charAt(0));
        this.okBtn_.setEnabled(false);
        this.cancelBtn_ = new JButton(TdkComponentsI18n.getString("DLG_BTN_CANCEL"));
        this.cancelBtn_.setMnemonic(TdkComponentsI18n.getString("DLG_BTN_CANCEL_MNEMONIC").charAt(0));
        this.applyBtn_ = new JButton(TdkComponentsI18n.getString("DLG_BTN_APPLY"));
        this.applyBtn_.setMnemonic(TdkComponentsI18n.getString("DLG_BTN_APPLY_MNEMONIC").charAt(0));
        this.applyBtn_.setEnabled(false);
        int n = Math.max(Math.max(this.cancelBtn_.getPreferredSize().height, this.okBtn_.getPreferredSize().height), this.applyBtn_.getPreferredSize().height);
        int n2 = Math.max(Math.max(this.cancelBtn_.getPreferredSize().width, this.okBtn_.getPreferredSize().width), this.applyBtn_.getPreferredSize().width);
        this.okBtn_.setPreferredSize(new Dimension(n2, n));
        this.cancelBtn_.setPreferredSize(new Dimension(n2, n));
        this.applyBtn_.setPreferredSize(new Dimension(n2, n));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        jPanel.setPreferredSize(this.bottonDms_);
        jPanel.setMaximumSize(this.bottonDms_);
        jPanel.setMinimumSize(this.bottonDms_);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 4, 1, 100.0, 100.0, 14, 2, new Insets(8, 0, 0, 0), 0, 0);
        jPanel.add((Component)new JSeparator(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(8, 3, 8, 3);
        jPanel.add((Component)this.okBtn_, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this.cancelBtn_, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(8, 3, 8, 8);
        jPanel.add((Component)this.applyBtn_, gridBagConstraints);
        return jPanel;
    }

    private void initComponents() {
        this.setTitle(TdkComponentsI18n.getString("DLG_THEMATIC_TITTLE"));
        this.setDefaultCloseOperation(2);
        this.configDimensionDialog();
        this.configDimensionPanel();
        this.centerDialog();
        this.configContentPane();
        this.configDefaultButton();
        this.configRequestFocus();
        _logger.debug((Object)"components initialized");
    }

    protected void configDefaultButton() {
        this.getRootPane().setDefaultButton(this.okBtn_);
    }

    protected void configDimensionDialog() {
        this.setResizable(false);
        this.setSize(680, 502);
        this.setModal(true);
    }

    protected void configDimensionPanel() {
        this.bodyDms_ = new Dimension(750, 420);
        this.bottonDms_ = new Dimension(750, 50);
        this.classDms_ = new Dimension(75, 60);
        this.classificationDms_ = new Dimension(85, 60);
        this.lateralBtnDms_ = new Dimension(85, 24);
        this.styleDms_ = new Dimension(85, 60);
    }

    protected JPanel createBodyPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new EmptyBorder(5, 8, 0, 8));
        jPanel.setPreferredSize(this.bodyDms_);
        jPanel.setMaximumSize(this.bodyDms_);
        jPanel.setMinimumSize(this.bodyDms_);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 25.0, 100.0, 15, 1, new Insets(0, 0, 0, 0), 0, 0);
        jPanel.add((Component)this.createClassificationPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)this.createClassPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 25.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)this.createStylePanel(), gridBagConstraints);
        return jPanel;
    }

    protected static ImageIcon createImageIcon(String string) {
        URL uRL = TdkThematicDialog.class.getClass().getResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        return null;
    }

    private JPanel createClassificationPanel() {
        this.partitionCmb_ = new JComboBox();
        this.partitionCmb_.setRenderer(new TdkItemComboBoxRenderer());
        this.partitionCmb_.setToolTipText(TdkComponentsI18n.getString("PNL_THEMATIC_PARTITION_TOOLTIP_TEXT"));
        JLabel jLabel = new JLabel(TdkComponentsI18n.getString("PNL_THEMATIC_PARTITION_LABEL"));
        jLabel.setDisplayedMnemonic(TdkComponentsI18n.getString("PNL_THEMATIC_PARTITION_MNEUMONIC").charAt(0));
        jLabel.setLabelFor(this.partitionCmb_);
        this.sliceSpn_ = new JSpinner(new SpinnerNumberModel(0, 0, 64, 1));
        this.sliceSpn_.setToolTipText(TdkComponentsI18n.getString("PNL_THEMATIC_SLICE_TOOLTIP_TEXT"));
        this.sliceSpn_.setPreferredSize(new Dimension((int)this.sliceSpn_.getPreferredSize().getWidth(), (int)this.partitionCmb_.getPreferredSize().getHeight()));
        this.sliceSpn_.setEnabled(false);
        this.sliceLbl_ = new JLabel(TdkComponentsI18n.getString("PNL_THEMATIC_SLICE_LABEL"));
        this.sliceLbl_.setDisplayedMnemonic(TdkComponentsI18n.getString("PNL_THEMATIC_SLICE_MNEMONIC").charAt(0));
        this.sliceLbl_.setLabelFor(this.sliceSpn_);
        this.sliceLbl_.setEnabled(false);
        this.tableCmb_ = new JComboBox();
        this.tableCmb_.setToolTipText(TdkComponentsI18n.getString("PNL_THEMATIC_ATTRIBUTE_TABLE_TOOLTIP_TEXT"));
        this.tableCmb_.setEnabled(false);
        this.tableLbl_ = new JLabel(TdkComponentsI18n.getString("PNL_THEMATIC_ATTRIBUTE_TABLE_LABEL"));
        this.tableLbl_.setDisplayedMnemonic(TdkComponentsI18n.getString("PNL_THEMATIC_ATTRIBUTE_TABLE_MNEMONIC").charAt(0));
        this.tableLbl_.setLabelFor(this.tableCmb_);
        this.tableLbl_.setEnabled(false);
        this.attributeCmb_ = new JComboBox();
        this.attributeCmb_.setToolTipText(TdkComponentsI18n.getString("PNL_THEMATIC_ATTRIBUTE_FIELD_TOOLTIP_TEXT"));
        this.attributeCmb_.setEnabled(false);
        this.attributeLbl_ = new JLabel(TdkComponentsI18n.getString("PNL_THEMATIC_ATTRIBUTE_FIELD_LABEL"));
        this.attributeLbl_.setDisplayedMnemonic(TdkComponentsI18n.getString("PNL_THEMATIC_ATTRIBUTE_FIELD_MNEMONIC").charAt(0));
        this.attributeLbl_.setLabelFor(this.attributeCmb_);
        this.attributeLbl_.setEnabled(false);
        this.generateBtn_ = new JButton(TdkComponentsI18n.getString("PNL_THEMATIC_GENERATE_TEXT"), TdkThematicDialog.createImageIcon("/org/tecgraf/jvipe/components/icons/fastForward.gif"));
        this.generateBtn_.setHorizontalTextPosition(10);
        this.generateBtn_.setMnemonic(TdkComponentsI18n.getString("PNL_THEMATIC_GENERATE_MNEMONIC").charAt(0));
        this.generateBtn_.setToolTipText(TdkComponentsI18n.getString("PNL_THEMATIC_GENERATE_TOOTIP_TEXT"));
        this.generateBtn_.setPreferredSize(this.lateralBtnDms_);
        this.generateBtn_.setEnabled(false);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(TdkComponentsI18n.getString("PNL_THEMATIC_CLASSIFICATION_TEXT")));
        jPanel.setPreferredSize(this.classificationDms_);
        jPanel.setMaximumSize(this.classificationDms_);
        jPanel.setMinimumSize(this.classificationDms_);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 100.0, 100.0, 18, 2, new Insets(0, 3, 3, 3), 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.sliceLbl_, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.partitionCmb_, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.sliceSpn_, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)this.tableLbl_, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)this.tableCmb_, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        jPanel.add((Component)this.attributeLbl_, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        jPanel.add((Component)this.attributeCmb_, gridBagConstraints);
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(10, 3, 3, 3);
        jPanel.add((Component)this.generateBtn_, gridBagConstraints);
        _logger.debug((Object)"classification panel created");
        return jPanel;
    }

    private JPanel createStylePanel() {
        this.schemeCmb_ = new JComboBox();
        this.schemeCmb_.setToolTipText(TdkComponentsI18n.getString("PNL_THEMATIC_COLOR_SCHEME_TOOLTIP_TEXT"));
        this.schemeCmb_.setEnabled(false);
        this.schemeLbl_ = new JLabel(TdkComponentsI18n.getString("PNL_THEMATIC_COLOR_SCHEME_LABEL"));
        this.schemeLbl_.setDisplayedMnemonic(TdkComponentsI18n.getString("PNL_THEMATIC_COLOR_SCHEME_MNEUMONIC").charAt(0));
        this.schemeLbl_.setLabelFor(this.schemeCmb_);
        this.schemeLbl_.setEnabled(false);
        this.basicOneSbt_ = new TdkStyleButton();
        this.basicOneSbt_.setToolTipText(TdkComponentsI18n.getString("PNL_THEMATIC_COLOR_SCHEME_BUTTON_TOOLTIP_TEXT"));
        this.basicOneSbt_.setPreferredSize(new Dimension((int)this.styleDms_.getWidth() / 2, this.basicOneSbt_.getPreferredSize().height));
        this.basicOneSbt_.setEnabled(false);
        this.basicTwoSbt_ = new TdkStyleButton();
        this.basicTwoSbt_.setToolTipText(TdkComponentsI18n.getString("PNL_THEMATIC_COLOR_SCHEME_BUTTON_TOOLTIP_TEXT"));
        this.basicTwoSbt_.setPreferredSize(new Dimension((int)this.styleDms_.getWidth() / 2, this.basicTwoSbt_.getPreferredSize().height));
        this.basicTwoSbt_.setEnabled(false);
        this.optionalOneSbt_ = new TdkStyleButton(true);
        this.optionalOneSbt_.setToolTipText(TdkComponentsI18n.getString("PNL_THEMATIC_COLOR_SCHEME_BUTTON_TOOLTIP_TEXT"));
        this.optionalOneSbt_.setPreferredSize(new Dimension((int)this.styleDms_.getWidth() / 2, this.optionalOneSbt_.getPreferredSize().height));
        this.optionalOneSbt_.setEnabled(false);
        this.optionalTwoSbt_ = new TdkStyleButton(true);
        this.optionalTwoSbt_.setToolTipText(TdkComponentsI18n.getString("PNL_THEMATIC_COLOR_SCHEME_BUTTON_TOOLTIP_TEXT"));
        this.optionalTwoSbt_.setPreferredSize(new Dimension((int)this.styleDms_.getWidth() / 2, this.optionalTwoSbt_.getPreferredSize().height));
        this.optionalTwoSbt_.setEnabled(false);
        this.applyColorBtn_ = new JButton(TdkComponentsI18n.getString("DLG_BTN_APPLY"), TdkThematicDialog.createImageIcon("img/fastForward.gif"));
        this.applyColorBtn_.setHorizontalTextPosition(10);
        this.applyColorBtn_.setMnemonic(TdkComponentsI18n.getString("DLG_BTN_APPLY_MNEMONIC").charAt(0));
        this.applyColorBtn_.setToolTipText(TdkComponentsI18n.getString("DLG_BTN_APPLY"));
        this.applyColorBtn_.setPreferredSize(this.lateralBtnDms_);
        this.applyColorBtn_.setEnabled(false);
        this.mixColorBtn_ = new JButton(TdkComponentsI18n.getString("PNL_THEMATIC_COLOR_MIXTURE_TEXT"), TdkThematicDialog.createImageIcon("img/fastForward.gif"));
        this.mixColorBtn_.setHorizontalTextPosition(10);
        this.mixColorBtn_.setMnemonic(TdkComponentsI18n.getString("PNL_THEMATIC_COLOR_MIXTURE_MNEMONIC").charAt(0));
        this.mixColorBtn_.setToolTipText(TdkComponentsI18n.getString("PNL_THEMATIC_COLOR_MIXTURE_TOOLTIP_TEXT"));
        this.mixColorBtn_.setPreferredSize(this.lateralBtnDms_);
        this.mixColorBtn_.setEnabled(false);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(TdkComponentsI18n.getString("PNL_THEMATIC_COLOR_PANEL_TITLE")));
        jPanel.setPreferredSize(this.styleDms_);
        jPanel.setMaximumSize(this.styleDms_);
        jPanel.setMinimumSize(this.styleDms_);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 2, 1, 100.0, 100.0, 18, 2, new Insets(0, 3, 3, 3), 0, 0);
        jPanel.add((Component)this.schemeLbl_, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.schemeCmb_, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel.add((Component)this.basicOneSbt_, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.optionalOneSbt_, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        jPanel.add((Component)this.basicTwoSbt_, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.optionalTwoSbt_, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(10, 3, 3, 3);
        jPanel.add((Component)this.applyColorBtn_, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        jPanel.add((Component)this.mixColorBtn_, gridBagConstraints);
        _logger.debug((Object)"style panel created");
        return jPanel;
    }

    private JPanel createClassPanel() {
        int n = 7;
        TdkTheme tdkTheme = TdkSetup.getPersistenceService().getTheme(this.gid_);
        if (tdkTheme != null) {
            n = tdkTheme.getVisibleRepresentation();
        }
        this.classTbl_ = new TdkThematicTable(this._owner, new TdkThematicTableModel(null, TeGroupingMode.TeNoGrouping), n);
        this.classTbl_.setPreferredScrollableViewportSize(this.classTbl_.getPreferredSize());
        this.classTbl_.setEnabled(false);
        JScrollPane jScrollPane = new JScrollPane(this.classTbl_);
        jScrollPane.getViewport().setBackground(this.classTbl_.getBackground());
        jScrollPane.getViewport().setPreferredSize(this.classTbl_.getPreferredSize());
        this.rowInsertAfterBtn_ = new JButton(TdkComponentsI18n.getString("PNL_THEMATIC_TABLE_ROW_INSERT_AFTER_TEXT"), TdkThematicDialog.createImageIcon("/org/tecgraf/jvipe/components/icons/rowInsertAfter.gif"));
        this.rowInsertAfterBtn_.setMnemonic(TdkComponentsI18n.getString("PNL_THEMATIC_TABLE_ROW_INSERT_AFTER_MNEMONIC").charAt(0));
        this.rowInsertAfterBtn_.setToolTipText(TdkComponentsI18n.getString("PNL_THEMATIC_TABLE_ROW_INSERT_AFTER_TOOLTIP_TEXT"));
        this.rowInsertAfterBtn_.setEnabled(false);
        this.rowDeleteBtn_ = new JButton(TdkComponentsI18n.getString("PNL_THEMATIC_TABLE_ROW_DELETE_TEXT"), TdkThematicDialog.createImageIcon("img/rowDelete.gif"));
        this.rowDeleteBtn_.setMnemonic(TdkComponentsI18n.getString("PNL_THEMATIC_TABLE_ROW_DELETE_MNEMONIC").charAt(0));
        this.rowDeleteBtn_.setToolTipText(TdkComponentsI18n.getString("PNL_THEMATIC_TABLE_ROW_DELETE_TOOLTIP_TEXT"));
        this.rowDeleteBtn_.setEnabled(false);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(TdkComponentsI18n.getString("PNL_THEMATIC_CLASS_PANEL_TITLE")));
        jPanel.setPreferredSize(this.classDms_);
        jPanel.setMaximumSize(this.classDms_);
        jPanel.setMinimumSize(this.classDms_);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 2, 1, 100.0, 100.0, 18, 1, new Insets(3, 3, 3, 3), 0, 0);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(10, 3, 3, 3);
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.rowInsertAfterBtn_, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.rowDeleteBtn_, gridBagConstraints);
        _logger.debug((Object)"class panel created");
        return jPanel;
    }

    protected void configRequestFocus() {
        this.partitionCmb_.requestFocus();
    }

    protected void configEnableControl() {
        TdkThematicDialogState tdkThematicDialogState = this.getValue();
        this.configEnabledBodyControl(tdkThematicDialogState);
        this.configEnabledBottonControl(tdkThematicDialogState);
    }

    protected void createBodyListeners() {
        this.partitionCmb_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() instanceof JComboBox) {
                    TdkThematicDialog.this.setCursor(new Cursor(3));
                    TdkThematicDialog.this.emptyClassTbl();
                    TdkThematicDialog.this.inputAttribute();
                    TdkThematicDialog.this.configEnableControl();
                    _logger.debug((Object)"action performed: partition function combo");
                    TdkThematicDialog.this.setCursor(new Cursor(0));
                }
            }
        });
        this.sliceSpn_.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (changeEvent.getSource() instanceof JSpinner) {
                    TdkThematicDialog.this.setCursor(new Cursor(3));
                    TdkThematicDialog.this.configEnableControl();
                    _logger.debug((Object)"action performed: slice number spiner");
                    TdkThematicDialog.this.setCursor(new Cursor(0));
                }
            }
        });
        this.tableCmb_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() instanceof JComboBox) {
                    TdkThematicDialog.this.setCursor(new Cursor(3));
                    TdkThematicDialog.this.inputAttribute();
                    TdkThematicDialog.this.configEnableControl();
                    _logger.debug((Object)"action performed: attribute table combo");
                    TdkThematicDialog.this.setCursor(new Cursor(0));
                }
            }
        });
        this.attributeCmb_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() instanceof JComboBox) {
                    TdkThematicDialog.this.setCursor(new Cursor(3));
                    TdkThematicDialog.this.configEnableControl();
                    _logger.debug((Object)"action performed: attribute combo");
                    TdkThematicDialog.this.setCursor(new Cursor(0));
                }
            }
        });
        this.generateBtn_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() instanceof JButton) {
                    TdkThematicDialog.this._lastGeneratedAttribute = TdkThematicDialog.this.attributeCmb_.getSelectedItem();
                    TdkThematicDialog.this.callback_.fireGenerateThematic(TdkThematicDialog.this);
                    TdkThematicDialog.this.configEnableControl();
                    _logger.debug((Object)"action performed: thematic classes generation button");
                }
            }
        });
        this.schemeCmb_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() instanceof JComboBox) {
                    TdkThematicDialog.this.callback_.fireSchemeChange(TdkThematicDialog.this);
                    _logger.debug((Object)"action performed: color scheme combo");
                }
            }
        });
        this.applyColorBtn_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() instanceof JButton) {
                    TdkThematicDialog.this.callback_.fireGenerateColorScheme(TdkThematicDialog.this);
                    _logger.debug((Object)"action performed: apply color scheme button");
                }
            }
        });
        this.mixColorBtn_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() instanceof JButton) {
                    TdkThematicDialog.this.setCursor(new Cursor(3));
                    TdkThematicDialog.this.classTbl_.mixColor();
                    _logger.debug((Object)"action performed: mix colors button");
                    TdkThematicDialog.this.setCursor(new Cursor(0));
                }
            }
        });
        this.rowInsertAfterBtn_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() instanceof JButton) {
                    TdkThematicDialog.this.setCursor(new Cursor(3));
                    TdkThematicDialog.this.classTbl_.insertRow();
                    TdkThematicDialog.this.sliceSpn_.setValue(TdkThematicDialog.this.sliceSpn_.getModel().getNextValue() == null ? Integer.valueOf(0) : TdkThematicDialog.this.sliceSpn_.getModel().getNextValue());
                    _logger.debug((Object)"action performed: class insert button");
                    TdkThematicDialog.this.setCursor(new Cursor(0));
                }
            }
        });
        this.rowDeleteBtn_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() instanceof JButton) {
                    TdkThematicDialog.this.setCursor(new Cursor(3));
                    TdkThematicDialog.this.classTbl_.deleteRow();
                    TdkThematicDialog.this.sliceSpn_.setValue(new Integer(TdkThematicDialog.this.classTbl_.getRowCount()));
                    _logger.debug((Object)"action performed: delete class button");
                    TdkThematicDialog.this.setCursor(new Cursor(0));
                }
            }
        });
    }

    private void inputAttribute() {
        String string;
        this.attributeCmb_.removeAllItems();
        if (this.tableCmb_.getSelectedIndex() != -1 && (string = (String)this.tableCmb_.getSelectedItem()) != null) {
            Map<String, TeAttributeDataType> map = this.tableAttributeMap_.get(string);
            for (String string2 : map.keySet()) {
                TeAttributeDataType teAttributeDataType = map.get(string2);
                TeGroupingMode teGroupingMode = (TeGroupingMode)((TdkItemComboBox)this.partitionCmb_.getSelectedItem()).getId();
                if (teGroupingMode == TeGroupingMode.TeUniqueValue) {
                    this.attributeCmb_.addItem(string2);
                    continue;
                }
                if (teGroupingMode != TeGroupingMode.TeEqualSteps && teGroupingMode != TeGroupingMode.TeQuantil || teAttributeDataType != TeAttributeDataType.TeREAL && teAttributeDataType != TeAttributeDataType.TeINT) continue;
                this.attributeCmb_.addItem(string2);
            }
            if (this.attributeCmb_.getItemCount() > 0) {
                this.attributeCmb_.setSelectedIndex(0);
            }
        }
        if (this.isVisible()) {
            this.attributeCmb_.updateUI();
        }
    }

    public void configEnabledBodyControl(TdkThematicDialogState tdkThematicDialogState) {
        this.configEnabledClassificationControl(tdkThematicDialogState);
        this.configEnabledClassControl(tdkThematicDialogState);
        this.configEnabledStyleControl(tdkThematicDialogState);
    }

    public void configEnabledClassificationControl(TdkThematicDialogState tdkThematicDialogState) {
        TeGroupingMode teGroupingMode = tdkThematicDialogState.getGroupingMode();
        boolean bl = teGroupingMode == TeGroupingMode.TeNoGrouping;
        boolean bl2 = teGroupingMode == TeGroupingMode.TeUniqueValue;
        String string = tdkThematicDialogState.getAttributeName();
        boolean bl3 = string != null && !string.equals("");
        boolean bl4 = tdkThematicDialogState.getNumSlices() > 0;
        this.sliceSpn_.setEnabled(!bl && !bl2);
        this.sliceLbl_.setEnabled(!bl && !bl2);
        this.tableCmb_.setEnabled(!bl);
        this.tableLbl_.setEnabled(!bl);
        this.attributeCmb_.setEnabled(!bl);
        this.attributeLbl_.setEnabled(!bl);
        this.generateBtn_.setEnabled(!bl && bl3 && (bl2 || !bl2 && bl4));
    }

    public void configEnabledClassControl(TdkThematicDialogState tdkThematicDialogState) {
        TeGroupingMode teGroupingMode = tdkThematicDialogState.getGroupingMode();
        boolean bl = teGroupingMode == TeGroupingMode.TeNoGrouping;
        String string = tdkThematicDialogState.getAttributeTableName();
        String string2 = tdkThematicDialogState.getAttributeName();
        boolean bl2 = string != null && !string.equalsIgnoreCase("") && string2 != null && !string2.equalsIgnoreCase("");
        this.classTbl_.setEnabled(!bl);
        this.rowInsertAfterBtn_.setEnabled(!bl && bl2);
        this.rowDeleteBtn_.setEnabled(!bl && bl2);
    }

    public void configEnabledStyleControl(TdkThematicDialogState tdkThematicDialogState) {
        TeGroupingMode teGroupingMode = tdkThematicDialogState.getGroupingMode();
        boolean bl = teGroupingMode == TeGroupingMode.TeNoGrouping;
        this.schemeCmb_.setEnabled(!bl);
        this.schemeLbl_.setEnabled(!bl);
        this.basicOneSbt_.setEnabled(!bl);
        this.basicTwoSbt_.setEnabled(!bl);
        this.optionalOneSbt_.setEnabled(!bl);
        this.optionalTwoSbt_.setEnabled(!bl);
        this.applyColorBtn_.setEnabled(!bl);
        this.mixColorBtn_.setEnabled(!bl);
    }

    protected void configEnabledBottonControl(TdkThematicDialogState tdkThematicDialogState) {
        TeGroupingMode teGroupingMode = tdkThematicDialogState.getGroupingMode();
        boolean bl = teGroupingMode == TeGroupingMode.TeNoGrouping;
        TeLegendEntryVector teLegendEntryVector = tdkThematicDialogState.getLegendEntryVector();
        boolean bl2 = !bl && teLegendEntryVector != null && teLegendEntryVector.size() > 0L;
        this.okBtn_.setEnabled(bl || bl2);
        this.applyBtn_.setEnabled(bl || bl2);
    }

    public void emptyClassTbl() {
        TdkThematicDialogState tdkThematicDialogState = this.getValue();
        TeLegendEntryVector teLegendEntryVector = tdkThematicDialogState.getLegendEntryVector();
        if (teLegendEntryVector != null) {
            teLegendEntryVector.clear();
        }
        this.setClassTbl(teLegendEntryVector, tdkThematicDialogState.getGroupingMode());
    }

    public void setClassTbl(TeLegendEntryVector teLegendEntryVector, TeGroupingMode teGroupingMode) {
        if (teLegendEntryVector != null) {
            this.classTbl_.setCells(teLegendEntryVector, teGroupingMode);
            this.sliceSpn_.setValue((int)teLegendEntryVector.size());
        }
    }

    public void setDegradeInClassTbl(Color[] colorArray) {
        if (colorArray != null && colorArray.length > 0) {
            this.classTbl_.setDegradeColor(colorArray);
        }
    }

    public void setStyleBtn(Color color, Color color2, boolean bl, Color color3, boolean bl2, Color color4) {
        this.basicOneSbt_.setColor(color);
        this.basicTwoSbt_.setColor(color2);
        this.optionalOneSbt_.setColor(color3);
        this.optionalOneSbt_.setSelected(bl);
        this.optionalTwoSbt_.setColor(color4);
        this.optionalTwoSbt_.setSelected(bl2);
    }

    public void setInput(TdkThematicDialogInput tdkThematicDialogInput) {
        this.setCursor(new Cursor(3));
        if (tdkThematicDialogInput != null) {
            Object object;
            Iterator<String> iterator;
            List<TdkGroupingModeDesc> list = tdkThematicDialogInput.getPartition();
            if (list != null) {
                this.partitionCmb_.removeAllItems();
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    TdkItemComboBox tdkItemComboBox = new TdkItemComboBox(((TdkGroupingModeDesc)object)._grounpingMode, ((TdkGroupingModeDesc)object)._name);
                    this.partitionCmb_.addItem(tdkItemComboBox);
                }
            }
            this.tableAttributeMap_ = tdkThematicDialogInput.getTableAttribute();
            if (this.tableAttributeMap_ != null) {
                iterator = this.tableAttributeMap_.keySet().iterator();
                while (iterator.hasNext()) {
                    this.tableCmb_.addItem(iterator.next());
                }
                if (this.tableCmb_.getItemCount() > 0) {
                    this.tableCmb_.setSelectedIndex(0);
                    this.inputAttribute();
                }
            }
            if ((iterator = tdkThematicDialogInput.getScheme()) != null) {
                this.schemeCmb_.removeAllItems();
                object = iterator.iterator();
                while (object.hasNext()) {
                    this.schemeCmb_.addItem(object.next());
                }
            }
        } else {
            this.setValue(null);
        }
        if (this.isVisible()) {
            this.partitionCmb_.updateUI();
            this.tableCmb_.updateUI();
            this.schemeCmb_.updateUI();
        }
        this.setCursor(new Cursor(0));
    }

    public void setValue(TdkThematicDialogState tdkThematicDialogState) {
        this.setCursor(new Cursor(3));
        if (tdkThematicDialogState != null) {
            this.gid_ = tdkThematicDialogState.getGID();
            if (tdkThematicDialogState.getAttributeName() != null && !tdkThematicDialogState.getAttributeName().trim().equals("")) {
                this._lastGeneratedAttribute = tdkThematicDialogState.getAttributeName();
            }
            this.partitionCmb_.setSelectedIndex(this.toIndex(tdkThematicDialogState.getGroupingMode()));
            this.sliceSpn_.setValue(new Integer(tdkThematicDialogState.getNumSlices()));
            this.tableCmb_.setSelectedItem(tdkThematicDialogState.getAttributeTableName());
            this.attributeCmb_.setSelectedItem(tdkThematicDialogState.getAttributeName());
            this.schemeCmb_.setSelectedIndex(tdkThematicDialogState.getColorSchemeDefaultPallete().ordinal());
            this.basicOneSbt_.setColor(tdkThematicDialogState.getBasicColorOne());
            this.basicTwoSbt_.setColor(tdkThematicDialogState.getBasicColorTwo());
            this.optionalOneSbt_.setColor(tdkThematicDialogState.getOptionalOne());
            this.optionalOneSbt_.setSelected(tdkThematicDialogState.isColorOneSelected());
            this.optionalTwoSbt_.setColor(tdkThematicDialogState.getOptionalTwo());
            this.optionalTwoSbt_.setSelected(tdkThematicDialogState.isColorTwoSelected());
            this.setClassTbl(tdkThematicDialogState.getLegendEntryVector(), tdkThematicDialogState.getGroupingMode());
        } else {
            this.gid_ = null;
            this.partitionCmb_.setSelectedIndex(-1);
            this.sliceSpn_.setValue(null);
            this.tableCmb_.setSelectedItem(null);
            this.attributeCmb_.setSelectedItem(null);
            this.schemeCmb_.setSelectedIndex(-1);
            this.basicOneSbt_.setColor(Color.white);
            this.basicTwoSbt_.setColor(Color.white);
            this.optionalOneSbt_.setColor(Color.white);
            this.optionalOneSbt_.setSelected(true);
            this.optionalTwoSbt_.setColor(Color.white);
            this.optionalTwoSbt_.setSelected(true);
            this.setClassTbl(null, TeGroupingMode.TeNoGrouping);
        }
        this.configEnableControl();
        this.setCursor(new Cursor(0));
    }

    public TdkThematicDialogState getValue() {
        TdkThematicTableModel tdkThematicTableModel = (TdkThematicTableModel)this.classTbl_.getModel();
        String string = (String)this.tableCmb_.getSelectedItem();
        string = string == null ? "" : string;
        String string2 = this._lastGeneratedAttribute != null ? this._lastGeneratedAttribute.toString() : (String)this.attributeCmb_.getSelectedItem();
        string2 = string2 == null ? "" : string2;
        TeAttributeDataType teAttributeDataType = this.getTypeAttribute(string, string2);
        int n = this.schemeCmb_.getSelectedIndex();
        n = Math.min(Math.max(0, n), TdkColorDefaultPallete.values().length);
        _logger.debug((Object)("Current attribute field name: " + string2));
        return new TdkThematicDialogState(this.gid_, (TeGroupingMode)((TdkItemComboBox)this.partitionCmb_.getSelectedItem()).getId(), DEFAULT_THEMATIC_FUCNTION, (Integer)this.sliceSpn_.getValue(), string, string2, teAttributeDataType, TdkColorDefaultPallete.values()[n], this.basicOneSbt_.getColor(), this.basicTwoSbt_.getColor(), this.optionalOneSbt_.getSelected(), this.optionalOneSbt_.getColor(), this.optionalTwoSbt_.getSelected(), this.optionalTwoSbt_.getColor(), tdkThematicTableModel.getLegendEntryVector());
    }

    private int toIndex(TeGroupingMode teGroupingMode) {
        for (int i = 0; i < this.partitionCmb_.getItemCount(); ++i) {
            if (((TdkItemComboBox)this.partitionCmb_.getItemAt(i)).getId() != teGroupingMode) continue;
            return i;
        }
        return 0;
    }

    private TeAttributeDataType getTypeAttribute(String string, String string2) {
        if (this.tableAttributeMap_ != null && string != null && !string.equals("") && string2 != null && !string2.equals("")) {
            Map<String, TeAttributeDataType> map = this.tableAttributeMap_.get(string);
            return map.get(string2);
        }
        return TeAttributeDataType.TeUNKNOWN;
    }

    class DefaultButtonListener
    implements ActionListener {
        private int _returnType;

        public DefaultButtonListener(int n) {
            this._returnType = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() instanceof JButton) {
                TdkThematicDialog.this.closeDialog(this._returnType);
            }
        }
    }
}

