/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.dialogs.thematic;

import java.awt.Color;
import java.awt.Cursor;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.core.swig.TdkSetup;
import org.tecgraf.jtdk.desktop.components.TdkComponentsI18n;
import org.tecgraf.jtdk.desktop.components.dialogs.TdkProgressBarDialog;
import org.tecgraf.jtdk.desktop.components.dialogs.thematic.TdkThematicDialog;
import org.tecgraf.jtdk.desktop.components.dialogs.thematic.TdkThematicDialogState;
import org.tecgraf.jtdk.desktop.components.treeview.TdkUpdateThemeEvent;
import org.tecgraf.jtdk.desktop.components.util.TdkColorScheme;
import org.tecgraf.jtdk.desktop.components.util.TdkDialogUtil;

public class TdkThematicDialogCallback {
    private static Logger _logger = Logger.getLogger(TdkThematicDialogCallback.class);
    private TdkUpdateThemeEvent _updateThemeEvent = new TdkUpdateThemeEvent();

    public void fireGenerateThematic(TdkThematicDialog tdkThematicDialog) {
        tdkThematicDialog.setCursor(new Cursor(3));
        final TdkThematicDialogState tdkThematicDialogState = tdkThematicDialog.getValue();
        TdkProgressBarDialog tdkProgressBarDialog = new TdkProgressBarDialog(TdkDialogUtil.getFrameParent(tdkThematicDialog), TdkComponentsI18n.getString("PNL_THEMATIC_PROGRESS_GENERATE_THEMATIC"), false, false, false);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TdkSetup.getPersistenceService().generateThematicLegend(tdkThematicDialogState.getGID(), tdkThematicDialogState.getAttributeTableName(), tdkThematicDialogState.getAttributeName(), tdkThematicDialogState.getGroupingMode(), tdkThematicDialogState.getNumSlices(), tdkThematicDialogState.getFunction(), tdkThematicDialogState.getLegendEntryVector());
            }
        };
        try {
            tdkProgressBarDialog.execute(runnable, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            tdkThematicDialog.setCursor(new Cursor(0));
        }
        tdkThematicDialog.setClassTbl(tdkThematicDialogState.getLegendEntryVector(), tdkThematicDialogState.getGroupingMode());
        this.fireGenerateColorScheme(tdkThematicDialog);
        tdkThematicDialog.setCursor(new Cursor(0));
    }

    public void fireGenerateColorScheme(TdkThematicDialog tdkThematicDialog) {
        tdkThematicDialog.setCursor(new Cursor(3));
        TdkThematicDialogState tdkThematicDialogState = tdkThematicDialog.getValue();
        TdkColorScheme tdkColorScheme = new TdkColorScheme(tdkThematicDialogState.getColorScheme());
        Color[] colorArray = tdkColorScheme.generateSchemeColors(tdkThematicDialogState.getNumSlices());
        tdkThematicDialog.setDegradeInClassTbl(colorArray);
        tdkThematicDialog.setCursor(new Cursor(0));
    }

    public void fireSchemeChange(TdkThematicDialog tdkThematicDialog) {
        tdkThematicDialog.setCursor(new Cursor(3));
        TdkThematicDialogState tdkThematicDialogState = tdkThematicDialog.getValue();
        TdkColorScheme tdkColorScheme = new TdkColorScheme(tdkThematicDialogState.getColorSchemeDefaultPallete());
        Color[] colorArray = tdkColorScheme.getSourceColors();
        tdkThematicDialog.setStyleBtn(colorArray[0], colorArray[1], true, colorArray[2], true, colorArray[3]);
        tdkThematicDialog.setCursor(new Cursor(0));
    }

    public void fireApplied(TdkThematicDialog tdkThematicDialog) {
        tdkThematicDialog.setCursor(new Cursor(3));
        final TdkThematicDialogState tdkThematicDialogState = tdkThematicDialog.getValue();
        TdkProgressBarDialog tdkProgressBarDialog = new TdkProgressBarDialog(TdkDialogUtil.getFrameParent(tdkThematicDialog), TdkComponentsI18n.getString("PNL_THEMATIC_PROGRESS_APPLY_THEMATIC"), false, false, false);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TdkSetup.getPersistenceService().applyThematic(tdkThematicDialogState.getGID(), tdkThematicDialogState.getAttributeTableName(), tdkThematicDialogState.getAttributeName(), tdkThematicDialogState.getGroupingMode(), tdkThematicDialogState.getFunction(), tdkThematicDialogState.getLegendEntryVector());
            }
        };
        try {
            tdkProgressBarDialog.execute(runnable, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            tdkThematicDialog.setCursor(new Cursor(0));
        }
        _logger.debug((Object)("thematic applied to theme: " + tdkThematicDialogState.getGID()));
        this._updateThemeEvent.setLegendVectorChanged(true);
        tdkThematicDialog.setCursor(new Cursor(0));
    }

    public void fireCanceled(TdkThematicDialog tdkThematicDialog) {
        tdkThematicDialog.setCursor(new Cursor(3));
        tdkThematicDialog.setCursor(new Cursor(0));
    }

    public void fireConfirmed(TdkThematicDialog tdkThematicDialog) {
        this.fireApplied(tdkThematicDialog);
    }

    public TdkUpdateThemeEvent getUpdateThemeEvent() {
        return this._updateThemeEvent;
    }
}

