/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.dialogs.thematic;

import java.awt.Color;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.core.swig.TdkSetup;
import org.tecgraf.jtdk.core.swig.TdkTheme;
import org.tecgraf.jtdk.core.swig.TdkThemeGID;
import org.tecgraf.jtdk.core.swig.TeAttrTableVector;
import org.tecgraf.jtdk.core.swig.TeAttribute;
import org.tecgraf.jtdk.core.swig.TeAttributeDataType;
import org.tecgraf.jtdk.core.swig.TeAttributeList;
import org.tecgraf.jtdk.core.swig.TeLegendEntryVector;
import org.tecgraf.jtdk.core.swig.TeTable;
import org.tecgraf.jtdk.desktop.components.dialogs.thematic.TdkThematicDialogCallback;
import org.tecgraf.jtdk.desktop.components.dialogs.thematic.TdkThematicDialogInput;
import org.tecgraf.jtdk.desktop.components.dialogs.thematic.TdkThematicDialogState;
import org.tecgraf.jtdk.desktop.components.util.TdkColorDefaultPallete;

public class TdkThematicDialogManager {
    private static Logger _logger = Logger.getLogger(TdkThematicDialogManager.class);
    private static final String DEFAULT_THEMATIC_FUNCTION = "MIN";
    private static final TdkColorDefaultPallete DEFAULT_COLOR_PALLETE = TdkColorDefaultPallete.TdkRedBlueYellowGreen;
    private TdkThemeGID _themeGID;

    public TdkThematicDialogManager(TdkThemeGID tdkThemeGID) {
        this._themeGID = tdkThemeGID;
    }

    public TdkThematicDialogCallback getCallback() {
        return new TdkThematicDialogCallback();
    }

    public TdkThematicDialogState getInitialState() {
        TdkTheme tdkTheme = TdkSetup.getPersistenceService().getTheme(this._themeGID);
        TeLegendEntryVector teLegendEntryVector = null;
        try {
            teLegendEntryVector = (TeLegendEntryVector)tdkTheme.getLegends().clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        TeAttributeDataType teAttributeDataType = this.getThematicAttributeDataType(tdkTheme);
        _logger.debug((Object)("Initial attribute field name: " + tdkTheme.getThematicAttributeFieldName()));
        return new TdkThematicDialogState(this._themeGID, tdkTheme.getGroupingMode(), DEFAULT_THEMATIC_FUNCTION, (int)teLegendEntryVector.size(), tdkTheme.getThematicAttributeTableName(), tdkTheme.getThematicAttributeFieldName(), teAttributeDataType, DEFAULT_COLOR_PALLETE, Color.red, Color.blue, true, Color.yellow, true, Color.green, teLegendEntryVector);
    }

    private TeAttributeDataType getThematicAttributeDataType(TdkTheme tdkTheme) {
        TeAttributeDataType teAttributeDataType = TeAttributeDataType.TeUNKNOWN;
        TeAttrTableVector teAttrTableVector = tdkTheme.getAttributeTableVector();
        int n = 0;
        while ((long)n < teAttrTableVector.size()) {
            TeTable teTable = teAttrTableVector.get(n);
            if (teTable.getName() == tdkTheme.getThematicAttributeTableName()) {
                TeAttributeList teAttributeList = teTable.attributeList();
                int n2 = 0;
                while ((long)n2 < teAttributeList.size()) {
                    TeAttribute teAttribute = teAttributeList.get(n2);
                    if (teAttribute.getRep_().getName_() == tdkTheme.getThematicAttributeFieldName()) {
                        teAttributeDataType = teAttribute.getRep_().getType_();
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return teAttributeDataType;
    }

    public TdkThematicDialogInput getInput() {
        return new TdkThematicDialogInput(this._themeGID);
    }
}

