/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.dialogs.thematic;

import java.awt.Color;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.core.swig.TdkLineStyle;
import org.tecgraf.jtdk.core.swig.TdkPointStyle;
import org.tecgraf.jtdk.core.swig.TdkPolygonStyle;
import org.tecgraf.jtdk.core.swig.TeGroupingMode;
import org.tecgraf.jtdk.core.swig.TeLegendEntry;
import org.tecgraf.jtdk.core.swig.TeLegendEntryVector;
import org.tecgraf.jtdk.desktop.components.dialogs.thematic.ITdkThematicDialogConstants;
import org.tecgraf.jtdk.desktop.components.dialogs.thematic.TdkTableModel;

public class TdkThematicTableModel
extends TdkTableModel {
    private static Logger _logger = Logger.getLogger(TdkThematicTableModel.class);
    public static final int DESCRIPTION_COLUMN = 0;
    public static final int STYLE_COLUMN = 1;
    public static final int VALUE_COLUMN = 2;
    public static final int LIMINF_COLUMN = 2;
    public static final int LIMSUP_COLUMN = 3;
    private TeLegendEntryVector _legendEntryVector;
    private TeGroupingMode _groupingMode;

    public TdkThematicTableModel(TeLegendEntryVector teLegendEntryVector, TeGroupingMode teGroupingMode) {
        super(TdkThematicTableModel.toCells(teLegendEntryVector, teGroupingMode), TdkThematicTableModel.toColumns(teGroupingMode));
        this._legendEntryVector = teLegendEntryVector;
        this._groupingMode = teGroupingMode;
    }

    private static Object[][] toCells(TeLegendEntryVector teLegendEntryVector, TeGroupingMode teGroupingMode) {
        if (teLegendEntryVector == null || teLegendEntryVector.size() <= 0L) {
            return new Object[0][0];
        }
        Object[][] objectArray = new Object[(int)teLegendEntryVector.size()][TdkThematicTableModel.isNumberOfColumn(teGroupingMode) ? 4 : 3];
        int n = 0;
        while ((long)n < teLegendEntryVector.size()) {
            String string;
            objectArray[n][0] = teLegendEntryVector.get((long)n).getLabel();
            objectArray[n][1] = teLegendEntryVector.get((long)n);
            if (TdkThematicTableModel.isNumberOfColumn(teGroupingMode)) {
                try {
                    string = teLegendEntryVector.get((long)n).getFrom();
                    String string2 = teLegendEntryVector.get((long)n).getTo();
                    objectArray[n][2] = new Double(string);
                    objectArray[n][3] = new Double(string2);
                }
                catch (Exception exception) {
                    objectArray[n][2] = new Double(0.0);
                    objectArray[n][3] = new Double(0.0);
                }
            } else {
                string = teLegendEntryVector.get((long)n).getFrom();
                _logger.debug((Object)("Legend Entry number " + n + " from : " + string));
                objectArray[n][2] = teLegendEntryVector.get((long)n).getFrom();
            }
            ++n;
        }
        return objectArray;
    }

    private static String[] toColumns(TeGroupingMode teGroupingMode) {
        return TdkThematicTableModel.isNumberOfColumn(teGroupingMode) ? ITdkThematicDialogConstants.TABLEHEADER_COLUMNNAMESBYNUMBER_TEXT : ITdkThematicDialogConstants.TABLEHEADER_COLUMNNAMESBYVALUE_TEXT;
    }

    public static boolean isNumberOfColumn(TeGroupingMode teGroupingMode) {
        return teGroupingMode == TeGroupingMode.TeNoGrouping || teGroupingMode == TeGroupingMode.TeEqualSteps || teGroupingMode == TeGroupingMode.TeQuantil;
    }

    public TeLegendEntryVector getLegendEntryVector() {
        if (this._legendEntryVector != null) {
            this._legendEntryVector.clear();
            Object[][] objectArray = this.getCells();
            for (int i = 0; i < objectArray.length; ++i) {
                TeLegendEntry teLegendEntry = (TeLegendEntry)objectArray[i][1];
                teLegendEntry.setLabel((String)objectArray[i][0]);
                if (TdkThematicTableModel.isNumberOfColumn(this._groupingMode)) {
                    teLegendEntry.setFrom(((Double)objectArray[i][2]).toString());
                    teLegendEntry.setTo(((Double)objectArray[i][3]).toString());
                } else {
                    teLegendEntry.setFrom((String)objectArray[i][2]);
                    teLegendEntry.setTo((String)objectArray[i][2]);
                }
                this._legendEntryVector.add(teLegendEntry);
            }
            return this._legendEntryVector;
        }
        return null;
    }

    public void setCells(TeLegendEntryVector teLegendEntryVector, TeGroupingMode teGroupingMode) {
        this._legendEntryVector = teLegendEntryVector;
        this._groupingMode = teGroupingMode;
        this.setCells(TdkThematicTableModel.toCells(teLegendEntryVector, teGroupingMode), TdkThematicTableModel.toColumns(teGroupingMode));
    }

    public TeGroupingMode getPartition() {
        return this._groupingMode;
    }

    @Override
    public Object[] getNewRow() {
        Object[] objectArray;
        TeLegendEntry teLegendEntry = new TeLegendEntry();
        if (TdkThematicTableModel.isNumberOfColumn(this._groupingMode)) {
            Object[] objectArray2 = new Object[4];
            objectArray2[0] = "0 ~ 0";
            objectArray2[1] = teLegendEntry;
            objectArray2[2] = new Double(0.0);
            objectArray = objectArray2;
            objectArray2[3] = new Double(0.0);
        } else {
            Object[] objectArray3 = new Object[3];
            objectArray3[0] = "0 ~ 0";
            objectArray3[1] = teLegendEntry;
            objectArray = objectArray3;
            objectArray3[2] = "0";
        }
        return objectArray;
    }

    public void setDegradeColor(Color[] colorArray) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            TeLegendEntry teLegendEntry = (TeLegendEntry)this.getValueAt(i, 1);
            TdkPointStyle tdkPointStyle = (TdkPointStyle)teLegendEntry.getStyle(4);
            tdkPointStyle.setColor(colorArray[i]);
            TdkLineStyle tdkLineStyle = (TdkLineStyle)teLegendEntry.getStyle(2);
            tdkLineStyle.setColor(colorArray[i]);
            TdkPolygonStyle tdkPolygonStyle = (TdkPolygonStyle)teLegendEntry.getStyle(1);
            tdkPolygonStyle.setColor(colorArray[i]);
        }
        this.fireTableDataChanged();
    }

    public void mixColor() {
        int n = this.getRowCount();
        if (n < 3) {
            return;
        }
        int n2 = 97;
        int n3 = 0;
        int n4 = n2 % n;
        for (int i = 0; i < n * 2; ++i) {
            TeLegendEntry teLegendEntry = (TeLegendEntry)this.getValueAt(n3, 1);
            this.setValueAt(this.getValueAt(n4, 1), n3, 1);
            this.setValueAt(teLegendEntry, n4, 1);
            n3 = i % n;
            n4 = (n4 + n2 * (i ^ 3)) % n;
        }
    }

    public Class getColumnClass(int n) {
        Class<Object> clazz = Object.class;
        if (TdkThematicTableModel.isNumberOfColumn(this._groupingMode)) {
            switch (n) {
                case 0: {
                    clazz = String.class;
                    break;
                }
                case 1: {
                    clazz = TeLegendEntry.class;
                    break;
                }
                case 2: {
                    clazz = Double.class;
                    break;
                }
                case 3: {
                    clazz = Double.class;
                }
            }
        } else {
            switch (n) {
                case 0: {
                    clazz = String.class;
                    break;
                }
                case 1: {
                    clazz = TeLegendEntry.class;
                    break;
                }
                case 2: {
                    clazz = String.class;
                }
            }
        }
        return clazz;
    }
}

