/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.layout;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import org.tecgraf.jtdk.core.graphics.TdkNativeCanvas;
import org.tecgraf.jtdk.core.swig.TdkButton;
import org.tecgraf.jtdk.core.swig.TdkButtonState;
import org.tecgraf.jtdk.core.swig.TdkKeyboardState;
import org.tecgraf.jtdk.core.swig.TdkLayout;
import org.tecgraf.jtdk.desktop.components.map.TdkVisualSurface;

public class TdkLayoutDisplay
extends TdkVisualSurface
implements MouseListener,
MouseMotionListener {
    protected TdkLayout _layout = null;
    private boolean _firstTime = true;

    public TdkLayoutDisplay(TdkLayout tdkLayout) {
        this._layout = tdkLayout;
        this.setBackground(Color.WHITE);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this._layout.mouseClick(mouseEvent.getX(), this.getHeight() - mouseEvent.getY(), TdkButton.btnLeft, TdkButtonState.btsPressed, TdkKeyboardState.kbsNone);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this._layout.mouseClick(mouseEvent.getX(), this.getHeight() - mouseEvent.getY(), TdkButton.btnLeft, TdkButtonState.btsUnpressed, TdkKeyboardState.kbsNone);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    protected void draw(Graphics2D graphics2D) {
        if (this._firstTime) {
            if (!this.bindToNativeObject()) {
                return;
            }
            this._layout.init((TdkNativeCanvas)this);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this._firstTime = false;
        }
        if (this.isConnectedToNativeCanvas()) {
            this._layout.redraw();
        }
    }

    @Override
    protected void refresh(Graphics2D graphics2D) {
        this.refresh();
    }

    public void clear() {
        this.nativeClear(this._cPointer);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this._layout.mouseMove(mouseEvent.getX(), this.getHeight() - mouseEvent.getY(), TdkButton.btnLeft, TdkButtonState.btsPressed, TdkKeyboardState.kbsNone);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this._layout.mouseMove(mouseEvent.getX(), this.getHeight() - mouseEvent.getY(), TdkButton.btnLeft, TdkButtonState.btsUnpressed, TdkKeyboardState.kbsNone);
    }
}

