/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.map;

import com.vividsolutions.jts.geom.Envelope;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.core.swig.TdkSetup;
import org.tecgraf.jtdk.core.swig.TdkTheme;
import org.tecgraf.jtdk.core.swig.TdkThemeGID;
import org.tecgraf.jtdk.core.swig.TdkThemeGeographicObjectGIDSet;
import org.tecgraf.jtdk.core.swig.TdkThemeGroupGID;
import org.tecgraf.jtdk.core.swig.TdkViewGID;
import org.tecgraf.jtdk.core.swig.TdkViewGeographicObjectGIDSet;
import org.tecgraf.jtdk.core.swig.TdkViewNodeGID;
import org.tecgraf.jtdk.desktop.components.TdkObjectSelectionContextListener;
import org.tecgraf.jtdk.desktop.components.TdkViewChangeListener;
import org.tecgraf.jtdk.desktop.components.map.TdkMapDisplay;
import org.tecgraf.jtdk.desktop.components.treeview.TdkUpdateThemeEvent;
import org.tecgraf.jtdk.desktop.components.treeview.TdkUpdateViewEvent;

public class TdkMapController
implements TdkViewChangeListener,
TdkObjectSelectionContextListener {
    private static Logger _logger = Logger.getLogger(TdkMapController.class);
    protected TdkMapDisplay _display;

    public TdkMapController(TdkMapDisplay tdkMapDisplay) {
        this._display = tdkMapDisplay;
        _logger.debug((Object)("created controller for display: " + tdkMapDisplay));
    }

    @Override
    public void updateTheme(boolean bl, Object object, TdkThemeGID tdkThemeGID, TdkUpdateThemeEvent tdkUpdateThemeEvent) {
        if (!bl && (tdkUpdateThemeEvent.visibilityChanged() || tdkUpdateThemeEvent.legendVectorChanged() || tdkUpdateThemeEvent.selectedStyleChanged() || tdkUpdateThemeEvent.defaultStyleChanged() || tdkUpdateThemeEvent.minMaxScaleChanged() || tdkUpdateThemeEvent.isRasterMaskChanged() || tdkUpdateThemeEvent.tooltipChanged())) {
            _logger.debug((Object)"theme update, display redrawn");
            this._display.invalidate();
            this._display.redraw();
        }
    }

    @Override
    public void updateView(boolean bl, Object object, TdkViewGID tdkViewGID, TdkUpdateViewEvent tdkUpdateViewEvent) {
        if (!bl) {
            if (tdkUpdateViewEvent.projectionChanged()) {
                _logger.debug((Object)"view projection changed");
                TdkSetup.getGraphicalService().clearDatabaseBlocks(this._display.getView().getDBKey(), true, true);
                TdkSetup.getGraphicalService().clearVisualizationCache();
                this._display.fit();
            }
            if (tdkUpdateViewEvent.visibilityChanged() || tdkUpdateViewEvent.legendVectorChanged()) {
                _logger.debug((Object)"view update, display redrawn");
                this._display.invalidate();
                this._display.redraw();
            }
        }
    }

    @Override
    public void addViewNode(boolean bl, Object object, TdkViewGID tdkViewGID, TdkThemeGroupGID tdkThemeGroupGID, TdkViewNodeGID tdkViewNodeGID) {
        _logger.debug((Object)"added viewNode");
        this._display.redraw();
    }

    @Override
    public void removeViewNode(boolean bl, Object object, TdkViewGID tdkViewGID, TdkThemeGroupGID tdkThemeGroupGID, TdkViewNodeGID tdkViewNodeGID) {
        this._display.invalidate();
        this._display.redraw();
    }

    public void viewportResized(Object object, Envelope envelope) {
        if (object != this._display) {
            _logger.debug((Object)"viewport resized");
            this._display.updateWindowTransform();
        }
    }

    @Override
    public void updateThemeSet(boolean bl, Object object, Collection<TdkThemeGID> collection, TdkUpdateThemeEvent tdkUpdateThemeEvent) {
        if (!bl && (tdkUpdateThemeEvent.visibilityChanged() || tdkUpdateThemeEvent.legendVectorChanged() || tdkUpdateThemeEvent.selectedStyleChanged() || tdkUpdateThemeEvent.defaultStyleChanged() || tdkUpdateThemeEvent.minMaxScaleChanged())) {
            _logger.debug((Object)"theme set update, display redrawn");
            this._display.invalidate();
            this._display.redraw();
        }
    }

    @Override
    public void selectedObjectsChanged(boolean bl, Object object, TdkViewGeographicObjectGIDSet tdkViewGeographicObjectGIDSet) {
        if (object != this._display) {
            if (!bl) {
                TdkThemeGeographicObjectGIDSet tdkThemeGeographicObjectGIDSet = null;
                TdkTheme tdkTheme = null;
                TdkThemeGID tdkThemeGID = null;
                int n = 0;
                while ((long)n < tdkViewGeographicObjectGIDSet.getThemeIds().size()) {
                    tdkThemeGeographicObjectGIDSet = tdkViewGeographicObjectGIDSet.getTdkThemeGeographicObjectGIDSet(tdkViewGeographicObjectGIDSet.getThemeIds().get(n));
                    tdkThemeGID = new TdkThemeGID(tdkThemeGeographicObjectGIDSet.getThemeDBKey(), tdkThemeGeographicObjectGIDSet.getThemeId());
                    tdkTheme = TdkSetup.getPersistenceService().getTheme(tdkThemeGID);
                    TdkSetup.getGraphicalService().setObjectLegendsIds(tdkThemeGeographicObjectGIDSet, tdkTheme.getQueryLegend().getId());
                    ++n;
                }
                _logger.debug((Object)"object selection state changed");
                this._display.redraw();
            } else if (tdkViewGeographicObjectGIDSet != null) {
                TdkSetup.getGraphicalService().restoreObjectLegendsIds(tdkViewGeographicObjectGIDSet);
                _logger.debug((Object)"removed object selection, default map drawn");
            }
        }
    }

    @Override
    public void saveView(boolean bl, Object object, TdkViewGID tdkViewGID, TdkUpdateViewEvent tdkUpdateViewEvent) {
    }
}

