/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.map;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.core.TdkFeedback;
import org.tecgraf.jtdk.core.TdkNativeFeedback;
import org.tecgraf.jtdk.core.exceptions.TdkException;
import org.tecgraf.jtdk.core.graphics.TdkNativeCanvas;
import org.tecgraf.jtdk.core.swig.TdkSetup;
import org.tecgraf.jtdk.core.swig.TdkTimeTracker;
import org.tecgraf.jtdk.core.swig.TdkTimeTrackerFactory;
import org.tecgraf.jtdk.core.swig.TdkView;
import org.tecgraf.jtdk.core.swig.TdkViewGID;
import org.tecgraf.jtdk.desktop.components.dialogs.TdkProgressBarDialog;
import org.tecgraf.jtdk.desktop.components.map.TdkMapDisplayListener;
import org.tecgraf.jtdk.desktop.components.map.TdkMapElement;
import org.tecgraf.jtdk.desktop.components.map.TdkMenuElement;
import org.tecgraf.jtdk.desktop.components.map.TdkMenuElementItem;
import org.tecgraf.jtdk.desktop.components.map.TdkVisualSurface;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkInteractor;
import org.tecgraf.jtdk.desktop.components.util.TdkBlockingGlassPane;
import org.tecgraf.jtdk.desktop.components.util.TdkDialogUtil;
import org.tecgraf.jtdk.desktop.components.util.TdkMapUtil;

public class TdkMapDisplay
extends TdkVisualSurface
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private static final long serialVersionUID = -1129680318968948490L;
    private static Logger _logger = Logger.getLogger(TdkMapDisplay.class);
    protected List<TdkMapElement> _elements;
    protected List<TdkMenuElement> _menuElements;
    protected List<Integer> _menuElementsPriorities;
    protected List<Integer> _elementsPriorities;
    private boolean _firstTime = true;
    protected TdkViewGID _viewGID;
    protected boolean _autoSaveBox = true;
    private Collection<TdkMapDisplayListener> _mapDisplayListeners;
    private Collection<MouseListener> _mouseListeners;
    private Collection<MouseMotionListener> _mouseMotionListeners;
    private Collection<MouseWheelListener> _mouseWheelListeners;
    private Collection<TdkInteractor> _interactionsListener;
    private final Object _paintMutex = new Object();
    private final MyLock _lock = new MyLock();
    private boolean _menuEnabled = true;

    public TdkMapDisplay() {
        super.addMouseListener((MouseListener)this);
        super.addMouseMotionListener((MouseMotionListener)this);
        super.addMouseWheelListener((MouseWheelListener)this);
        this._mapDisplayListeners = new ArrayList<TdkMapDisplayListener>();
        this._mouseListeners = new ArrayList<MouseListener>();
        this._mouseMotionListeners = new ArrayList<MouseMotionListener>();
        this._mouseWheelListeners = new ArrayList<MouseWheelListener>();
        this._interactionsListener = new ArrayList<TdkInteractor>();
        _logger.debug((Object)"creation");
        this._elements = new ArrayList<TdkMapElement>();
        this._elementsPriorities = new ArrayList<Integer>();
        this._menuElements = new ArrayList<TdkMenuElement>();
        this._menuElementsPriorities = new ArrayList<Integer>();
        this._viewGID = null;
        this.setBackground(Color.WHITE);
    }

    public void setPopupMenuEnabled(boolean bl) {
        this._menuEnabled = bl;
    }

    @Override
    public void setWindow(Envelope envelope) {
        if (this._viewGID != null && this._autoSaveBox) {
            TdkView tdkView = TdkSetup.getPersistenceService().getView(this._viewGID);
            if (tdkView == null) {
                _logger.warn((Object)("could not retrieve view: " + this._viewGID));
                return;
            }
            tdkView.setCurrentBoundingBox(envelope);
        }
        super.setWindow(envelope);
    }

    @Override
    public void setWindow(double d, double d2, double d3, double d4) {
        if (this._autoSaveBox && this._viewGID != null) {
            TdkView tdkView = TdkSetup.getPersistenceService().getView(this._viewGID);
            if (tdkView == null) {
                _logger.warn((Object)("could not retrieve view: " + this._viewGID));
                return;
            }
            Envelope envelope = new Envelope(d, d3, d2, d4);
            tdkView.setCurrentBoundingBox(envelope);
        }
        super.setWindow(d, d2, d3, d4);
    }

    public void addMapDisplayListener(TdkMapDisplayListener tdkMapDisplayListener) {
        this._mapDisplayListeners.add(tdkMapDisplayListener);
    }

    public void removeMapDisplayListener(TdkMapDisplayListener tdkMapDisplayListener) {
        this._mapDisplayListeners.remove(tdkMapDisplayListener);
    }

    public void setView(TdkViewGID tdkViewGID) {
        _logger.debug((Object)("setting view: " + tdkViewGID + ",old view: " + this._viewGID));
        this._viewGID = tdkViewGID;
        if (tdkViewGID != null) {
            TdkView tdkView = TdkSetup.getPersistenceService().getView(tdkViewGID);
        }
        this.restoreViewCurrentBox();
    }

    public TdkViewGID getView() {
        return this._viewGID;
    }

    public void restoreViewCurrentBox() {
        if (this.isInitialized() && this._viewGID != null) {
            TdkView tdkView = TdkSetup.getPersistenceService().getView(this._viewGID);
            if (tdkView == null) {
                _logger.warn((Object)("could not retrieve view: " + this._viewGID));
                return;
            }
            Envelope envelope = tdkView.getCurrentBoundingBox();
            _logger.debug((Object)("restoring view box: " + envelope));
            this.zoomArea(envelope);
            this.clearNavigationHistory();
            this.needRedraw(true);
        }
    }

    public void clear() {
        this.fireMapClearedEvent(true);
        _logger.debug((Object)"clear operation");
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        if (graphics2D == null) {
            _logger.warn((Object)"could not get graphics context");
            return;
        }
        this.nativeClear(this._cPointer);
        this.fireMapClearedEvent(false);
    }

    public BufferedImage getSnapshot(boolean bl) {
        _logger.debug((Object)"getting snapshot");
        BufferedImage bufferedImage = this.nativeGetImage(this.getNativeCanvasCPtr());
        if (bufferedImage == null) {
            _logger.warn((Object)"nativeGetImage returned null");
            return null;
        }
        if (!this.usingOpenGL() && bl) {
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            boolean bl2 = this._needRedraw;
            this.paintMapElements(graphics2D);
            if (this._needRedraw != bl2) {
                this.needRedraw(bl2);
            }
        }
        return bufferedImage;
    }

    private void markMapElementsAsNeedingDrawUpdate() {
        for (int i = 0; i < this._elements.size(); ++i) {
            this._elements.get(i).setNeedDrawUpdate(true);
        }
    }

    public void paintMapElements(Graphics2D graphics2D) {
        for (int i = 0; i < this._elements.size(); ++i) {
            this._elements.get(i).draw(graphics2D, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics graphics) {
        Object object = this._paintMutex;
        synchronized (object) {
            if (this._lock.isLock()) {
                return;
            }
            this._lock.lock();
        }
        if (this.isConnectedToNativeCanvas() && this.handleChanged()) {
            _logger.debug((Object)"The canvas native handle is invalid.");
            this.disconnect();
            this._firstTime = true;
            this._needRedraw = true;
        }
        super.paint(graphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void draw(Graphics2D graphics2D) {
        _logger.debug((Object)"draw operation");
        this.initNativeCanvas();
        if (!this.isConnectedToNativeCanvas()) {
            _logger.warn((Object)"not connected to native canvas");
            return;
        }
        this.fireMapDrawnEvent(true);
        final TdkMapDisplay tdkMapDisplay = this;
        final Frame frame = TdkDialogUtil.getFrameParent((Component)((Object)this));
        final TdkNativeFeedback tdkNativeFeedback = new TdkNativeFeedback();
        final boolean bl = this.usingOpenGL();
        if (this._viewGID != null) {
            this.setEnabled(false);
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    _logger.debug((Object)"draw operation in thread");
                    TdkMapDisplay.this.needRedraw(false);
                    Component component = null;
                    TdkBlockingGlassPane tdkBlockingGlassPane = new TdkBlockingGlassPane();
                    if (frame != null && frame instanceof JFrame) {
                        component = ((JFrame)frame).getGlassPane();
                        ((JFrame)frame).setGlassPane(tdkBlockingGlassPane);
                        ((Component)tdkBlockingGlassPane).setVisible(true);
                    }
                    try {
                        if (TdkMapDisplay.this._viewGID != null) {
                            try {
                                long l = 1000L;
                                if (!bl) {
                                    TdkMapDisplay.this.clear();
                                    l = 2500L;
                                }
                                TdkTimeTrackerFactory tdkTimeTrackerFactory = new TdkTimeTrackerFactory();
                                TdkTimeTracker tdkTimeTracker = tdkTimeTrackerFactory.createTimeTracker(l);
                                TdkSetup.getGraphicalService().drawView(TdkMapDisplay.this._viewGID, (TdkNativeCanvas)tdkMapDisplay, tdkTimeTracker, tdkNativeFeedback, true);
                                BufferedImage bufferedImage = TdkMapDisplay.this.createCanvasSizedTransparentBufferImage();
                                TdkMapDisplay.this.paintMapElements((Graphics2D)bufferedImage.getGraphics());
                                if (bl) {
                                    TdkMapDisplay.this.putImage(bufferedImage);
                                    TdkMapDisplay.this.copyBackToFrontBuffer();
                                } else if (SwingUtilities.isEventDispatchThread()) {
                                    TdkMapDisplay.this.getGraphics().drawImage(bufferedImage, 0, 0, null);
                                } else {
                                    try {
                                        final BufferedImage bufferedImage2 = bufferedImage;
                                        SwingUtilities.invokeAndWait(new Runnable(){

                                            @Override
                                            public void run() {
                                                TdkMapDisplay.this.getGraphics().drawImage(bufferedImage2, 0, 0, null);
                                            }
                                        });
                                    }
                                    catch (Exception exception) {
                                        _logger.debug((Object)"Error while drawing the map elements on the non-OpenGL code path.");
                                    }
                                }
                                TdkMapDisplay.this.fireMapDrawnEvent(false);
                            }
                            catch (TdkException tdkException) {
                                _logger.error((Object)"draw view tree error", (Throwable)tdkException);
                            }
                        }
                        _logger.debug((Object)"finish draw operation in thread");
                    }
                    catch (Exception exception) {
                        _logger.error((Object)"draw operation error", (Throwable)exception);
                    }
                    finally {
                        if (frame != null && frame instanceof JFrame) {
                            ((Component)tdkBlockingGlassPane).setVisible(false);
                            ((JFrame)frame).setGlassPane(component);
                            TdkMapDisplay.this.setEnabled(true);
                        }
                        TdkMapDisplay.this._lock.unlock();
                    }
                }
            };
            this.executeDrawRunnable(frame, tdkNativeFeedback, runnable);
        } else {
            try {
                BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
                Graphics2D graphics2D2 = (Graphics2D)bufferedImage.getGraphics();
                graphics2D2.setBackground(this.getBackground());
                Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight());
                graphics2D2.fill(double_);
                this.paintMapElements(graphics2D2);
                if (bl) {
                    this.putImage(bufferedImage);
                    this.copyBackToFrontBuffer();
                    this.fireMapDrawnEvent(false);
                } else if (SwingUtilities.isEventDispatchThread()) {
                    this.paintMapElements(graphics2D);
                } else {
                    _logger.debug((Object)"Tried to refresh the map elements in a thread other than the EDT.");
                }
            }
            finally {
                this._lock.unlock();
            }
        }
        _logger.debug((Object)"finish draw operation");
    }

    protected BufferedImage createCanvasSizedTransparentBufferImage() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        Color color = new Color(1.0f, 1.0f, 1.0f, 0.0f);
        graphics2D.setBackground(color);
        return bufferedImage;
    }

    protected void executeDrawRunnable(Frame frame, TdkNativeFeedback tdkNativeFeedback, Runnable runnable) {
        TdkProgressBarDialog tdkProgressBarDialog = new TdkProgressBarDialog(frame, "Desenhando mapa", true, false, true, 2000L);
        tdkProgressBarDialog.setSyncronizedExecution(this.isExecutionSyncronized());
        try {
            if (this.usingOpenGL()) {
                runnable.run();
            } else {
                tdkProgressBarDialog.execute(runnable, (TdkFeedback)tdkNativeFeedback);
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"draw map display error", (Throwable)exception);
        }
    }

    protected boolean isExecutionSyncronized() {
        return false;
    }

    @Override
    protected synchronized void refresh(Graphics2D graphics2D) {
        this._lock.unlock();
        _logger.debug((Object)"refresh operation");
        if (this.usingOpenGL()) {
            this.draw(graphics2D);
            this.needRedraw(false);
        } else {
            this.fireMapDrawnEvent(true);
            this.refresh();
            BufferedImage bufferedImage = this.createCanvasSizedTransparentBufferImage();
            this.paintMapElements((Graphics2D)bufferedImage.getGraphics());
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            this.fireMapDrawnEvent(false);
        }
    }

    public void addInteractionListener(TdkInteractor tdkInteractor) {
        _logger.debug((Object)("adding interaction listener: " + tdkInteractor));
        this._interactionsListener.add(tdkInteractor);
        this.addMouseListener(tdkInteractor);
        this.addMouseMotionListener(tdkInteractor);
        this.addMapDisplayListener(tdkInteractor);
    }

    public void removeInteractionListener(TdkInteractor tdkInteractor) {
        this._interactionsListener.remove(tdkInteractor);
        this.removeMouseListener(tdkInteractor);
        this.removeMapDisplayListener(tdkInteractor);
        this.removeMouseMotionListener(tdkInteractor);
    }

    public void addMenuElement(TdkMenuElement tdkMenuElement, int n) {
        int n2 = this._menuElements.indexOf(tdkMenuElement);
        if (n2 != -1) {
            this._menuElements.remove(n2);
            this._menuElementsPriorities.remove(n2);
        }
        n2 = 0;
        if (this._menuElements.size() > 0) {
            while (this._menuElementsPriorities.get(n2) > n && ++n2 < this._menuElementsPriorities.size()) {
            }
        }
        _logger.debug((Object)("adding menu element in position " + n2 + ": " + tdkMenuElement));
        this._menuElements.add(n2, tdkMenuElement);
        this._menuElementsPriorities.add(n2, n);
    }

    public void addElement(TdkMapElement tdkMapElement, int n) {
        int n2 = this._elements.indexOf(tdkMapElement);
        if (n2 != -1) {
            this._elements.remove(n2);
            this._elementsPriorities.remove(n2);
        }
        n2 = 0;
        if (this._elements.size() > 0) {
            while (this._elementsPriorities.get(n2) > n && ++n2 < this._elementsPriorities.size()) {
            }
        }
        _logger.debug((Object)("adding map element in position " + n2 + ": " + tdkMapElement));
        this._elements.add(n2, tdkMapElement);
        this._elementsPriorities.add(n2, n);
    }

    public void removeElement(TdkMapElement tdkMapElement) {
        _logger.debug((Object)("removing map element: " + tdkMapElement));
        int n = this._elements.indexOf(tdkMapElement);
        if (n != -1) {
            this._elements.remove(n);
            this._elementsPriorities.remove(n);
        }
    }

    public void fit() {
        if (!this.isInitialized()) {
            _logger.warn((Object)"called without being initialized");
            return;
        }
        Envelope envelope = new Envelope();
        for (int i = 0; i < this._elements.size(); ++i) {
            Envelope envelope2 = this._elements.get(i).getWindowBoundingBox();
            if (envelope2 == null) continue;
            envelope.expandToInclude(envelope2);
        }
        if (this._viewGID != null) {
            TdkView tdkView = TdkSetup.getPersistenceService().getView(this._viewGID);
            if (tdkView != null) {
                envelope.expandToInclude(tdkView.getVisibleBoundingBox());
            } else {
                _logger.warn((Object)("View " + this._viewGID + " could not be retrieved from the persistence service"));
            }
        }
        if (envelope.isNull()) {
            envelope = this._window;
        }
        _logger.debug((Object)("fit operation: " + envelope));
        envelope = TdkMapUtil.addBorderToBox(envelope, this);
        this.zoomArea(envelope);
    }

    public synchronized void initNativeCanvas() {
        if (this._firstTime) {
            TdkView tdkView;
            _logger.debug((Object)"initializing native canvas");
            if (!this.bindToNativeObject()) {
                _logger.warn((Object)"could not connect to native canvas");
                return;
            }
            this.nativeSetViewPort(this._cPointer, this._viewPort.getMinX(), this._viewPort.getMaxX(), this._viewPort.getMinY(), this._viewPort.getMaxY());
            this.nativeSetWindow(this._cPointer, this._window.getMinX(), this._window.getMaxX(), this._window.getMinY(), this._window.getMaxY());
            Color color = this.getBackground();
            this.nativeSetBackground(this._cPointer, color.getRed(), color.getGreen(), color.getBlue());
            if (this._viewGID != null && (tdkView = TdkSetup.getPersistenceService().getView(this._viewGID)) != null) {
                this.setViewProjection(tdkView.getProjection());
            }
            this._firstTime = false;
        }
    }

    private void fireMapDrawnEvent(boolean bl) {
        for (TdkMapDisplayListener tdkMapDisplayListener : this._mapDisplayListeners) {
            tdkMapDisplayListener.mapDrawn(bl, this);
        }
    }

    private void fireMapClearedEvent(boolean bl) {
        for (TdkMapDisplayListener tdkMapDisplayListener : this._mapDisplayListeners) {
            tdkMapDisplayListener.mapCleared(bl, this);
        }
    }

    @Override
    protected void resize(double d, double d2, double d3, double d4) {
        boolean bl = !this.isInitialized();
        super.resize(d, d2, d3, d4);
        if (bl && this.isInitialized()) {
            this.restoreViewCurrentBox();
        }
    }

    public void addMouseListener(MouseListener mouseListener) {
        this._mouseListeners.add(mouseListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this._mouseListeners.remove(mouseListener);
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this._mouseMotionListeners.add(mouseMotionListener);
    }

    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this._mouseMotionListeners.remove(mouseMotionListener);
    }

    public void addMouseWheelListener(MouseWheelListener mouseWheelListener) {
        this._mouseWheelListeners.add(mouseWheelListener);
    }

    public void removeMouseWheelListener(MouseWheelListener mouseWheelListener) {
        this._mouseWheelListeners.remove(mouseWheelListener);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        for (TdkMapElement object : this._elements) {
            object.mouseClicked(mouseEvent);
            if (!mouseEvent.isConsumed()) continue;
            return;
        }
        for (MouseListener mouseListener : this._mouseListeners) {
            mouseListener.mouseClicked(mouseEvent);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        for (TdkMapElement object : this._elements) {
            object.mousePressed(mouseEvent);
            if (!mouseEvent.isConsumed()) continue;
            return;
        }
        for (MouseListener mouseListener : this._mouseListeners) {
            mouseListener.mousePressed(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        for (TdkMapElement object : this._elements) {
            object.mouseReleased(mouseEvent);
            if (!mouseEvent.isConsumed()) continue;
            return;
        }
        for (MouseListener mouseListener : this._mouseListeners) {
            mouseListener.mouseReleased(mouseEvent);
        }
        if (mouseEvent.isConsumed()) {
            return;
        }
        if (mouseEvent.isPopupTrigger() && this._menuEnabled) {
            boolean bl;
            JPopupMenu jPopupMenu = new JPopupMenu();
            boolean bl2 = false;
            for (TdkMenuElement tdkMenuElement : this._menuElements) {
                Collection<TdkMenuElementItem> collection = tdkMenuElement.getMenuItens(mouseEvent.getX(), mouseEvent.getY());
                if (collection == null) continue;
                for (TdkMenuElementItem tdkMenuElementItem : collection) {
                    if (tdkMenuElementItem.getItem() == null) {
                        jPopupMenu.addSeparator();
                    } else {
                        jPopupMenu.add(tdkMenuElementItem.getItem());
                    }
                    bl = true;
                }
            }
            jPopupMenu.setLightWeightPopupEnabled(false);
            if (bl) {
                jPopupMenu.show((Component)((Object)this), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        for (TdkMapElement object : this._elements) {
            object.mouseEntered(mouseEvent);
            if (!mouseEvent.isConsumed()) continue;
            return;
        }
        for (MouseListener mouseListener : this._mouseListeners) {
            mouseListener.mouseEntered(mouseEvent);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        for (TdkMapElement object : this._elements) {
            object.mouseExited(mouseEvent);
            if (!mouseEvent.isConsumed()) continue;
            return;
        }
        for (MouseListener mouseListener : this._mouseListeners) {
            mouseListener.mouseExited(mouseEvent);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        for (TdkMapElement object : this._elements) {
            object.mouseDragged(mouseEvent);
            if (!mouseEvent.isConsumed()) continue;
            return;
        }
        for (MouseMotionListener mouseMotionListener : this._mouseMotionListeners) {
            mouseMotionListener.mouseDragged(mouseEvent);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        for (TdkMapElement object : this._elements) {
            object.mouseMoved(mouseEvent);
        }
        for (MouseMotionListener mouseMotionListener : this._mouseMotionListeners) {
            mouseMotionListener.mouseMoved(mouseEvent);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        for (TdkMapElement object : this._elements) {
            object.mouseWheelMoved(mouseWheelEvent);
            if (!mouseWheelEvent.isConsumed()) continue;
            return;
        }
        for (MouseWheelListener mouseWheelListener : this._mouseWheelListeners) {
            mouseWheelListener.mouseWheelMoved(mouseWheelEvent);
        }
    }

    public void setAutoSaveViewBox(boolean bl) {
        this._autoSaveBox = bl;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void invalidate() {
        this.markMapElementsAsNeedingDrawUpdate();
        super.invalidate();
    }

    private class MyLock {
        boolean _lock = false;

        private MyLock() {
        }

        public void lock() {
            this._lock = true;
        }

        public void unlock() {
            this._lock = false;
        }

        public boolean isLock() {
            return this._lock;
        }
    }
}

