/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.map;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.desktop.components.TdkComponentsI18n;
import org.tecgraf.jtdk.desktop.components.map.TdkMapDisplay;
import org.tecgraf.jtdk.desktop.components.map.TdkNavigationToolBarController;
import org.tecgraf.jtdk.desktop.components.map.TdkVisualSurface;
import org.tecgraf.jtdk.desktop.components.map.TdkVisualSurfaceListener;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkFitTool;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkInteractorTool;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkMultiInteractorTool;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkPanTool;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkRulerTool;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkSimpleTool;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkTool;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkZoomInTool;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkZoomOutTool;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkZoomRectTool;
import org.tecgraf.jtdk.desktop.components.util.TdkToolBar;

public class TdkNavigationToolBar
extends TdkToolBar
implements TdkVisualSurfaceListener {
    private static Logger _logger = Logger.getLogger(TdkNavigationToolBar.class);
    public static final String ACT_CMD_CAN_UNDO = "can_undo_command";
    public static final String ACT_CMD_CAN_NOT_UNDO = "can_not_undo_command";
    public static final String ACT_CMD_CAN_REDO = "can_redo_command";
    public static final String ACT_CMD_CAN_NOT_REDO = "can_not_redo_command";
    public static final String BTN_UNDO = "undo";
    public static final String BTN_REDO = "redo";
    private JButton _redoButton;
    private JButton _undoButton;
    private JToggleButton _defaultToolButton;
    private List<AbstractButton> _buttonList = new ArrayList<AbstractButton>();
    private List<TdkTool> _toolList = new ArrayList<TdkTool>();
    TdkNavigationToolBarController _controller = null;
    private TdkInteractorTool _defaultTool;

    public TdkNavigationToolBar(TdkMapDisplay tdkMapDisplay) {
        this();
        this.setMapDisplay(tdkMapDisplay);
    }

    public void setMapDisplay(TdkMapDisplay tdkMapDisplay) {
        this._controller = new TdkNavigationToolBarController();
        this._controller.setMapDisplay(tdkMapDisplay);
        if (this._defaultTool != null && this._defaultToolButton != null) {
            this._controller.setDefaultTool(this._defaultTool, this._defaultToolButton);
        }
        tdkMapDisplay.addVisualSurfaceListener(this);
        _logger.debug((Object)("map display set: " + tdkMapDisplay));
    }

    public void setDefaultTool(TdkInteractorTool tdkInteractorTool) {
        if (this._defaultToolButton != null) {
            this.remove(this._defaultToolButton);
        }
        JToggleButton jToggleButton = this.createToggleButton();
        jToggleButton.setName(tdkInteractorTool.getName());
        jToggleButton.setIcon(tdkInteractorTool.getIcon());
        jToggleButton.setBorder(tdkInteractorTool.getBorder());
        jToggleButton.setToolTipText(tdkInteractorTool.getToolTipText());
        this.add((Component)jToggleButton, 0);
        this._defaultTool = tdkInteractorTool;
        this._defaultToolButton = jToggleButton;
        if (this._controller != null) {
            this._controller.setDefaultTool(this._defaultTool, this._defaultToolButton);
        }
        this.repaint();
    }

    public TdkNavigationToolBar() {
        _logger.debug((Object)"created");
    }

    protected JToggleButton createToggleButton() {
        return new JToggleButton();
    }

    protected JButton createJButton() {
        return new JButton();
    }

    protected JToggleButton createMenuButton() {
        return new JToggleButton();
    }

    public AbstractButton add(TdkTool tdkTool) {
        return this.add(tdkTool, false);
    }

    public AbstractButton add(TdkTool tdkTool, boolean bl) {
        AbstractButton abstractButton = null;
        if (tdkTool instanceof TdkInteractorTool) {
            if (tdkTool instanceof TdkMultiInteractorTool) {
                abstractButton = this.createMenuButton();
                ((TdkMultiInteractorTool)tdkTool).setParentButton(abstractButton);
            } else {
                abstractButton = this.createToggleButton();
            }
        } else if (tdkTool instanceof TdkSimpleTool) {
            abstractButton = this.createJButton();
        }
        if (abstractButton != null) {
            abstractButton.setName(tdkTool.getName());
            abstractButton.setIcon(tdkTool.getIcon());
            abstractButton.setBorder(tdkTool.getBorder());
            abstractButton.setToolTipText(tdkTool.getToolTipText());
            this._buttonList.add(abstractButton);
            this._toolList.add(tdkTool);
            if (bl) {
                this.addComponent(abstractButton);
            } else {
                this.add(abstractButton);
            }
            if (this._controller != null) {
                this._controller.setListener(tdkTool, abstractButton);
            }
        }
        _logger.debug((Object)("added " + tdkTool.getName() + " tool"));
        return abstractButton;
    }

    public List<TdkTool> getTools() {
        return this._toolList;
    }

    public AbstractButton getButton(TdkTool tdkTool) {
        AbstractButton abstractButton = null;
        int n = this._toolList.indexOf(tdkTool);
        if (n >= 0) {
            abstractButton = this._buttonList.get(n);
        }
        return abstractButton;
    }

    private void registerActionListener(TdkNavigationToolBarController tdkNavigationToolBarController) {
        for (int i = 0; i < this._buttonList.size(); ++i) {
            tdkNavigationToolBarController.setListener(this._toolList.get(i), this._buttonList.get(i));
        }
        this._redoButton.addActionListener(tdkNavigationToolBarController);
        this._undoButton.addActionListener(tdkNavigationToolBarController);
    }

    public JButton buildBack() {
        this._undoButton = this.createJButton();
        this._undoButton.setName(BTN_UNDO);
        this._undoButton.setIcon(new ImageIcon(this.getClass().getResource("/org/tecgraf/jtdk/desktop/components/icons/undo.png")));
        this._undoButton.setBorder(BorderFactory.createBevelBorder(0));
        this._undoButton.setActionCommand("undo_command");
        this._undoButton.setToolTipText(TdkComponentsI18n.getString("NAV_TOOL_BAR_UNDO_TIP"));
        if (this._controller != null) {
            this._undoButton.addActionListener(this._controller);
        }
        return this._undoButton;
    }

    public JButton buildForward() {
        this._redoButton = this.createJButton();
        this._redoButton.setName(BTN_REDO);
        this._redoButton.setIcon(new ImageIcon(this.getClass().getResource("/org/tecgraf/jtdk/desktop/components/icons/redo.png")));
        this._redoButton.setBorder(BorderFactory.createBevelBorder(0));
        this._redoButton.setActionCommand("redo_command");
        this._redoButton.setToolTipText(TdkComponentsI18n.getString("NAV_TOOL_BAR_REDO_TIP"));
        if (this._controller != null) {
            this._redoButton.addActionListener(this._controller);
        }
        return this._redoButton;
    }

    public void initDefaultTools(TdkMapDisplay tdkMapDisplay) {
        if (this._controller == null) {
            throw new IllegalArgumentException("Display needed to be add before");
        }
        this.removeAll();
        this.add(new TdkZoomInTool(tdkMapDisplay), true);
        this.add(new TdkZoomOutTool(tdkMapDisplay), true);
        this.add(new TdkZoomRectTool(tdkMapDisplay), true);
        this.add(new TdkPanTool(tdkMapDisplay), true);
        this.addVerticalSeparator();
        this.add(new TdkFitTool(tdkMapDisplay), true);
        this.add(new TdkRulerTool(tdkMapDisplay), true);
        this.addVerticalSeparator();
        JButton jButton = this.buildBack();
        this.addComponent(jButton);
        JButton jButton2 = this.buildForward();
        this.addComponent(jButton2);
        this.initComponents();
    }

    @Override
    public void viewportResized(Object object, Envelope envelope) {
        TdkVisualSurface tdkVisualSurface = (TdkVisualSurface)object;
        if (tdkVisualSurface.canUndo()) {
            this._undoButton.setEnabled(true);
        } else {
            this._undoButton.setEnabled(false);
        }
        if (tdkVisualSurface.canRedo()) {
            this._redoButton.setEnabled(true);
        } else {
            this._redoButton.setEnabled(false);
        }
    }

    @Override
    public void windowChanged(boolean bl, Object object, Envelope envelope) {
        if (!bl) {
            TdkVisualSurface tdkVisualSurface = (TdkVisualSurface)object;
            if (tdkVisualSurface.canUndo()) {
                this._undoButton.setEnabled(true);
            } else {
                this._undoButton.setEnabled(false);
            }
            if (tdkVisualSurface.canRedo()) {
                this._redoButton.setEnabled(true);
            } else {
                this._redoButton.setEnabled(false);
            }
        }
    }

    @Override
    public void windowHistoryCleared() {
        this._redoButton.setEnabled(false);
        this._undoButton.setEnabled(false);
    }
}

