/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.map;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JToggleButton;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.desktop.components.map.TdkMapDisplay;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkInteractor;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkInteractorTool;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkSimpleTool;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkTool;

public class TdkNavigationToolBarController
implements ActionListener {
    private static Logger _logger = Logger.getLogger(TdkNavigationToolBarController.class);
    public static final String ACT_CMD_ZOOM_IN = "zoom_in_command";
    public static final String ACT_CMD_ZOOM_OUT = "zoom_out_command";
    public static final String ACT_CMD_ZOOM_RECT = "zoom_rect_command";
    public static final String ACT_CMD_PAN = "pan_command";
    public static final String ACT_CMD_FIT = "fit_command";
    public static final String ACT_CMD_FIT_SELECTED = "fit_selected_command";
    public static final String ACT_CMD_UNDO = "undo_command";
    public static final String ACT_CMD_REDO = "redo_command";
    public static final String ACT_CMD_RULER = "ruler_command";
    public static final String ACT_CMD_REMOVE_CURRENT_INTERACTOR = "remove_current_interactor_command";
    public static final String CURSOR_NAME_PAN = "pan_cursor";
    public static final String CURSOR_NAME_PAN_PRESS = "pan_cursor_pressed";
    public static final String CURSOR_NAME_ZOOM = "zoom_cursor";
    public static final String CURSOR_NAME_RULER = "ruler_cursor";
    private TdkMapDisplay _mapDisplay;
    private TdkInteractor _currentInteractor;
    protected Cursor _releasedPanCursor;
    protected Cursor _pressedPanCursor;
    protected Cursor _zoomCursor;
    protected Cursor _rulerCursor;
    private final List<TdkInteractorTool> _interactorToolList = new ArrayList<TdkInteractorTool>();
    private final List<JToggleButton> _interactorButtonList = new ArrayList<JToggleButton>();
    private TdkInteractorTool _defaultTool;
    private JToggleButton _defaultToolButton;

    public TdkNavigationToolBarController() {
    }

    public void setDefaultTool(TdkInteractorTool tdkInteractorTool, JToggleButton jToggleButton) {
        ActionListener[] actionListenerArray;
        if (this._defaultTool != null && this._defaultToolButton != null) {
            this._interactorButtonList.remove(this._defaultToolButton);
            this._interactorToolList.remove(this._defaultTool);
        }
        this._defaultTool = tdkInteractorTool;
        this._defaultToolButton = jToggleButton;
        for (ActionListener actionListener : actionListenerArray = (ActionListener[])jToggleButton.getListeners(ActionListener.class)) {
            jToggleButton.removeActionListener(actionListener);
        }
        if (tdkInteractorTool instanceof TdkInteractorTool) {
            jToggleButton.addActionListener(new DefaultToolActionListener(jToggleButton, tdkInteractorTool));
            this._interactorButtonList.add(jToggleButton);
            this._interactorToolList.add(tdkInteractorTool);
        }
        _logger.debug((Object)(this._defaultTool.getName() + " tool set as default"));
        this.changeTools(this._defaultTool);
    }

    public TdkNavigationToolBarController(TdkTool tdkTool, TdkMapDisplay tdkMapDisplay) {
        this();
        this._mapDisplay = tdkMapDisplay;
    }

    public void setMapDisplay(TdkMapDisplay tdkMapDisplay) {
        this._mapDisplay = tdkMapDisplay;
    }

    public void setListener(TdkTool tdkTool, AbstractButton abstractButton) {
        if (abstractButton != null) {
            ActionListener[] actionListenerArray;
            for (ActionListener actionListener : actionListenerArray = (ActionListener[])abstractButton.getListeners(ActionListener.class)) {
                abstractButton.removeActionListener(actionListener);
            }
            if (tdkTool instanceof TdkInteractorTool) {
                abstractButton.addActionListener(new InteractionActionListener((TdkInteractorTool)tdkTool));
                if (!(abstractButton instanceof JToggleButton)) {
                    throw new IllegalArgumentException("Interaction tools need have a JToogleButton");
                }
                this._interactorButtonList.add((JToggleButton)abstractButton);
                this._interactorToolList.add((TdkInteractorTool)tdkTool);
            } else if (tdkTool instanceof TdkSimpleTool) {
                abstractButton.addActionListener(new SimpleActionListener((TdkSimpleTool)tdkTool));
            }
        }
    }

    private void changeTools(TdkInteractorTool tdkInteractorTool) {
        Object object;
        Object object2;
        int n;
        if (tdkInteractorTool == null) {
            return;
        }
        for (n = 0; n < this._interactorToolList.size(); ++n) {
            object2 = this._interactorToolList.get(n);
            object = this._interactorButtonList.get(n);
            if (object2 == null || object2.equals(tdkInteractorTool) || object == null || !((AbstractButton)object).isSelected()) continue;
            ((TdkInteractorTool)object2).finish();
            ((AbstractButton)object).setSelected(false);
            _logger.debug((Object)(((TdkTool)object2).getName() + " deselected"));
        }
        n = 1;
        object2 = null;
        if (this._currentInteractor != null) {
            this._mapDisplay.removeInteractionListener(this._currentInteractor);
            if (this._currentInteractor.equals(tdkInteractorTool.getInteractor())) {
                this._mapDisplay.setCursor(Cursor.getDefaultCursor());
                tdkInteractorTool.finish();
                if (this._defaultTool == null) {
                    n = 0;
                } else {
                    tdkInteractorTool = this._defaultTool;
                }
            }
            this._currentInteractor = null;
        }
        if (tdkInteractorTool.equals(this._defaultTool)) {
            object2 = this._defaultToolButton;
        }
        this._mapDisplay.setPopupMenuEnabled(false);
        if (n != 0) {
            tdkInteractorTool.start();
            object = tdkInteractorTool.getInteractor();
            if (object == null) {
                throw new RuntimeException("Interactor can't be null");
            }
            if (object2 != null) {
                ((AbstractButton)object2).setSelected(true);
            }
            this._mapDisplay.addInteractionListener((TdkInteractor)object);
            this._currentInteractor = object;
        }
        _logger.debug((Object)(tdkInteractorTool.getName() + " selected"));
    }

    private void undoButtonActionPerformed() {
        _logger.info((Object)"Action Performed: undo_command");
        if (this._mapDisplay == null) {
            _logger.warn((Object)"No TdkMapDisplay is associated to this controller, _mapDisplay is null.");
            return;
        }
        this._mapDisplay.undo();
        this._mapDisplay.redraw();
    }

    private void redoButtonActionPerformed() {
        _logger.info((Object)"Action Performed: redo_command");
        if (this._mapDisplay == null) {
            _logger.warn((Object)"No TdkMapDisplay is associated to this controller, _mapDisplay is null.");
            return;
        }
        this._mapDisplay.redo();
        this._mapDisplay.redraw();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(ACT_CMD_UNDO)) {
            this.undoButtonActionPerformed();
        } else if (string.equals(ACT_CMD_REDO)) {
            this.redoButtonActionPerformed();
        } else {
            _logger.warn((Object)("Unknown action performed: " + string));
        }
    }

    private class SimpleActionListener
    implements ActionListener {
        TdkSimpleTool _tool;

        public SimpleActionListener(TdkSimpleTool tdkSimpleTool) {
            this._tool = tdkSimpleTool;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this._tool.actionPerformed(actionEvent);
        }
    }

    private class DefaultToolActionListener
    extends InteractionActionListener {
        private JToggleButton _defaultButton;

        public DefaultToolActionListener(JToggleButton jToggleButton, TdkInteractorTool tdkInteractorTool) {
            super(tdkInteractorTool);
            this._defaultButton = jToggleButton;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this._defaultButton.isSelected()) {
                super.actionPerformed(actionEvent);
            } else {
                this._defaultButton.setSelected(true);
            }
        }
    }

    private class InteractionActionListener
    implements ActionListener {
        TdkInteractorTool _tool;

        public InteractionActionListener(TdkInteractorTool tdkInteractorTool) {
            this._tool = tdkInteractorTool;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TdkNavigationToolBarController.this.changeTools(this._tool);
        }
    }
}

