/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.map;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.AffineTransform;
import java.util.LinkedList;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.core.graphics.TdkNativeCanvas;
import org.tecgraf.jtdk.desktop.components.map.TdkVisualSurfaceListener;
import org.tecgraf.jtdk.desktop.components.map.utils.TdkVisualSurfaceUtils;

public abstract class TdkVisualSurface
extends TdkNativeCanvas
implements ComponentListener {
    private static Logger _logger = Logger.getLogger(TdkVisualSurface.class);
    private boolean _initialized = false;
    protected boolean _needRedraw;
    protected Envelope _window;
    protected Envelope _viewPort;
    private Envelope _limitWindow;
    private AffineTransform _windowTransform;
    private AffineTransform _viewportTransform;
    private LinkedList<Envelope> _undoManager;
    private int _currentPos;
    private boolean _clearForwardUndoHistory = true;
    private Vector<TdkVisualSurfaceListener> _surfaceListeners;
    private final boolean INVERTED_Y = true;
    private boolean _isPainting = false;

    public TdkVisualSurface() {
        _logger.debug((Object)"creation");
        this.needRedraw(true);
        this._window = new Envelope(0.0, 0.0, 0.0, 0.0);
        this._viewPort = new Envelope(0.0, 0.0, 0.0, 0.0);
        this.setLimitWindow(new Envelope(-1.0E11, 1.0E11, -1.0E11, 1.0E11));
        this._viewportTransform = new AffineTransform();
        this.updateWindowTransform();
        this._undoManager = new LinkedList();
        this._undoManager.add(new Envelope(this._window));
        this._currentPos = 0;
        this._surfaceListeners = new Vector();
        this.addComponentListener(this);
    }

    public boolean isInitialized() {
        return this._initialized;
    }

    public void needRedraw(boolean bl) {
        this._needRedraw = bl;
    }

    public void clearNavigationHistory() {
        _logger.debug((Object)"clear navigation history operation");
        this._undoManager.clear();
        this._undoManager.add(new Envelope(this._window));
        this._currentPos = 0;
        this.fireWindowHistoryClearedEvent();
    }

    public Envelope getWindow() {
        return new Envelope(this._window);
    }

    public Envelope getViewport() {
        return new Envelope(this._viewPort);
    }

    public Envelope getLimitWindow() {
        return this._limitWindow;
    }

    public void setLimitWindow(Envelope envelope) {
        this._limitWindow = envelope;
    }

    public AffineTransform getWindowTransform() {
        return this._windowTransform;
    }

    public AffineTransform getViewportTransform() {
        return this._viewportTransform;
    }

    public void addVisualSurfaceListener(TdkVisualSurfaceListener tdkVisualSurfaceListener) {
        _logger.debug((Object)("adding surface listener: " + tdkVisualSurfaceListener));
        this._surfaceListeners.add(tdkVisualSurfaceListener);
    }

    public void removeVisualSurfaceListener(TdkVisualSurfaceListener tdkVisualSurfaceListener) {
        _logger.debug((Object)("removing surface listener: " + tdkVisualSurfaceListener));
        this._surfaceListeners.remove(tdkVisualSurfaceListener);
    }

    public void zoom(double d) {
        if (!this.isInitialized()) {
            _logger.warn((Object)"called without being initialized");
            return;
        }
        double d2 = (this._window.getMaxX() + this._window.getMinX()) / 2.0;
        double d3 = (this._window.getMaxY() + this._window.getMinY()) / 2.0;
        this.zoom(d2, d3, d);
    }

    public void zoom(double d, double d2, double d3) {
        if (!this.isInitialized()) {
            _logger.warn((Object)"called without being initialized");
            return;
        }
        _logger.debug((Object)("zoom factor operation: {xc=" + d + ",yc=" + d2 + ",factor=" + d3 + "}"));
        if (d3 == 0.0) {
            throw new IllegalArgumentException("Invalid zoom factor.");
        }
        double d4 = this._window.getWidth() / (2.0 * d3);
        double d5 = this._window.getHeight() / (2.0 * d3);
        double d6 = d - d4;
        double d7 = d + d4;
        double d8 = d2 - d5;
        double d9 = d2 + d5;
        this.setWindow(d6, d8, d7, d9);
    }

    public void zoomIn(double d) {
        if (!this.isInitialized()) {
            _logger.warn((Object)"called without being initialized");
            return;
        }
        this.zoom(d);
    }

    public void zoomOut(double d) {
        if (!this.isInitialized()) {
            _logger.warn((Object)"called without being initialized");
            return;
        }
        if (d == 0.0) {
            throw new IllegalArgumentException("Invalid zoom factor.");
        }
        this.zoom(1.0 / d);
    }

    public void zoomArea(Envelope envelope) {
        if (!this.isInitialized()) {
            _logger.warn((Object)"called without being initialized");
            return;
        }
        if (envelope == null) {
            throw new IllegalArgumentException("Invalid zoom box (=null).");
        }
        this.zoomArea(envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY());
    }

    public void zoomArea(double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        double d7;
        if (!this.isInitialized()) {
            _logger.warn((Object)"called without being initialized");
            return;
        }
        _logger.debug((Object)("zoom area operation: {x1=" + d + ",y1=" + d2 + ",x2=" + d3 + ",y2=" + d4 + "}"));
        if (d == d3 || d2 == d4) {
            throw new IllegalArgumentException("invalid zoom box.");
        }
        if (d3 < d) {
            d7 = d3;
            d3 = d;
            d = d7;
        }
        if (d4 < d2) {
            d7 = d4;
            d4 = d2;
            d2 = d7;
        }
        d7 = d3 - d;
        double d8 = d4 - d2;
        double d9 = 0.001;
        if (d7 == 0.0) {
            d7 = (d3 += d9) - (d -= d9);
        }
        if (d8 == 0.0) {
            d8 = (d4 += d9) - (d2 -= d9);
        }
        if (d7 / d8 <= (d6 = this._window.getWidth()) / (d5 = this._window.getHeight())) {
            double d10 = d8 * (d6 / d5);
            double d11 = (d + d3) / 2.0;
            double d12 = d11 - d10 / 2.0;
            double d13 = d11 + d10 / 2.0;
            double d14 = d2;
            double d15 = d4;
            this.setWindow(d12, d14, d13, d15);
        } else {
            double d16 = d7 * (d5 / d6);
            double d17 = (d2 + d4) / 2.0;
            double d18 = d;
            double d19 = d3;
            double d20 = d17 - d16 / 2.0;
            double d21 = d17 + d16 / 2.0;
            this.setWindow(d18, d20, d19, d21);
        }
    }

    public void pan(double d, double d2) {
        if (!this.isInitialized()) {
            _logger.warn((Object)"called without being initialized");
            return;
        }
        _logger.debug((Object)("pan operation: {dx=" + d + ",dy=" + d2 + "}"));
        this.setWindow(this._window.getMinX() - d, this._window.getMinY() - d2, this._window.getMaxX() - d, this._window.getMaxY() - d2);
    }

    public boolean canUndo() {
        return this._currentPos > 0;
    }

    public void undo() {
        _logger.debug((Object)"undo operation");
        if (this.canUndo()) {
            --this._currentPos;
            Envelope envelope = this._undoManager.get(this._currentPos);
            this._clearForwardUndoHistory = false;
            this.zoomArea(envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY());
        }
    }

    public boolean canRedo() {
        return this._currentPos < this._undoManager.size() - 1;
    }

    public void redo() {
        _logger.debug((Object)"redo operation");
        if (this.canRedo()) {
            ++this._currentPos;
            Envelope envelope = this._undoManager.get(this._currentPos);
            this._clearForwardUndoHistory = false;
            this.zoomArea(envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY());
        }
    }

    public void window2viewport(Coordinate coordinate, Coordinate coordinate2) {
        if (!this.isInitialized()) {
            _logger.warn((Object)"called without being initialized");
            return;
        }
        TdkVisualSurfaceUtils.window2viewportUtil(coordinate, coordinate2, this._window, this._viewPort, true);
    }

    public void viewport2window(Coordinate coordinate, Coordinate coordinate2) {
        if (!this.isInitialized()) {
            _logger.warn((Object)"called without being initialized");
            return;
        }
        TdkVisualSurfaceUtils.viewport2windowUtil(coordinate, coordinate2, this._viewPort, this._window, true);
    }

    protected void fireWindowChangedEvent(boolean bl, Envelope envelope) {
        for (int i = 0; i < this._surfaceListeners.size(); ++i) {
            this._surfaceListeners.get(i).windowChanged(bl, this, new Envelope(envelope));
        }
    }

    protected void fireViewportChangedEvent() {
        for (int i = 0; i < this._surfaceListeners.size(); ++i) {
            this._surfaceListeners.get(i).viewportResized(this, new Envelope(this._viewPort));
        }
    }

    protected void fireWindowHistoryClearedEvent() {
        for (int i = 0; i < this._surfaceListeners.size(); ++i) {
            this._surfaceListeners.get(i).windowHistoryCleared();
        }
    }

    protected void resize(double d, double d2, double d3, double d4) {
        double d5;
        _logger.debug((Object)("resize operation: {x1=" + d + ",y1=" + d2 + ",x2=" + d3 + ",y2=" + d4 + "}"));
        this.fireWindowChangedEvent(true, new Envelope(d, d3, d2, d4));
        this.fireViewportChangedEvent();
        if (d3 < d) {
            d5 = d3;
            d3 = d;
            d = d5;
        }
        if (d4 < d2) {
            d5 = d4;
            d4 = d2;
            d2 = d5;
        }
        d5 = this._window.getWidth();
        double d6 = this._window.getHeight();
        double d7 = this._viewPort.getWidth();
        double d8 = this._viewPort.getHeight();
        double d9 = 1.0;
        if (d7 != 0.0) {
            d9 = d5 / d7;
        } else if (d8 != 0.0) {
            d9 = d6 / d8;
        }
        double d10 = this._window.getMinX();
        double d11 = d10 + (d3 - d) * d9;
        double d12 = this._window.getMaxY();
        double d13 = d12 - (d4 - d2) * d9;
        this._viewPort.init(d, d3, d2, d4);
        this._window.init(d10, d11, d13, d12);
        this.nativeResize(this.getNativeCanvasCPtr(), d, d3, d2, d4);
        this.nativeSetViewPort(this.getNativeCanvasCPtr(), d, d3, d2, d4);
        this.nativeSetWindow(this.getNativeCanvasCPtr(), d10, d11, d13, d12);
        this.updateWindowTransform();
        this._initialized = true;
        this.needRedraw(true);
        this.fireWindowChangedEvent(false, this._window);
        this.fireViewportChangedEvent();
    }

    public void setWindow(Envelope envelope) {
        if (!this.isInitialized()) {
            _logger.warn((Object)"called without being initialized");
            return;
        }
        this.setWindow(envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY());
    }

    private boolean isWindowWithinLimits(Envelope envelope) {
        if (envelope == null) {
            return false;
        }
        if (this._limitWindow == null) {
            return true;
        }
        return this._limitWindow.contains(envelope);
    }

    public void setWindow(double d, double d2, double d3, double d4) {
        if (!this.isInitialized()) {
            _logger.warn((Object)"called without being initialized");
            return;
        }
        Envelope envelope = new Envelope(d, d3, d2, d4);
        if (!this.isWindowWithinLimits(envelope)) {
            _logger.warn((Object)"window outside the limits");
            return;
        }
        this.fireWindowChangedEvent(true, envelope);
        this._window.init(envelope);
        this.nativeSetWindow(this.getNativeCanvasCPtr(), d, d3, d2, d4);
        if (this._clearForwardUndoHistory) {
            if (this._currentPos < this._undoManager.size() - 1) {
                int n = this._currentPos + 1;
                while (n < this._undoManager.size()) {
                    this._undoManager.remove(n);
                }
            }
            this._undoManager.add(new Envelope(this._window));
            ++this._currentPos;
        }
        this._clearForwardUndoHistory = true;
        this.updateWindowTransform();
        this.needRedraw(true);
        this.fireWindowChangedEvent(false, this._window);
    }

    protected void updateWindowTransform() {
        double d = (this._viewPort.getMaxX() - this._viewPort.getMinX()) / (this._window.getMaxX() - this._window.getMinX());
        double d2 = (this._viewPort.getMinX() * this._window.getMaxX() - this._viewPort.getMaxX() * this._window.getMinX()) / (this._window.getMaxX() - this._window.getMinX());
        double d3 = -(this._viewPort.getMaxY() - this._viewPort.getMinY()) / (this._window.getMaxY() - this._window.getMinY());
        double d4 = (this._viewPort.getMaxY() * this._window.getMaxY() - this._viewPort.getMinY() * this._window.getMinY()) / (this._window.getMaxY() - this._window.getMinY());
        this._windowTransform = new AffineTransform(d, 0.0, 0.0, d3, d2, d4);
    }

    protected abstract void draw(Graphics2D var1);

    protected abstract void refresh(Graphics2D var1);

    public void paint(Graphics graphics) {
        if (!this.isInitialized()) {
            _logger.warn((Object)"called without being initialized");
            return;
        }
        graphics.setClip(0, 0, this.getWidth(), this.getHeight());
        if (this._needRedraw) {
            this.needRedraw(false);
            this.draw((Graphics2D)graphics);
        } else {
            this.refresh((Graphics2D)graphics);
        }
    }

    public void redraw() {
        this.needRedraw(true);
        this.repaint();
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = componentEvent.getComponent().getWidth();
        double d4 = componentEvent.getComponent().getHeight();
        this.resize(d, d2, d3, d4);
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        this.repaint();
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    public double getPixelSize() {
        double d = this._viewPort.getWidth() / this._window.getWidth();
        return d;
    }

    public void setStrokeForWindow(Graphics2D graphics2D, Stroke stroke) {
        if (stroke instanceof BasicStroke) {
            BasicStroke basicStroke = (BasicStroke)stroke;
            float f = basicStroke.getLineWidth() / (float)this.getPixelSize();
            if (f < 0.0f) {
                _logger.warn((Object)("invalid stroke width: " + f));
                graphics2D.setStroke(stroke);
                return;
            }
            BasicStroke basicStroke2 = new BasicStroke(f, basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), basicStroke.getDashArray(), basicStroke.getDashPhase());
            graphics2D.setStroke(basicStroke2);
        } else {
            _logger.warn((Object)"unable to set stroke for window");
        }
    }

    public void setStrokeForViewport(Graphics2D graphics2D, Stroke stroke) {
        graphics2D.setStroke(stroke);
    }

    public void setFontForWindow(Graphics2D graphics2D, Font font) {
        Font font2 = font.deriveFont(font.getSize2D() / (float)this.getPixelSize());
        graphics2D.setFont(font2);
    }

    public void setFontForViewport(Graphics2D graphics2D, Font font) {
        graphics2D.setFont(font);
    }
}

