/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.map.elements;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.desktop.components.map.TdkMapDisplay;
import org.tecgraf.jtdk.desktop.components.map.TdkMapElement;
import org.tecgraf.jtdk.desktop.components.map.TdkVisualSurfaceListener;

public class TdkBalloonMapElement
extends TdkMapElement
implements TdkVisualSurfaceListener {
    private static Logger _logger = Logger.getLogger(TdkBalloonMapElement.class);
    private final Icon _defaultIcon = new ImageIcon(TdkBalloonMapElement.class.getResource("/org/tecgraf/jtdk/desktop/components/icons/closebutton_default.png"));
    private final Icon _rolloverIcon = new ImageIcon(TdkBalloonMapElement.class.getResource("/org/tecgraf/jtdk/desktop/components/icons/closebutton_rollover.png"));
    private final Icon _pressedIcon = new ImageIcon(TdkBalloonMapElement.class.getResource("/org/tecgraf/jtdk/desktop/components/icons/closebutton_pressed.png"));
    private TdkMapDisplay _display;
    private Panel _contentPane;
    private int _arcWidth;
    private int _arcHeight;
    private Color _fillColor;
    private Color _borderColor;
    private boolean _useCloseButton;
    private DrawMode _drawMode;
    private int _xLocation;
    private int _yLocation;
    private Alignment _tipAlignment;
    private int _balloonWidth;
    private int _balloonHeight;
    private int _xBalloonLocation;
    private int _yBalloonLocation;
    private int _paneX = 0;
    private int _paneY = 0;
    private boolean _isShowing;
    private boolean _requestedShow;
    private boolean _requestedHide;

    public TdkBalloonMapElement(TdkMapDisplay tdkMapDisplay) {
        this(tdkMapDisplay, 10, 10, Color.WHITE, new Color(225, 225, 255), DrawMode.GOOGLE_EARTH, true);
    }

    public TdkBalloonMapElement(TdkMapDisplay tdkMapDisplay, int n, int n2, Color color, Color color2, DrawMode drawMode, boolean bl) {
        this._display = tdkMapDisplay;
        this._arcWidth = n;
        this._arcHeight = n2;
        this._fillColor = color;
        this._borderColor = color2;
        this._drawMode = drawMode;
        this._useCloseButton = bl;
        this._isShowing = false;
        this._requestedShow = false;
        this._requestedHide = false;
        this._xLocation = 0;
        this._yLocation = 0;
        this._tipAlignment = Alignment.SOUTH;
        this._xBalloonLocation = 0;
        this._yBalloonLocation = 0;
        this._balloonWidth = this._arcWidth * 2;
        this._balloonHeight = this._arcHeight * 2;
        this.setContent();
        _logger.debug((Object)"created");
        if (this._display != null) {
            _logger.debug((Object)("associated with display: " + this._display));
            this._display.addVisualSurfaceListener(this);
        }
    }

    public void requestShow(int n, int n2) {
        _logger.debug((Object)("request for show: x=" + n + ", y=" + n2));
        this._xLocation = n;
        this._yLocation = n2;
        this._requestedShow = true;
        this.setNeedDrawUpdate(true);
        if (this._display != null) {
            this._display.repaint();
        }
    }

    public void requestHide() {
        if (this._isShowing) {
            _logger.debug((Object)"request for hide: hiding balloon...");
            this._isShowing = false;
            this._requestedHide = true;
            this._contentPane.setVisible(false);
            this.setNeedDrawUpdate(true);
            if (this._display != null) {
                this._display.repaint();
            }
        } else {
            _logger.debug((Object)"request for hide: balloon is not visible, doing nothing...");
        }
    }

    public void setContent() {
        Component component;
        this._contentPane = new Panel();
        this._contentPane.setLayout(new GridBagLayout());
        if (this._useCloseButton) {
            component = new JButton();
            ((JComponent)component).setBorder(null);
            ((AbstractButton)component).setContentAreaFilled(false);
            ((AbstractButton)component).setIcon(this._defaultIcon);
            ((AbstractButton)component).setRolloverIcon(this._rolloverIcon);
            ((AbstractButton)component).setPressedIcon(this._pressedIcon);
            component.setFocusable(false);
            ((AbstractButton)component).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TdkBalloonMapElement.this.requestHide();
                }
            });
            this._contentPane.add(component, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 4, 0), 0, 0));
        }
        this._contentPane.setBackground(this._fillColor);
        component = this.getMainComponent();
        if (component != null) {
            this._contentPane.add(component, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        _logger.debug((Object)("content set: width=" + this._contentPane.getPreferredSize().getWidth() + ", height=" + this._contentPane.getPreferredSize().getHeight()));
    }

    protected Component getMainComponent() {
        JEditorPane jEditorPane;
        try {
            jEditorPane = new JEditorPane(new URL("http://www.tecgraf.puc-rio.br/~metello/balloon/"));
        }
        catch (Exception exception) {
            return null;
        }
        jEditorPane.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(jEditorPane);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setPreferredSize(new Dimension(400, 400));
        jScrollPane.setMinimumSize(new Dimension(100, 100));
        jScrollPane.setBorder(null);
        return jScrollPane;
    }

    @Override
    public void drawHook(Graphics2D graphics2D, TdkMapDisplay tdkMapDisplay) {
        _logger.debug((Object)"Drawing balloon");
        if (this._contentPane == null) {
            _logger.warn((Object)"_contentPane = null, nothing to display...");
            return;
        }
        if (this._requestedShow) {
            this._requestedShow = false;
            this._requestedHide = false;
            this._isShowing = true;
            if (!this.determineBalloonPositionAndAlignment()) {
                _logger.warn((Object)"could not determine balloon location");
            }
            if (!this.determineContentPaneLocation(tdkMapDisplay)) {
                _logger.warn((Object)"could not determine content pane location");
            }
            this._contentPane.setVisible(true);
        } else if (this._requestedHide) {
            this._requestedShow = false;
            this._requestedHide = false;
            this._isShowing = false;
            _logger.debug((Object)"draw: hiding _contentPane");
            this._contentPane.setVisible(false);
        }
        if (this._isShowing) {
            Color color = graphics2D.getColor();
            Font font = graphics2D.getFont();
            this.drawBorder(graphics2D, tdkMapDisplay);
            Point point = SwingUtilities.convertPoint(this._contentPane, tdkMapDisplay.getLocation(), (Component)((Object)tdkMapDisplay));
            int n = point.x - tdkMapDisplay.getLocation().x;
            int n2 = point.y - 1;
            graphics2D.translate(n, n2);
            this._contentPane.paint(graphics2D);
            graphics2D.translate(-n, -n2);
            graphics2D.setColor(color);
            graphics2D.setFont(font);
        }
    }

    private int getProportionalSize(float f) {
        float f2 = (float)(this._balloonWidth - this._arcWidth * 2) * f;
        float f3 = (float)(this._balloonHeight - this._arcHeight * 2) * f;
        return (int)Math.min(f2, f3);
    }

    private int getProportionalSize(float f, int n, int n2) {
        float f2 = (float)(n - this._arcWidth * 2) * f;
        float f3 = (float)(n2 - this._arcHeight * 2) * f;
        return (int)Math.min(f2, f3);
    }

    private boolean determineBalloonPositionAndAlignment() {
        this._tipAlignment = Alignment.SOUTH;
        this._xBalloonLocation = 0;
        this._yBalloonLocation = 0;
        this._balloonWidth = this._arcWidth * 2;
        this._balloonHeight = this._arcHeight * 2;
        if (this._contentPane == null || this._display == null) {
            return false;
        }
        this._balloonWidth = this._contentPane.getPreferredSize().width + 2 * this._arcWidth;
        this._balloonHeight = this._contentPane.getPreferredSize().height + 2 * this._arcHeight;
        if (this._balloonWidth > this._display.getWidth() || this._balloonHeight > this._display.getHeight()) {
            return false;
        }
        int n = this._yLocation;
        int n2 = this._display.getHeight() - 1 - this._yLocation;
        int n3 = this._xLocation;
        int n4 = this._display.getWidth() - 1 - this._xLocation;
        int n5 = this.getProportionalSize(0.25f);
        int n6 = this.getProportionalSize(0.05f);
        if (n > this._balloonHeight + n5) {
            this._tipAlignment = Alignment.SOUTH;
            this._xBalloonLocation = this.getBalloonPosition(this._xLocation, n3, n4, this._balloonWidth);
            this._yBalloonLocation = this._yLocation - n5 - this._balloonHeight;
        } else if (n2 > this._balloonHeight + n5) {
            this._tipAlignment = Alignment.NORTH;
            this._xBalloonLocation = this.getBalloonPosition(this._xLocation, n3, n4, this._balloonWidth);
            this._yBalloonLocation = this._yLocation + n5;
        } else if (n4 > this._balloonWidth + n5) {
            this._tipAlignment = Alignment.WEST;
            this._xBalloonLocation = this._xLocation + n5;
            this._yBalloonLocation = this.getBalloonPosition(this._yLocation, n, n2, this._balloonHeight);
        } else if (n3 > this._balloonWidth + n5) {
            this._tipAlignment = Alignment.EAST;
            this._xBalloonLocation = this._xLocation - n5 - this._balloonWidth;
            this._yBalloonLocation = this.getBalloonPosition(this._yLocation, n, n2, this._balloonHeight);
        } else if (n > this._balloonHeight) {
            this._tipAlignment = Alignment.SOUTH;
            this._xBalloonLocation = this.getBalloonPosition(this._xLocation, n3, n4, this._balloonWidth);
            this._yBalloonLocation = this._yLocation - n;
        } else if (n2 > this._balloonHeight) {
            this._tipAlignment = Alignment.NORTH;
            this._xBalloonLocation = this.getBalloonPosition(this._xLocation, n3, n4, this._balloonWidth);
            this._yBalloonLocation = this._yLocation + n2 - this._balloonHeight;
        } else if (n4 > this._balloonWidth) {
            this._tipAlignment = Alignment.WEST;
            this._xBalloonLocation = this._xLocation + n4 - this._balloonWidth;
            this._yBalloonLocation = this.getBalloonPosition(this._yLocation, n, n2, this._balloonHeight);
        } else if (n3 > this._balloonWidth) {
            this._tipAlignment = Alignment.EAST;
            this._xBalloonLocation = this._xLocation - n3;
            this._yBalloonLocation = this.getBalloonPosition(this._yLocation, n, n2, this._balloonHeight);
        } else {
            this._tipAlignment = Alignment.CENTER;
            this._xBalloonLocation = 0;
            this._yBalloonLocation = 0;
            if (n3 > n4) {
                this._xBalloonLocation = this._display.getWidth() - 1 - this._balloonWidth;
            }
            if (n > n2) {
                this._yBalloonLocation = this._display.getHeight() - 1 - this._balloonHeight;
            }
        }
        return true;
    }

    private int getBalloonPosition(int n, int n2, int n3, int n4) {
        if (n2 < n4 / 2) {
            return n - n2;
        }
        if (n3 < n4 / 2) {
            return n + n3 - n4;
        }
        return n - n4 / 2;
    }

    private boolean determineContentPaneLocation(TdkMapDisplay tdkMapDisplay) {
        JLayeredPane jLayeredPane;
        if (this._contentPane == null) {
            _logger.warn((Object)"_contentPane = null, nothing to display...");
            return false;
        }
        Container container = tdkMapDisplay.getParent();
        while (true) {
            if (container instanceof JFrame) {
                jLayeredPane = ((JFrame)container).getLayeredPane();
                break;
            }
            if (container instanceof JDialog) {
                jLayeredPane = ((JDialog)container).getLayeredPane();
                break;
            }
            if (container instanceof JInternalFrame) {
                jLayeredPane = ((JInternalFrame)container).getLayeredPane();
                break;
            }
            container = container.getParent();
        }
        jLayeredPane.remove(this._contentPane);
        jLayeredPane.add((Component)this._contentPane, JLayeredPane.POPUP_LAYER);
        Point point = SwingUtilities.convertPoint((Component)((Object)tdkMapDisplay), this._contentPane.getLocation(), this._contentPane);
        this._paneX = point.x + this._xBalloonLocation + this._arcWidth;
        this._paneY = point.y + this._yBalloonLocation + this._arcHeight;
        _logger.debug((Object)("determined _contentPane location: x=" + this._paneX + ", y=" + this._paneY + ", width=" + this._contentPane.getPreferredSize().width + ", height=" + this._contentPane.getPreferredSize().height));
        this._contentPane.setBounds(this._paneX, this._paneY, this._contentPane.getPreferredSize().width, this._contentPane.getPreferredSize().height);
        this._contentPane.validate();
        return true;
    }

    private void drawBorder(Graphics2D graphics2D, TdkMapDisplay tdkMapDisplay) {
        _logger.debug((Object)("drawing balloon border: x=" + this._xBalloonLocation + ", y=" + this._yBalloonLocation + ", width=" + this._balloonWidth + ", height=" + this._balloonHeight));
        int n = this._xLocation;
        int n2 = this._yLocation;
        int n3 = this._xBalloonLocation;
        int n4 = this._yBalloonLocation;
        int n5 = this._balloonWidth;
        int n6 = this._balloonHeight;
        int n7 = this.getProportionalSize(0.03f, n5, n6);
        n7 = Math.max(n7, 3);
        int[] nArray = new int[]{n, n, n};
        int[] nArray2 = new int[]{n2, n2, n2};
        switch (this._tipAlignment) {
            case SOUTH: {
                nArray[0] = n3 + n5 / 2 - n7;
                nArray[1] = n3 + n5 / 2 + n7;
                nArray2[0] = n4 + n6;
                nArray2[1] = n4 + n6;
                break;
            }
            case NORTH: {
                nArray[0] = n3 + n5 / 2 - n7;
                nArray[1] = n3 + n5 / 2 + n7;
                nArray2[0] = n4;
                nArray2[1] = n4;
                break;
            }
            case WEST: {
                nArray[0] = n3;
                nArray[1] = n3;
                nArray2[0] = n4 + n6 / 2 - n7;
                nArray2[1] = n4 + n6 / 2 + n7;
                break;
            }
            case EAST: {
                nArray[0] = n3 + n5;
                nArray[1] = n3 + n5;
                nArray2[0] = n4 + n6 / 2 - n7;
                nArray2[1] = n4 + n6 / 2 + n7;
            }
        }
        int n8 = 3;
        graphics2D.setColor(Color.BLACK);
        graphics2D.fillRoundRect(n3 + n8, n4 + n8, n5, n6, this._arcWidth * 2, this._arcHeight * 2);
        int[] nArray3 = new int[]{n, n, n};
        int[] nArray4 = new int[]{n2, n2, n2};
        nArray3[0] = nArray[0] + n8;
        nArray3[1] = nArray[1] + n8;
        nArray4[0] = nArray2[0] + n8;
        nArray4[1] = nArray2[1] + n8;
        graphics2D.fillPolygon(nArray3, nArray4, 3);
        graphics2D.setColor(this._fillColor);
        graphics2D.fillRoundRect(n3, n4, n5, n6, this._arcWidth * 2, this._arcHeight * 2);
        graphics2D.setColor(this._borderColor);
        graphics2D.drawRoundRect(n3, n4, n5, n6, this._arcWidth * 2, this._arcHeight * 2);
        if (this._tipAlignment == Alignment.CENTER) {
            return;
        }
        graphics2D.setColor(this._fillColor);
        graphics2D.fillPolygon(nArray, nArray2, 3);
        graphics2D.setColor(this._borderColor);
        graphics2D.drawLine(nArray[0], nArray2[0], nArray[2], nArray2[2]);
        graphics2D.drawLine(nArray[1], nArray2[1], nArray[2], nArray2[2]);
        graphics2D.setColor(this._fillColor);
        graphics2D.drawLine(nArray[0], nArray2[0], nArray[1], nArray2[1]);
        graphics2D.setColor(this._borderColor);
        graphics2D.drawLine(nArray[0], nArray2[0], nArray[0], nArray2[0]);
        graphics2D.drawLine(nArray[1], nArray2[1], nArray[1], nArray2[1]);
    }

    private boolean isInsideBalloon(int n, int n2) {
        if (this._contentPane == null || !this._isShowing) {
            return false;
        }
        return n >= this._xBalloonLocation && n <= this._xBalloonLocation + this._balloonWidth && n2 >= this._yBalloonLocation && n2 <= this._yBalloonLocation + this._balloonHeight;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this._isShowing) {
            if (this.isInsideBalloon(mouseEvent.getX(), mouseEvent.getY())) {
                mouseEvent.consume();
            } else {
                this.requestHide();
            }
        } else {
            this.requestShow(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
    }

    @Override
    public void viewportResized(Object object, Envelope envelope) {
        this.setNeedDrawUpdate(true);
        if (this._isShowing) {
            this.requestHide();
        }
    }

    @Override
    public void windowChanged(boolean bl, Object object, Envelope envelope) {
        this.setNeedDrawUpdate(true);
        if (this._isShowing && bl) {
            this.requestHide();
        }
    }

    @Override
    public void windowHistoryCleared() {
    }

    public static enum DrawMode {
        TOOLTIP,
        GOOGLE_EARTH;

    }

    protected static enum Alignment {
        SOUTH,
        NORTH,
        WEST,
        EAST,
        CENTER;

    }
}

