/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.map.elements;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.UIManager;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.core.model.TeText;
import org.tecgraf.jtdk.core.model.TeTextSet;
import org.tecgraf.jtdk.desktop.components.map.TdkMapDisplay;
import org.tecgraf.jtdk.desktop.components.map.TdkMapElement;
import org.tecgraf.jtdk.desktop.components.map.TdkVisualSurfaceListener;
import org.tecgraf.jtdk.desktop.components.map.elements.TdkIdentificationBalloon;

public abstract class TdkIdentificationMapElement
extends TdkMapElement
implements TdkVisualSurfaceListener {
    private static Logger _logger = Logger.getLogger(TdkIdentificationMapElement.class);
    protected TdkMapDisplay _display;
    private Vector<TdkIdentificationBalloon> _identificationBalloons;
    protected boolean _updateBalloons;
    private int _arcWidth;
    private int _arcHeight;
    private Color _fillColor;
    private Color _borderColor;
    private Color _textColor;
    private Font _font;
    private boolean _isShowing;
    private boolean _requestedShow;
    private boolean _requestedHide;

    public TdkIdentificationMapElement(TdkMapDisplay tdkMapDisplay) {
        this(tdkMapDisplay, 6, 6, (Color)UIManager.get("ToolTip.background"), Color.BLACK, (Color)UIManager.get("ToolTip.foreground"), (Font)UIManager.get("ToolTip.font"));
    }

    public TdkIdentificationMapElement(TdkMapDisplay tdkMapDisplay, int n, int n2, Color color, Color color2, Color color3, Font font) {
        this._display = tdkMapDisplay;
        this._arcWidth = n;
        this._arcHeight = n2;
        this._fillColor = color;
        this._borderColor = color2;
        this._textColor = color3;
        this._isShowing = false;
        this._requestedShow = false;
        this._requestedHide = false;
        this._updateBalloons = true;
        this._identificationBalloons = new Vector();
        _logger.debug((Object)"created");
        if (this._display != null) {
            _logger.debug((Object)("associated with display: " + this._display));
            this._display.addVisualSurfaceListener(this);
        }
        this._font = font;
    }

    public void requestShow() {
        _logger.debug((Object)"request for show.");
        this._requestedShow = true;
        this._requestedHide = false;
        this.setNeedDrawUpdate(true);
        if (this._display != null) {
            this._display.repaint();
        }
    }

    public void requestHide() {
        if (this._isShowing) {
            _logger.debug((Object)"request for hide: hiding balloon...");
            this._requestedShow = false;
            this._requestedHide = true;
            this.setNeedDrawUpdate(true);
            if (this._display != null) {
                this._display.repaint();
            }
        } else {
            _logger.debug((Object)"request for hide: balloon is not visible, doing nothing...");
        }
    }

    @Override
    public void drawHook(Graphics2D graphics2D, TdkMapDisplay tdkMapDisplay) {
        this._updateBalloons = true;
        this.paintBallons(graphics2D, tdkMapDisplay);
    }

    public void paintBallons(Graphics2D graphics2D, TdkMapDisplay tdkMapDisplay) {
        if (this._requestedShow) {
            this._requestedShow = false;
            this._requestedHide = false;
            this._isShowing = true;
        } else if (this._requestedHide) {
            this._requestedShow = false;
            this._requestedHide = false;
            this._isShowing = false;
            _logger.debug((Object)"draw: setting _isShowing to false");
        }
        if (this._isShowing) {
            if (this._updateBalloons) {
                TeTextSet teTextSet = this.getIdentifications(tdkMapDisplay);
                this.updateIdentificationBalloons(teTextSet, graphics2D, tdkMapDisplay);
                _logger.debug((Object)"identification balloons updated");
                this._updateBalloons = false;
            }
            for (TdkIdentificationBalloon tdkIdentificationBalloon : this._identificationBalloons) {
                Color color = graphics2D.getColor();
                Font font = graphics2D.getFont();
                this.drawBorder(tdkIdentificationBalloon, graphics2D, tdkMapDisplay);
                this.drawIdentification(tdkIdentificationBalloon, graphics2D, tdkMapDisplay);
                graphics2D.setColor(color);
                graphics2D.setFont(font);
            }
        }
    }

    protected abstract TeTextSet getIdentifications(TdkMapDisplay var1);

    public void clearIdentifications() {
        this._identificationBalloons.clear();
    }

    private void updateIdentificationBalloons(TeTextSet teTextSet, Graphics2D graphics2D, TdkMapDisplay tdkMapDisplay) {
        _logger.debug((Object)"recalculate identification balloons");
        this._identificationBalloons.clear();
        for (int i = 0; i < teTextSet.size(); ++i) {
            TeText teText = teTextSet.get(i);
            TdkIdentificationBalloon tdkIdentificationBalloon = this.setupIdentificationBalloon(teText, graphics2D, tdkMapDisplay);
            if (tdkIdentificationBalloon != null) {
                this._identificationBalloons.add(tdkIdentificationBalloon);
                continue;
            }
            _logger.warn((Object)"could not determine balloon location");
        }
    }

    private int getProportionalSize(float f, int n, int n2) {
        float f2 = (float)(n - this._arcWidth * 2) * f;
        float f3 = (float)(n2 - this._arcHeight * 2) * f;
        return (int)Math.min(f2, f3);
    }

    private TdkIdentificationBalloon setupIdentificationBalloon(TeText teText, Graphics2D graphics2D, TdkMapDisplay tdkMapDisplay) {
        if (tdkMapDisplay == null || teText == null || teText.getText() == null || teText.getText().trim().equals("")) {
            return null;
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(teText.getText(), graphics2D);
        double d = Math.sqrt(rectangle2D.getWidth() / rectangle2D.getHeight());
        double d2 = rectangle2D.getWidth() / d;
        List<String> list = this.splitText(teText.getText(), d2, graphics2D);
        double d3 = 0.0;
        double d4 = 0.0;
        for (String string : list) {
            d4 = fontMetrics.getStringBounds(string, graphics2D).getWidth();
            d3 = Math.max(d4, d3);
        }
        int n = (int)Math.ceil(d3);
        int n2 = list.size() * fontMetrics.getMaxAscent();
        Coordinate coordinate = new Coordinate(teText.getX(), teText.getY());
        Coordinate coordinate2 = new Coordinate();
        tdkMapDisplay.window2viewport(coordinate, coordinate2);
        int n3 = (int)coordinate2.x;
        int n4 = (int)coordinate2.y;
        if (!tdkMapDisplay.contains(n3, n4)) {
            return null;
        }
        int n5 = n + 2 * this._arcWidth;
        int n6 = n2 + 2 * this._arcHeight;
        if (n5 > tdkMapDisplay.getWidth() || n6 > tdkMapDisplay.getHeight()) {
            return null;
        }
        int n7 = this.getProportionalSize(0.25f, n5, n6);
        n7 = Math.max(n7, 12);
        int n8 = n4;
        int n9 = tdkMapDisplay.getHeight() - 1 - n4;
        int n10 = n3;
        int n11 = tdkMapDisplay.getWidth() - 1 - n3;
        Alignment alignment = Alignment.SOUTH;
        int n12 = 0;
        int n13 = 0;
        if (n8 > n6 + n7) {
            alignment = Alignment.SOUTH;
            n12 = this.getBalloonPosition(n3, n10, n11, n5);
            n13 = n4 - n7 - n6;
        } else if (n9 > n6 + n7) {
            alignment = Alignment.NORTH;
            n12 = this.getBalloonPosition(n3, n10, n11, n5);
            n13 = n4 + n7;
        } else if (n11 > n5 + n7) {
            alignment = Alignment.WEST;
            n12 = n3 + n7;
            n13 = this.getBalloonPosition(n4, n8, n9, n6);
        } else if (n10 > n5 + n7) {
            alignment = Alignment.EAST;
            n12 = n3 - n7 - n5;
            n13 = this.getBalloonPosition(n4, n8, n9, n6);
        } else if (n8 > n6) {
            alignment = Alignment.SOUTH;
            n12 = this.getBalloonPosition(n3, n10, n11, n5);
            n13 = n4 - n8;
        } else if (n9 > n6) {
            alignment = Alignment.NORTH;
            n12 = this.getBalloonPosition(n3, n10, n11, n5);
            n13 = n4 + n9 - n6;
        } else if (n11 > n5) {
            alignment = Alignment.WEST;
            n12 = n3 + n11 - n5;
            n13 = this.getBalloonPosition(n4, n8, n9, n6);
        } else if (n10 > n5) {
            alignment = Alignment.EAST;
            n12 = n3 - n10;
            n13 = this.getBalloonPosition(n4, n8, n9, n6);
        } else {
            alignment = Alignment.CENTER;
            n12 = 0;
            n13 = 0;
            if (n10 > n11) {
                n12 = tdkMapDisplay.getWidth() - 1 - n5;
            }
            if (n8 > n9) {
                n13 = tdkMapDisplay.getHeight() - 1 - n6;
            }
        }
        TdkIdentificationBalloon tdkIdentificationBalloon = new TdkIdentificationBalloon(list, n3, n4, alignment, n12, n13, n5, n6);
        return tdkIdentificationBalloon;
    }

    private List<String> splitText(String string, double d, Graphics2D graphics2D) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = string.trim().split("\\s");
        String string2 = "";
        String string3 = null;
        double d2 = 0.0;
        for (String string4 : stringArray) {
            string3 = (string2 + " " + string4).trim();
            d2 = fontMetrics.getStringBounds(string3, graphics2D).getWidth();
            if (d2 > d && !string2.equals("")) {
                arrayList.add(string2);
                string2 = string4;
                continue;
            }
            string2 = string3;
        }
        if (!string2.equals("")) {
            arrayList.add(string2);
        }
        return arrayList;
    }

    private int getBalloonPosition(int n, int n2, int n3, int n4) {
        if (n2 < n4 / 2) {
            return n - n2;
        }
        if (n3 < n4 / 2) {
            return n + n3 - n4;
        }
        return n - n4 / 2;
    }

    private void drawBorder(TdkIdentificationBalloon tdkIdentificationBalloon, Graphics2D graphics2D, TdkMapDisplay tdkMapDisplay) {
        int n = tdkIdentificationBalloon.getXTipLocation();
        int n2 = tdkIdentificationBalloon.getYTipLocation();
        int n3 = tdkIdentificationBalloon.getXBalloonLocation();
        int n4 = tdkIdentificationBalloon.getYBalloonLocation();
        int n5 = tdkIdentificationBalloon.getWidth();
        int n6 = tdkIdentificationBalloon.getHeight();
        int n7 = this.getProportionalSize(0.03f, tdkIdentificationBalloon.getWidth(), tdkIdentificationBalloon.getHeight());
        n7 = Math.max(n7, 3);
        int[] nArray = new int[]{n, n, n};
        int[] nArray2 = new int[]{n2, n2, n2};
        switch (tdkIdentificationBalloon.getTipAlignment()) {
            case SOUTH: {
                nArray[0] = n3 + n5 / 2 - n7;
                nArray[1] = n3 + n5 / 2 + n7;
                nArray2[0] = n4 + n6;
                nArray2[1] = n4 + n6;
                break;
            }
            case NORTH: {
                nArray[0] = n3 + n5 / 2 - n7;
                nArray[1] = n3 + n5 / 2 + n7;
                nArray2[0] = n4;
                nArray2[1] = n4;
                break;
            }
            case WEST: {
                nArray[0] = n3;
                nArray[1] = n3;
                nArray2[0] = n4 + n6 / 2 - n7;
                nArray2[1] = n4 + n6 / 2 + n7;
                break;
            }
            case EAST: {
                nArray[0] = n3 + n5;
                nArray[1] = n3 + n5;
                nArray2[0] = n4 + n6 / 2 - n7;
                nArray2[1] = n4 + n6 / 2 + n7;
            }
        }
        int n8 = 3;
        graphics2D.setColor(Color.BLACK);
        graphics2D.fillRoundRect(n3 + n8, n4 + n8, n5, n6, this._arcWidth * 2, this._arcHeight * 2);
        int[] nArray3 = new int[]{n, n, n};
        int[] nArray4 = new int[]{n2, n2, n2};
        nArray3[0] = nArray[0] + n8;
        nArray3[1] = nArray[1] + n8;
        nArray4[0] = nArray2[0] + n8;
        nArray4[1] = nArray2[1] + n8;
        graphics2D.fillPolygon(nArray3, nArray4, 3);
        graphics2D.setColor(this._fillColor);
        graphics2D.fillRoundRect(n3, n4, n5, n6, this._arcWidth * 2, this._arcHeight * 2);
        graphics2D.setColor(this._borderColor);
        graphics2D.drawRoundRect(n3, n4, n5, n6, this._arcWidth * 2, this._arcHeight * 2);
        if (tdkIdentificationBalloon.getTipAlignment() == Alignment.CENTER) {
            return;
        }
        graphics2D.setColor(this._fillColor);
        graphics2D.fillPolygon(nArray, nArray2, 3);
        graphics2D.setColor(this._borderColor);
        graphics2D.drawLine(nArray[0], nArray2[0], nArray[2], nArray2[2]);
        graphics2D.drawLine(nArray[1], nArray2[1], nArray[2], nArray2[2]);
        graphics2D.setColor(this._fillColor);
        graphics2D.drawLine(nArray[0], nArray2[0], nArray[1], nArray2[1]);
        graphics2D.setColor(this._borderColor);
        graphics2D.drawLine(nArray[0], nArray2[0], nArray[0], nArray2[0]);
        graphics2D.drawLine(nArray[1], nArray2[1], nArray[1], nArray2[1]);
    }

    private void drawIdentification(TdkIdentificationBalloon tdkIdentificationBalloon, Graphics2D graphics2D, TdkMapDisplay tdkMapDisplay) {
        int n = tdkIdentificationBalloon.getWidth() - 2 * this._arcWidth;
        graphics2D.setFont(this._font);
        int n2 = graphics2D.getFontMetrics().getMaxAscent();
        int n3 = tdkIdentificationBalloon.getXBalloonLocation() + this._arcWidth;
        int n4 = tdkIdentificationBalloon.getYBalloonLocation() + this._arcHeight + n2;
        graphics2D.setColor(this._textColor);
        for (String string : tdkIdentificationBalloon.getTextLines()) {
            int n5 = graphics2D.getFontMetrics().stringWidth(string);
            int n6 = (n - n5) / 2;
            graphics2D.drawString(string, n3 + n6, n4);
            n4 += n2;
        }
    }

    private boolean intersectsBalloons(int n, int n2) {
        if (this._isShowing) {
            for (TdkIdentificationBalloon tdkIdentificationBalloon : this._identificationBalloons) {
                if (!tdkIdentificationBalloon.intersects(n, n2)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
    }

    @Override
    public void viewportResized(Object object, Envelope envelope) {
        this.setNeedDrawUpdate(true);
    }

    @Override
    public void windowChanged(boolean bl, Object object, Envelope envelope) {
        this.setNeedDrawUpdate(true);
    }

    @Override
    public void windowHistoryCleared() {
    }

    protected static enum Alignment {
        SOUTH,
        NORTH,
        WEST,
        EAST,
        CENTER;

    }
}

