/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.map.elements;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import org.tecgraf.jtdk.core.model.TeTextSet;
import org.tecgraf.jtdk.core.swig.TdkAbstractGraphicalService;
import org.tecgraf.jtdk.core.swig.TdkAbstractPersistenceService;
import org.tecgraf.jtdk.core.swig.TdkSetup;
import org.tecgraf.jtdk.core.swig.TdkThemeGID;
import org.tecgraf.jtdk.core.swig.TdkThemeGeographicObjectGIDSet;
import org.tecgraf.jtdk.core.swig.TdkViewGID;
import org.tecgraf.jtdk.core.swig.TdkViewGeographicObjectGIDSet;
import org.tecgraf.jtdk.desktop.components.map.TdkMapDisplay;
import org.tecgraf.jtdk.desktop.components.map.elements.TdkIdentificationMapElement;

public class TdkObjectIdentificationMapElement
extends TdkIdentificationMapElement {
    TdkViewGeographicObjectGIDSet _identifiedObjects;

    public TdkObjectIdentificationMapElement(TdkMapDisplay tdkMapDisplay) {
        super(tdkMapDisplay);
        TdkViewGID tdkViewGID = tdkMapDisplay.getView();
        if (tdkViewGID != null) {
            this._identifiedObjects = new TdkViewGeographicObjectGIDSet(tdkViewGID);
        }
    }

    public void setView(TdkViewGID tdkViewGID) {
        if (this._identifiedObjects == null || !this._identifiedObjects.getViewDBKey().equals(tdkViewGID.getDBKey()) || this._identifiedObjects.getViewId() != tdkViewGID.getId()) {
            this._identifiedObjects = new TdkViewGeographicObjectGIDSet(tdkViewGID);
            this._updateBalloons = true;
        }
    }

    public void addIdentifications(TdkViewGeographicObjectGIDSet tdkViewGeographicObjectGIDSet) {
        if (this._identifiedObjects == null) {
            throw new IllegalStateException("View is not set.");
        }
        if (tdkViewGeographicObjectGIDSet != null) {
            this._identifiedObjects.add(tdkViewGeographicObjectGIDSet);
            this._updateBalloons = true;
        }
    }

    public void addIdentifications(TdkThemeGID tdkThemeGID) {
        if (this._identifiedObjects == null) {
            throw new IllegalStateException("View is not set.");
        }
        if (tdkThemeGID != null) {
            TdkAbstractPersistenceService tdkAbstractPersistenceService = TdkSetup.getPersistenceService();
            TdkThemeGeographicObjectGIDSet tdkThemeGeographicObjectGIDSet = new TdkThemeGeographicObjectGIDSet(tdkThemeGID);
            tdkAbstractPersistenceService.getThemeObjectGIDs(tdkThemeGeographicObjectGIDSet);
            this._identifiedObjects.add(tdkThemeGeographicObjectGIDSet);
            this._updateBalloons = true;
        }
    }

    public void removeIdentifications(TdkViewGeographicObjectGIDSet tdkViewGeographicObjectGIDSet) {
        if (this._identifiedObjects != null && tdkViewGeographicObjectGIDSet != null) {
            this._identifiedObjects.remove(tdkViewGeographicObjectGIDSet);
            this._updateBalloons = true;
        }
    }

    public void removeIdentifications(TdkThemeGID tdkThemeGID) {
        if (this._identifiedObjects != null && tdkThemeGID != null) {
            int n = tdkThemeGID.getId();
            TdkThemeGeographicObjectGIDSet tdkThemeGeographicObjectGIDSet = this._identifiedObjects.getTdkThemeGeographicObjectGIDSet(n);
            this._identifiedObjects.remove(tdkThemeGeographicObjectGIDSet);
            this._updateBalloons = true;
        }
    }

    @Override
    public void clearIdentifications() {
        super.clearIdentifications();
        if (this._identifiedObjects != null) {
            String string = this._identifiedObjects.getViewDBKey();
            int n = this._identifiedObjects.getViewId();
            this._identifiedObjects = new TdkViewGeographicObjectGIDSet(n, string);
        }
    }

    @Override
    protected TeTextSet getIdentifications(TdkMapDisplay tdkMapDisplay) {
        Envelope envelope = tdkMapDisplay.getWindow();
        double d = tdkMapDisplay.getScale();
        if (this._identifiedObjects == null) {
            return new TeTextSet();
        }
        GeometryFactory geometryFactory = new GeometryFactory();
        Coordinate coordinate = new Coordinate(envelope.getMinX(), envelope.getMinY());
        Coordinate coordinate2 = new Coordinate(envelope.getMaxX(), envelope.getMinY());
        Coordinate coordinate3 = new Coordinate(envelope.getMaxX(), envelope.getMaxY());
        Coordinate coordinate4 = new Coordinate(envelope.getMinX(), envelope.getMaxY());
        Coordinate[] coordinateArray = new Coordinate[]{coordinate, coordinate2, coordinate3, coordinate4, coordinate};
        LinearRing linearRing = geometryFactory.createLinearRing(coordinateArray);
        Polygon polygon = geometryFactory.createPolygon(linearRing, null);
        TeTextSet teTextSet = new TeTextSet();
        TdkAbstractGraphicalService tdkAbstractGraphicalService = TdkSetup.getGraphicalService();
        tdkAbstractGraphicalService.getObjectsIdentifications(this._identifiedObjects, polygon, d, teTextSet);
        return teTextSet;
    }

    public TdkViewGeographicObjectGIDSet getIdentifiedObjects() {
        return this._identifiedObjects;
    }
}

