/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.map.statusbar;

import com.vividsolutions.jts.geom.Coordinate;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import org.tecgraf.jtdk.desktop.components.map.TdkMapDisplay;
import org.tecgraf.jtdk.desktop.components.map.statusbar.TdkStatusBarPanel;

public class TdkScaleBar
extends TdkStatusBarPanel {
    NumberFormat _numberFormat;

    public TdkScaleBar(TdkMapDisplay tdkMapDisplay) {
        this.setCoordinate(null);
        tdkMapDisplay.addMouseMotionListener(new MyMouseMotionListener());
    }

    protected NumberFormat getNumberFormat() {
        if (this._numberFormat == null) {
            this._numberFormat = NumberFormat.getInstance();
            this._numberFormat.setGroupingUsed(false);
            this._numberFormat.setMaximumFractionDigits(2);
            this._numberFormat.setMinimumFractionDigits(2);
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
            decimalFormatSymbols.setDecimalSeparator('.');
            ((DecimalFormat)this._numberFormat).setDecimalFormatSymbols(decimalFormatSymbols);
        }
        return this._numberFormat;
    }

    private void setCoordinate(Coordinate coordinate) {
        double d = 0.0;
        double d2 = 0.0;
        if (coordinate != null) {
            d = coordinate.x;
            d2 = coordinate.y;
        }
        this.setText("x = " + this.getNumberFormat().format(d) + ", " + "y = " + this.getNumberFormat().format(d2));
    }

    private class MyMouseMotionListener
    implements MouseMotionListener {
        private MyMouseMotionListener() {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            Object object;
            if (mouseEvent != null && (object = mouseEvent.getSource()) instanceof TdkMapDisplay) {
                TdkMapDisplay tdkMapDisplay = (TdkMapDisplay)object;
                Coordinate coordinate = new Coordinate();
                Coordinate coordinate2 = new Coordinate((double)mouseEvent.getX(), (double)mouseEvent.getY());
                tdkMapDisplay.viewport2window(coordinate2, coordinate);
                TdkScaleBar.this.setCoordinate(coordinate);
            }
        }
    }
}

