/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.map.statusbar;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class TdkStatusBarPanel {
    private final Insets _INSETS = new Insets(1, 4, 0, 6);
    private JPanel _panel;
    private JLabel _label;

    public TdkStatusBarPanel() {
        this(null);
    }

    public TdkStatusBarPanel(String string) {
        this._label = new JLabel(string);
        this._panel = new JPanel(new BorderLayout());
        this._panel.setBorder(this.createBorder());
        this._panel.add((Component)this._label, "Center");
    }

    public final Container getContentPane() {
        return this._panel;
    }

    public JLabel getLabel() {
        return this._label;
    }

    public void setText(String string) {
        this._label.setText(string);
    }

    public String getText() {
        return this._label.getText();
    }

    public void setToolTipText(String string) {
        this._label.setToolTipText(string);
    }

    public String getToolTipText() {
        return this._label.getToolTipText();
    }

    public void setIcon(Icon icon) {
        this._label.setIcon(icon);
    }

    public Icon getIcon() {
        return this._label.getIcon();
    }

    protected Insets getInsets() {
        return this._INSETS;
    }

    private Border createBorder() {
        return new AbstractBorder(){
            private static final long serialVersionUID = 8966247756397896397L;

            @Override
            public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                if (n4 <= 0) {
                    return;
                }
                Color color = graphics.getColor();
                Color color2 = UIManager.getDefaults().getColor("controlShadow");
                graphics.setColor(color2);
                graphics.drawLine(n, n2, n3 - 2, n2);
                graphics.drawLine(n, n2, n, n4 - 2);
                graphics.setColor(color2.brighter().brighter());
                graphics.drawLine(n, n4 - 1, n3 - 1, n4 - 1);
                graphics.drawLine(n3 - 1, n2, n3 - 1, n4 - 1);
                graphics.setColor(color);
            }

            @Override
            public Insets getBorderInsets(Component component) {
                return TdkStatusBarPanel.this.getInsets();
            }

            @Override
            public Insets getBorderInsets(Component component, Insets insets) {
                insets.bottom = 0;
                insets.right = 4;
                insets.left = 4;
                insets.top = 1;
                return insets;
            }

            @Override
            public boolean isBorderOpaque() {
                return false;
            }
        };
    }
}

