/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.map.statusbar;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.desktop.components.map.TdkMapDisplay;
import org.tecgraf.jtdk.desktop.components.map.TdkMapDisplayAdapter;
import org.tecgraf.jtdk.desktop.components.map.TdkVisualSurfaceListener;
import org.tecgraf.jtdk.desktop.components.map.statusbar.TdkStatusBarPanel;

public class TdkTextFieldScalePanel
extends TdkStatusBarPanel {
    private static final Logger _logger = Logger.getLogger(TdkTextFieldScalePanel.class);
    private JTextField _txScale;
    private NumberFormat _numberFormat;
    private TdkMapDisplay _display;
    private boolean _initialized = false;

    public TdkTextFieldScalePanel(TdkMapDisplay tdkMapDisplay) {
        if (tdkMapDisplay == null) {
            throw new IllegalArgumentException("MapDisplay can't be null");
        }
        JLabel jLabel = new JLabel("Escala = 1 / ");
        this._display = tdkMapDisplay;
        this.getContentPane().add((Component)jLabel, "Center");
        this.getContentPane().add((Component)this.getTfScale(), "East");
        this._display.addMapDisplayListener(new MyMapDisplayListener());
        this.setScaleValue(this.getInvertedScale());
        tdkMapDisplay.addVisualSurfaceListener(new MyVisualSurfaceListener());
    }

    @Override
    protected Insets getInsets() {
        Insets insets = super.getInsets();
        return new Insets(insets.top, insets.left, insets.bottom, 0);
    }

    private double getInvertedScale() {
        double d = 0.0;
        if (this._display.isConnectedToNativeCanvas()) {
            _logger.debug((Object)("Scale value: " + this._display.getScale()));
            if (this._display.getScale() != 0.0) {
                d = this._display.getScale();
            }
        }
        return d;
    }

    public void setScaleValue(double d) {
        String string = "";
        if (this._txScale.isEnabled()) {
            string = this.getNumberFormat().format(d);
        }
        this.getTfScale().setText(string);
    }

    public double getScaleValue() {
        return Double.parseDouble(this.getTfScale().getText());
    }

    public void setEnabled(boolean bl) {
        this._txScale.setEnabled(bl);
    }

    protected JTextField getTfScale() {
        if (this._txScale == null) {
            this._txScale = new JTextField(10);
            this._txScale.addActionListener(new MyScaleAction());
        }
        return this._txScale;
    }

    protected NumberFormat getNumberFormat() {
        if (this._numberFormat == null) {
            this._numberFormat = NumberFormat.getInstance();
            this._numberFormat.setGroupingUsed(false);
            this._numberFormat.setMaximumFractionDigits(3);
            this._numberFormat.setMinimumFractionDigits(3);
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
            decimalFormatSymbols.setDecimalSeparator('.');
            ((DecimalFormat)this._numberFormat).setDecimalFormatSymbols(decimalFormatSymbols);
        }
        return this._numberFormat;
    }

    private final class MyScaleAction
    implements ActionListener {
        private MyScaleAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                double d = Double.parseDouble(TdkTextFieldScalePanel.this._txScale.getText());
                if (d <= 0.0) {
                    return;
                }
                double d2 = d;
                d2 = d2 != 0.0 ? TdkTextFieldScalePanel.this.getInvertedScale() / d2 : 1.0;
                TdkTextFieldScalePanel.this._display.zoom(d2);
                TdkTextFieldScalePanel.this._display.redraw();
                _logger.debug((Object)("new scale set on map: " + d));
            }
            catch (Exception exception) {
                _logger.error((Object)"Scale invalid", (Throwable)exception);
            }
        }
    }

    private final class MyVisualSurfaceListener
    implements TdkVisualSurfaceListener {
        private MyVisualSurfaceListener() {
        }

        @Override
        public void viewportResized(Object object, Envelope envelope) {
        }

        @Override
        public void windowChanged(boolean bl, Object object, Envelope envelope) {
            if (!bl && TdkTextFieldScalePanel.this._initialized) {
                TdkTextFieldScalePanel.this.setScaleValue(TdkTextFieldScalePanel.this.getInvertedScale());
            }
        }

        @Override
        public void windowHistoryCleared() {
        }
    }

    private final class MyMapDisplayListener
    extends TdkMapDisplayAdapter {
        private MyMapDisplayListener() {
        }

        @Override
        public void mapDrawn(boolean bl, Object object) {
            if (!bl && !TdkTextFieldScalePanel.this._initialized) {
                TdkTextFieldScalePanel.this.setScaleValue(TdkTextFieldScalePanel.this.getInvertedScale());
                TdkTextFieldScalePanel.this._initialized = true;
            }
        }
    }
}

