/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.map.tool;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLayeredPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.tecgraf.jtdk.desktop.components.TdkComponentsI18n;

public abstract class TdkAbstractCreatePointDialog
extends JDialog
implements WindowListener {
    private ActionListener _actionListener;
    private WindowListener _windowListener;
    protected JButton _okBtn;
    protected JTextField _xCoord;
    protected JTextField _yCoord;
    private boolean _disableListener = false;

    public TdkAbstractCreatePointDialog(Frame frame, ActionListener actionListener, WindowListener windowListener) {
        super(frame);
        this.dialogInit();
        this.initComponents();
        this._actionListener = actionListener;
        this._windowListener = windowListener;
        this.addWindowListener(this._windowListener);
        this.addWindowListener(this);
        this._okBtn.addActionListener(this._actionListener);
    }

    private void changeCoord() {
        if (!this._disableListener) {
            ActionEvent actionEvent = new ActionEvent(this, -1, "change_coord");
            if (this._actionListener != null) {
                this._actionListener.actionPerformed(actionEvent);
            }
        }
    }

    @Override
    protected void dialogInit() {
        super.dialogInit();
        JLayeredPane jLayeredPane = this.getLayeredPane();
        jLayeredPane.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "close-it");
        jLayeredPane.getActionMap().put("close-it", new AbstractAction(){
            private static final long serialVersionUID = -981293722133215719L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() instanceof JLayeredPane && TdkAbstractCreatePointDialog.this._actionListener != null) {
                    TdkAbstractCreatePointDialog.this._actionListener.actionPerformed(null);
                    TdkAbstractCreatePointDialog.this.dispose();
                    TdkAbstractCreatePointDialog.this.hideDialog();
                }
            }
        });
    }

    public void showDialog() {
        this.setXCoord(0.0);
        this.setYCoord(0.0);
        this.setVisible(true);
    }

    public void hideDialog() {
        this.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setXCoord(double d) {
        try {
            this._disableListener = true;
            this._xCoord.setText(String.valueOf(d));
        }
        finally {
            this._disableListener = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setYCoord(double d) {
        try {
            this._disableListener = true;
            this._yCoord.setText(String.valueOf(d));
        }
        finally {
            this._disableListener = false;
        }
    }

    public String getXCoord() {
        return this._xCoord.getText();
    }

    public String getYCoord() {
        return this._yCoord.getText();
    }

    private void initComponents() {
        this.configureDialog();
        this.configureDialogContent();
        Dimension dimension = this.getToolkit().getScreenSize();
        this.setLocation(dimension.width / 2 - this.getWidth() / 2, dimension.height / 2 - this.getHeight() / 2);
        this._xCoord.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                TdkAbstractCreatePointDialog.this.changeCoord();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                TdkAbstractCreatePointDialog.this.changeCoord();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                TdkAbstractCreatePointDialog.this.changeCoord();
            }
        });
        this._yCoord.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                TdkAbstractCreatePointDialog.this.changeCoord();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                TdkAbstractCreatePointDialog.this.changeCoord();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                TdkAbstractCreatePointDialog.this.changeCoord();
            }
        });
    }

    protected abstract void configureDialogContent();

    protected void configureDialog() {
        this.setTitle(TdkComponentsI18n.getString("NAV_TOOL_BAR_CREATE_POINT_DLG_TITLE"));
        this.setDefaultCloseOperation(2);
        this.setResizable(true);
        this.setModal(false);
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (this._actionListener != null) {
            this._actionListener.actionPerformed(null);
        }
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }
}

