/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.map.tool;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.core.algorithms.TdkCalcOrthodromicDistance;
import org.tecgraf.jtdk.core.algorithms.TdkGeneratePolygonByRadius;
import org.tecgraf.jtdk.core.exceptions.TdkInvalidParamValueException;
import org.tecgraf.jtdk.core.swig.TdkSetup;
import org.tecgraf.jtdk.core.swig.TdkView;
import org.tecgraf.jtdk.core.swig.TdkViewGID;
import org.tecgraf.jtdk.core.swig.TeDatum;
import org.tecgraf.jtdk.core.swig.TeProjection;
import org.tecgraf.jtdk.core.swig.TeProjectionParams;
import org.tecgraf.jtdk.desktop.components.map.TdkMapDisplay;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkInteractor;

public class TdkCircleInteractor
extends TdkInteractor {
    private Logger _logger = Logger.getLogger(TdkCircleInteractor.class);
    protected Coordinate _first;
    protected double _radius;
    protected boolean _isDragged = false;
    protected BasicStroke _polygonStyle;
    protected Polygon _polygon;
    private static final int NUM_COORDS = 64;
    private static final double PRECISION_FACTOR = 0.01;

    public TdkCircleInteractor(TdkMapDisplay tdkMapDisplay) {
        super(tdkMapDisplay);
        this.reset();
        this._polygonStyle = new BasicStroke(1.0f);
        TeProjectionParams teProjectionParams = new TeProjectionParams();
        teProjectionParams.setName("LatLong");
        teProjectionParams.setDatum(new TeDatum("WGS84"));
    }

    private Polygon getPolygon(Coordinate coordinate, Coordinate coordinate2, int n) {
        TdkViewGID tdkViewGID;
        TeProjection teProjection = null;
        if (this._mapDisplay != null && (tdkViewGID = this._mapDisplay.getView()) != null) {
            TdkView tdkView = TdkSetup.getPersistenceService().getView(tdkViewGID);
            if (tdkView != null) {
                teProjection = tdkView.getProjection();
            } else {
                this._logger.error((Object)"Could not get view projection");
                return null;
            }
        }
        try {
            double d = TdkCalcOrthodromicDistance.calcDistanceInMeters((Coordinate)coordinate, (Coordinate)coordinate2, teProjection);
            return TdkGeneratePolygonByRadius.create((Coordinate)coordinate, (Coordinate)coordinate2, teProjection, (int)64, (double)(d * 0.01));
        }
        catch (TdkInvalidParamValueException tdkInvalidParamValueException) {
            this._logger.warn((Object)("Could not create polygon: " + tdkInvalidParamValueException.getMessage()));
            return null;
        }
    }

    public Coordinate getCenter() {
        return this._first;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() != 1) {
            return;
        }
        this._isDragged = true;
        this._first = this.getWindowCoord(mouseEvent);
        this._polygon = null;
        this._radius = 0.0;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this._mapDisplay == null || this._first == null || !this._isDragged) {
            return;
        }
        this.draw();
        Coordinate coordinate = this.getWindowCoord(mouseEvent);
        this._radius = this._first.distance(coordinate);
        this._polygon = this.getPolygon(this._first, coordinate, 64);
        this.draw();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() != 1) {
            return;
        }
        if (mouseEvent.getClickCount() == 1) {
            this.dispatchCoord(this.getWindowCoord(mouseEvent), mouseEvent.getModifiersEx());
            this.reset();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this._first == null || !this._isDragged) {
            return;
        }
        this.draw();
        Coordinate coordinate = this.getWindowCoord(mouseEvent);
        this._radius = this._first.distance(coordinate);
        this._polygon = this.getPolygon(this._first, coordinate, 64);
        if (this._polygon != null) {
            this._logger.debug((Object)("Polygon dispatched: " + this._polygon));
            this.dispatchPolygon(this._polygon, mouseEvent.getModifiersEx());
        }
        this.reset();
    }

    @Override
    public void reset() {
        this._first = new Coordinate();
        this._radius = 0.0;
        this._polygon = null;
        this._isDragged = false;
    }

    public void draw() {
        if (this._polygon == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)this._mapDisplay.getGraphics();
        graphics2D.setColor(Color.DARK_GRAY);
        graphics2D.setXORMode(Color.BLACK);
        graphics2D.setTransform(this._mapDisplay.getWindowTransform());
        GeneralPath generalPath = new GeneralPath();
        generalPath.reset();
        Coordinate[] coordinateArray = this._polygon.getCoordinates();
        boolean bl = true;
        for (Coordinate coordinate : coordinateArray) {
            if (bl) {
                generalPath.moveTo((float)coordinate.x, (float)coordinate.y);
                bl = false;
                continue;
            }
            generalPath.lineTo((float)coordinate.x, (float)coordinate.y);
        }
        generalPath.closePath();
        this._mapDisplay.setStrokeForWindow(graphics2D, this._polygonStyle);
        graphics2D.fill(generalPath);
    }

    public double getRadius() {
        return this._radius;
    }

    public Polygon getCurrentPolygon() {
        return this._polygon;
    }

    public void setPolygonStyle(BasicStroke basicStroke) {
        this._polygonStyle = basicStroke;
    }
}

