/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.map.tool;

import com.vividsolutions.jts.geom.Coordinate;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.core.swig.TdkLayerGID;
import org.tecgraf.jtdk.desktop.components.TdkComponentsI18n;
import org.tecgraf.jtdk.desktop.components.map.TdkMapDisplay;
import org.tecgraf.jtdk.desktop.components.map.tool.ITdkCreatePointDialogFactory;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkAbstractCreatePointActionHandler;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkAbstractCreatePointDialog;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkDeafultCreatePointDialog;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkInteractorAdapter;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkInteractorTool;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkPointDialogInteractor;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkPointInteractor;
import org.tecgraf.jtdk.desktop.components.util.TdkDialogUtil;

public class TdkCreatePointTool
extends TdkInteractorTool {
    private Logger _logger = Logger.getLogger(TdkCreatePointTool.class);
    public static final String BTN_CREATE_POINT = "create_point";
    protected TdkAbstractCreatePointActionHandler _createPointHandler;
    boolean _withDialog = false;
    public static final String ACT_CMD_OK = "ok_command";
    public static final String ACT_CMD_CHANGE_COORD = "change_coord";
    protected TdkAbstractCreatePointDialog _dialog = null;
    protected MyInteractorListener _dialogInteractorListener;
    private TdkPointDialogInteractor _pointDialogInteractor;
    public static final String CURSOR_NAME = "point_cursor";
    private Cursor _cursor;
    private ITdkCreatePointDialogFactory _createPointDialogFactory;

    public TdkCreatePointTool(TdkMapDisplay tdkMapDisplay, TdkAbstractCreatePointActionHandler tdkAbstractCreatePointActionHandler) {
        this(tdkMapDisplay, tdkAbstractCreatePointActionHandler, false);
    }

    public TdkCreatePointTool(TdkMapDisplay tdkMapDisplay, TdkAbstractCreatePointActionHandler tdkAbstractCreatePointActionHandler, boolean bl) {
        this._createPointHandler = tdkAbstractCreatePointActionHandler;
        this._withDialog = bl;
        this.setMapDisplay(tdkMapDisplay);
        boolean bl2 = this._withDialog;
        if (this._withDialog) {
            this._pointDialogInteractor = new TdkPointDialogInteractor(this.getMapDisplay(), bl2, this, this._createPointHandler);
            this.setInteractor(this._pointDialogInteractor);
        } else {
            this.setInteractor(new TdkPointInteractor(this.getMapDisplay(), bl2));
        }
        this.setName(BTN_CREATE_POINT);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.getImage(this.getClass().getResource("/org/tecgraf/jtdk/desktop/components/icons/cursor_create_point.gif"));
        this._cursor = toolkit.createCustomCursor(image, new Point(0, 0), CURSOR_NAME);
        if (this._withDialog) {
            this._dialogInteractorListener = new MyInteractorListener();
            this.setInteractorListener(this._dialogInteractorListener);
        } else {
            this.setInteractorListener(this._createPointHandler);
        }
        this.setBorder(BorderFactory.createBevelBorder(0));
        this.setToolTipText(TdkComponentsI18n.getString("NAV_TOOL_BAR_CREATE_POINT_TIP"));
        this.setIcon(new ImageIcon(this.getClass().getResource("/org/tecgraf/jtdk/desktop/components/icons/create_point.gif")));
        this.getInteractor().addInteractorListener(this.getInteractorListener());
        this._logger.debug((Object)"created");
    }

    public TdkAbstractCreatePointActionHandler getCreatePointHandler() {
        return this._createPointHandler;
    }

    public void setLayerGID(TdkLayerGID tdkLayerGID) {
        this._createPointHandler.setLayerGID(tdkLayerGID);
    }

    public void setCreatePointDialogFactory(ITdkCreatePointDialogFactory iTdkCreatePointDialogFactory) {
        this._createPointDialogFactory = iTdkCreatePointDialogFactory;
    }

    @Override
    public void start() {
        TdkPointInteractor tdkPointInteractor = (TdkPointInteractor)this.getInteractor();
        tdkPointInteractor.reset();
        this.getInteractor().setDefaultCursor(this._cursor);
        if (this._withDialog) {
            if (this._pointDialogInteractor != null) {
                this._dialog = this._createPointDialogFactory.createDialog(TdkDialogUtil.getFrameParent((Component)((Object)this.getMapDisplay())), this._pointDialogInteractor, new MyDialogWindowListener());
                this._pointDialogInteractor.setDialog(this._dialog);
            }
            TdkDialogUtil.centralize(this._dialog);
            this._dialog.setModal(false);
            this._dialog.showDialog();
        }
        this._logger.debug((Object)"started");
    }

    @Override
    public void finish() {
        TdkPointInteractor tdkPointInteractor = (TdkPointInteractor)this.getInteractor();
        tdkPointInteractor.reset();
        if (this._withDialog && this._dialog != null) {
            this._dialog.setVisible(false);
        }
        this._logger.debug((Object)"finished");
    }

    private class MyDialogWindowListener
    extends WindowAdapter {
        private MyDialogWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            if (windowEvent.getSource() instanceof TdkDeafultCreatePointDialog) {
                TdkCreatePointTool.this.finish();
            }
        }
    }

    private class MyInteractorListener
    extends TdkInteractorAdapter {
        private MyInteractorListener() {
        }

        @Override
        public void handleCoord(TdkMapDisplay tdkMapDisplay, Coordinate coordinate, int n) {
            if (!TdkCreatePointTool.this._dialog.isVisible()) {
                TdkCreatePointTool.this._dialog.setVisible(true);
            }
            if (TdkCreatePointTool.this.getMapDisplay().getView() != null && n >= 0) {
                TdkCreatePointTool.this._logger.debug((Object)"createPoint: set coord in dialog");
                TdkCreatePointTool.this._dialog.setXCoord(coordinate.x);
                TdkCreatePointTool.this._dialog.setYCoord(coordinate.y);
            }
        }
    }
}

