/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.map.tool;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.core.TdkJavaProcessingService;
import org.tecgraf.jtdk.core.swig.TdkViewGeographicObjectGIDSet;
import org.tecgraf.jtdk.desktop.components.TdkComponentsI18n;
import org.tecgraf.jtdk.desktop.components.TdkObjectSelectionContext;
import org.tecgraf.jtdk.desktop.components.map.TdkMapDisplay;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkSimpleTool;
import org.tecgraf.jtdk.desktop.components.util.TdkMapUtil;

public class TdkFitSelectedTool
extends TdkSimpleTool {
    private static final Logger _logger = Logger.getLogger(TdkFitSelectedTool.class);
    public static final String BTN_FIT_SELETED = "fit_selected";
    TdkObjectSelectionContext _context;

    public TdkFitSelectedTool(TdkMapDisplay tdkMapDisplay, TdkObjectSelectionContext tdkObjectSelectionContext) {
        this.setMapDisplay(tdkMapDisplay);
        this.setName(BTN_FIT_SELETED);
        this.setIcon(new ImageIcon(this.getClass().getResource("/org/tecgraf/jtdk/desktop/components/icons/fit_selected.gif")));
        this.setBorder(BorderFactory.createBevelBorder(0));
        this.setToolTipText(TdkComponentsI18n.getString("NAV_TOOL_BAR_FIT_SELECTED_TIP"));
        this._context = tdkObjectSelectionContext;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        _logger.info((Object)"Action Performed: fit_selected");
        if (this.getMapDisplay() == null) {
            _logger.warn((Object)"No TdkMapDisplay is associated to this controller, _mapDisplay is null.");
            return;
        }
        if (this._context != null) {
            TdkViewGeographicObjectGIDSet tdkViewGeographicObjectGIDSet = this._context.getSelectedObjects();
            try {
                Envelope envelope = new TdkJavaProcessingService().getObjectsBoundingBox(tdkViewGeographicObjectGIDSet);
                if (!envelope.isNull()) {
                    envelope = TdkMapUtil.addBorderToBox(envelope, this.getMapDisplay());
                    this.getMapDisplay().zoomArea(envelope);
                    this.getMapDisplay().redraw();
                    _logger.debug((Object)"fit selected tool operation performed");
                }
            }
            catch (Exception exception) {
                return;
            }
        }
    }
}

