/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.map.tool;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Vector;
import javax.swing.event.MouseInputListener;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.desktop.components.map.TdkMapDisplay;
import org.tecgraf.jtdk.desktop.components.map.TdkMapDisplayAdapter;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkInteractorListener;

public class TdkInteractor
extends TdkMapDisplayAdapter
implements MouseInputListener,
MouseWheelListener {
    private static Logger _logger = Logger.getLogger(TdkInteractor.class);
    protected Vector<TdkInteractorListener> _listeners;
    protected TdkMapDisplay _mapDisplay;

    public TdkInteractor(TdkMapDisplay tdkMapDisplay) {
        this._mapDisplay = tdkMapDisplay;
        this._listeners = new Vector();
    }

    public void setDefaultCursor(Cursor cursor) {
        this._mapDisplay.setCursor(cursor);
    }

    public void addInteractorListener(TdkInteractorListener tdkInteractorListener) {
        this._listeners.add(tdkInteractorListener);
        _logger.debug((Object)("add interactor listener: " + tdkInteractorListener));
    }

    public void removeInteractorListener(TdkInteractorListener tdkInteractorListener) {
        this._listeners.remove(tdkInteractorListener);
        _logger.debug((Object)("remove interactor listener: " + tdkInteractorListener));
    }

    protected void dispatchCoord(Coordinate coordinate, int n) {
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).handleCoord(this._mapDisplay, coordinate, n);
        }
    }

    protected void dispatchLineSegment(LineSegment lineSegment, int n) {
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).handleLineSegment(this._mapDisplay, lineSegment, n);
        }
    }

    protected void dispatchLineString(LineString lineString, int n) {
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).handleLineString(this._mapDisplay, lineString, n);
        }
    }

    protected void dispatchPolygon(Polygon polygon, int n) {
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).handlePolygon(this._mapDisplay, polygon, n);
        }
    }

    protected void dispatchBox(Envelope envelope, int n) {
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).handleBox(this._mapDisplay, envelope, n);
        }
    }

    protected Coordinate getWindowCoord(MouseEvent mouseEvent) {
        Coordinate coordinate = new Coordinate((double)mouseEvent.getX(), (double)mouseEvent.getY());
        Coordinate coordinate2 = new Coordinate();
        this._mapDisplay.viewport2window(coordinate, coordinate2);
        return coordinate2;
    }

    protected Coordinate getViewportCoord(MouseEvent mouseEvent) {
        return new Coordinate((double)mouseEvent.getX(), (double)mouseEvent.getY());
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
    }

    public void reset() {
    }
}

