/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.map.tool;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkInteractor;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkInteractorTool;

public class TdkMultiInteractorTool
extends TdkInteractorTool {
    private HashMap<Class, TdkInteractor> _interactors = new HashMap();
    private HashMap<Class, JMenuItem> _itens = new HashMap();
    private AbstractButton _parentButton;

    public void setParentButton(AbstractButton abstractButton) {
        this._parentButton = abstractButton;
    }

    public AbstractButton getParentButton() {
        return this._parentButton;
    }

    public void addInteractor(TdkInteractor tdkInteractor, String string, String string2, Icon icon) {
        JMenuItem jMenuItem = this.generateMenuItem(string, string2, icon, tdkInteractor);
        this._itens.put(tdkInteractor.getClass(), jMenuItem);
        tdkInteractor.addInteractorListener(this.getInteractorListener());
        this._interactors.put(tdkInteractor.getClass(), tdkInteractor);
    }

    public TdkInteractor getInteractor(Class clazz) {
        return this._interactors.get(clazz);
    }

    public JMenuItem getMenuItem(Class clazz) {
        return this._itens.get(clazz);
    }

    public void setCurrentInteractor(TdkInteractor tdkInteractor) {
        if (this.getInteractor(tdkInteractor.getClass()) == null) {
            throw new IllegalArgumentException("Interactor set to current isn't added");
        }
        this.setIcon(this._itens.get(tdkInteractor.getClass()).getIcon());
        this.setToolTipText(this._itens.get(tdkInteractor.getClass()).getToolTipText());
        this.setInteractor(tdkInteractor);
    }

    public Collection<TdkInteractor> getInteractors() {
        return this._interactors.values();
    }

    @Override
    public void start() {
        for (TdkInteractor tdkInteractor : this.getInteractors()) {
            tdkInteractor.reset();
        }
    }

    protected JMenuItem generateMenuItem(String string, String string2, Icon icon, TdkInteractor tdkInteractor) {
        JMenuItem jMenuItem = new JMenuItem(string2, icon);
        jMenuItem.setToolTipText(string);
        jMenuItem.addActionListener(new ItemInteractorAction(tdkInteractor, this));
        return jMenuItem;
    }

    protected class ItemInteractorAction
    implements ActionListener {
        private TdkInteractor interactor;
        private TdkMultiInteractorTool tool;

        public ItemInteractorAction(TdkInteractor tdkInteractor, TdkMultiInteractorTool tdkMultiInteractorTool2) {
            this.interactor = tdkInteractor;
            this.tool = tdkMultiInteractorTool2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.tool.getParentButton().setIcon(this.tool.getMenuItem(this.interactor.getClass()).getIcon());
            this.tool.setCurrentInteractor(this.interactor);
            this.tool.getParentButton().setSelected(true);
            TdkMultiInteractorTool.this.start();
            for (ActionListener actionListener : this.tool.getParentButton().getActionListeners()) {
                actionListener.actionPerformed(actionEvent);
            }
        }
    }
}

