/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.map.tool;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LineSegment;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.desktop.components.map.TdkMapDisplay;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkInteractor;

public class TdkPanInteractor
extends TdkInteractor {
    private static Logger _logger = Logger.getLogger(TdkPanInteractor.class);
    protected Coordinate _first;
    protected int _dx;
    protected int _dy;
    protected boolean _isDragging;
    protected BufferedImage _snapshot;
    protected BufferedImage _buffer;
    protected Cursor _releasedCursor;
    protected Cursor _pressedCursor;

    public TdkPanInteractor(TdkMapDisplay tdkMapDisplay) {
        super(tdkMapDisplay);
        this.reset();
    }

    @Override
    public void reset() {
        this._first = null;
        this._dx = 0;
        this._dy = 0;
        this._isDragging = false;
        this._snapshot = null;
        this._buffer = null;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() != 1) {
            return;
        }
        if (this._mapDisplay.getCursor().getName() != "pan_cursor_pressed") {
            this.setDefaultCursor(this._pressedCursor);
        }
        this._isDragging = true;
        this._first = this.getWindowCoord(mouseEvent);
        this._snapshot = this._mapDisplay.getSnapshot(false);
        if (this._snapshot != null) {
            this._buffer = new BufferedImage(this._snapshot.getWidth(), this._snapshot.getHeight(), 1);
        } else {
            _logger.warn((Object)"snapshot is null");
        }
        this._dx = 0;
        this._dy = 0;
        this._mapDisplay.clear();
        this.draw();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this._isDragging) {
            return;
        }
        if (this._mapDisplay.getCursor().getName() != "pan_cursor_pressed") {
            this.setDefaultCursor(this._pressedCursor);
        }
        Coordinate coordinate = this.getViewportCoord(mouseEvent);
        Coordinate coordinate2 = new Coordinate();
        this._mapDisplay.window2viewport(this._first, coordinate2);
        this._dx = (int)(coordinate.x - coordinate2.x);
        this._dy = (int)(coordinate.y - coordinate2.y);
        this.draw();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this._isDragging) {
            return;
        }
        if (this._mapDisplay.getCursor().getName() != "pan_cursor") {
            this.setDefaultCursor(this._releasedCursor);
        }
        this.dispatchLineSegment(new LineSegment(this._first, this.getWindowCoord(mouseEvent)), mouseEvent.getModifiersEx());
        this.reset();
    }

    private void draw() {
        if (this._isDragging) {
            if (this._snapshot == null || this._buffer == null) {
                _logger.warn((Object)"invalid image buffer");
                return;
            }
            Color color = this._mapDisplay.getBackground();
            this._buffer.getGraphics().setColor(color);
            this._buffer.getGraphics().fillRect(0, 0, this._mapDisplay.getWidth(), this._mapDisplay.getHeight());
            this._buffer.getGraphics().drawImage(this._snapshot, this._dx, this._dy, null);
            this._mapDisplay.getGraphics().drawImage(this._buffer, 0, 0, null);
        }
    }

    public void setPanReleasedCursor(Cursor cursor) {
        this._releasedCursor = cursor;
    }

    public void setPanPressedCursor(Cursor cursor) {
        this._pressedCursor = cursor;
    }
}

