/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.map.tool;

import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.desktop.components.TdkComponentsI18n;
import org.tecgraf.jtdk.desktop.components.map.TdkMapDisplay;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkInteractorTool;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkPanActionHandler;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkPanInteractor;

public class TdkPanTool
extends TdkInteractorTool {
    private Logger _logger = Logger.getLogger(TdkPanTool.class);
    private Cursor _cursorReleased;
    private Cursor _cursorPressed;
    public static final String CURSOR_NAME_RELEASED = "pan_cursor_released";
    public static final String CURSOR_NAME_PRESSED = "pan_cursor_released";
    public static final String BTN_PAN = "pan";

    public TdkPanTool(TdkMapDisplay tdkMapDisplay) {
        this.setMapDisplay(tdkMapDisplay);
        TdkPanInteractor tdkPanInteractor = new TdkPanInteractor(this.getMapDisplay());
        this.setInteractor(tdkPanInteractor);
        this.setInteractorListener(new TdkPanActionHandler());
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.getImage(this.getClass().getResource("/org/tecgraf/jtdk/desktop/components/icons/pan_cursor.gif"));
        this._cursorReleased = toolkit.createCustomCursor(image, new Point(10, 10), "pan_cursor_released");
        image = toolkit.getImage(this.getClass().getResource("/org/tecgraf/jtdk/desktop/components/icons/move.png"));
        this._cursorPressed = toolkit.createCustomCursor(image, new Point(10, 10), "pan_cursor_released");
        this.setName(BTN_PAN);
        this.setIcon(new ImageIcon(this.getClass().getResource("/org/tecgraf/jtdk/desktop/components/icons/pan.gif")));
        this.setBorder(BorderFactory.createBevelBorder(0));
        this.setToolTipText(TdkComponentsI18n.getString("NAV_TOOL_BAR_PAN_TIP"));
        this.getInteractor().addInteractorListener(this.getInteractorListener());
        this._logger.debug((Object)"created");
    }

    @Override
    public void start() {
        TdkPanInteractor tdkPanInteractor = (TdkPanInteractor)this.getInteractor();
        tdkPanInteractor.setPanReleasedCursor(this._cursorReleased);
        tdkPanInteractor.setDefaultCursor(this._cursorReleased);
        tdkPanInteractor.setPanPressedCursor(this._cursorPressed);
        this._logger.debug((Object)"started");
    }
}

