/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.map.tool;

import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.core.exceptions.TdkDatabaseException;
import org.tecgraf.jtdk.core.exceptions.TdkException;
import org.tecgraf.jtdk.core.exceptions.TdkNullPointerException;
import org.tecgraf.jtdk.core.swig.TdkSetup;
import org.tecgraf.jtdk.core.swig.TdkViewGeographicObjectGIDSet;
import org.tecgraf.jtdk.desktop.components.TdkObjectSelectionContext;
import org.tecgraf.jtdk.desktop.components.map.TdkMapDisplay;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkInteractorAdapter;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkPickCircleTool;

public class TdkPickCircleActionHandler
extends TdkInteractorAdapter {
    private static Logger _logger = Logger.getLogger(TdkPickCircleActionHandler.class);
    protected TdkObjectSelectionContext _context;
    protected TdkPickCircleTool _tool;

    protected TdkPickCircleActionHandler(TdkObjectSelectionContext tdkObjectSelectionContext) {
        this._context = tdkObjectSelectionContext;
    }

    @Override
    public void handlePolygon(TdkMapDisplay tdkMapDisplay, Polygon polygon, int n) {
        GeometryFactory geometryFactory;
        TdkViewGeographicObjectGIDSet tdkViewGeographicObjectGIDSet = new TdkViewGeographicObjectGIDSet(tdkMapDisplay.getView());
        _logger.debug((Object)"pick polygon");
        try {
            geometryFactory = new GeometryFactory();
            Polygon[] polygonArray = new Polygon[]{polygon};
            MultiPolygon multiPolygon = geometryFactory.createMultiPolygon(polygonArray);
            TdkSetup.getGraphicalService().pickObjectsInCache(tdkMapDisplay.getView(), multiPolygon, tdkMapDisplay.getScale(), tdkViewGeographicObjectGIDSet);
        }
        catch (TdkNullPointerException tdkNullPointerException) {
            _logger.error((Object)tdkNullPointerException.getStackTrace());
        }
        catch (TdkDatabaseException tdkDatabaseException) {
            _logger.error((Object)tdkDatabaseException.getStackTrace());
        }
        catch (TdkException tdkException) {
            _logger.error((Object)tdkException.getStackTrace());
        }
        if ((n & 0xC0) == 64) {
            this._context.addSelectedObjects(tdkViewGeographicObjectGIDSet);
            _logger.debug((Object)"shift pressed");
        } else if ((n & 0xC0) == 128) {
            geometryFactory = new TdkViewGeographicObjectGIDSet(tdkMapDisplay.getView());
            this._context.getSelectedObjects().setIntersection(tdkViewGeographicObjectGIDSet, (TdkViewGeographicObjectGIDSet)geometryFactory);
            this._context.addSelectedObjects(tdkViewGeographicObjectGIDSet);
            this._context.removeSelectedObjects((TdkViewGeographicObjectGIDSet)geometryFactory);
            _logger.debug((Object)"ctrl pressed");
        } else {
            this._context.setSelectedObjects(tdkViewGeographicObjectGIDSet);
        }
    }
}

