/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.map.tool;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.core.exceptions.TdkDatabaseException;
import org.tecgraf.jtdk.core.exceptions.TdkException;
import org.tecgraf.jtdk.core.exceptions.TdkNullPointerException;
import org.tecgraf.jtdk.core.swig.TdkSetup;
import org.tecgraf.jtdk.core.swig.TdkViewGeographicObjectGIDSet;
import org.tecgraf.jtdk.desktop.components.TdkObjectSelectionContext;
import org.tecgraf.jtdk.desktop.components.map.TdkMapDisplay;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkInteractorAdapter;

public class TdkPickObjectsActionHandler
extends TdkInteractorAdapter {
    private static Logger _logger = Logger.getLogger(TdkPickObjectsActionHandler.class);
    final double COORD_BORDER_PIXELS = 3.0;
    protected TdkObjectSelectionContext _context;

    public TdkPickObjectsActionHandler(TdkObjectSelectionContext tdkObjectSelectionContext) {
        this._context = tdkObjectSelectionContext;
    }

    @Override
    public void handleCoord(TdkMapDisplay tdkMapDisplay, Coordinate coordinate, int n) {
        TdkViewGeographicObjectGIDSet tdkViewGeographicObjectGIDSet = this.pickPointer(tdkMapDisplay, coordinate);
        _logger.debug((Object)("pick coord x: " + coordinate.x + " y:" + coordinate.y));
        if ((n & 0xC0) == 64) {
            this._context.addSelectedObjects(tdkViewGeographicObjectGIDSet);
            _logger.debug((Object)"shift pressed");
        } else if ((n & 0xC0) == 128) {
            TdkViewGeographicObjectGIDSet tdkViewGeographicObjectGIDSet2 = new TdkViewGeographicObjectGIDSet(tdkMapDisplay.getView());
            this._context.getSelectedObjects().setIntersection(tdkViewGeographicObjectGIDSet, tdkViewGeographicObjectGIDSet2);
            this._context.addSelectedObjects(tdkViewGeographicObjectGIDSet);
            this._context.removeSelectedObjects(tdkViewGeographicObjectGIDSet2);
            _logger.debug((Object)"ctrl pressed");
        } else {
            this._context.setSelectedObjects(tdkViewGeographicObjectGIDSet);
        }
    }

    protected TdkViewGeographicObjectGIDSet pickPointer(TdkMapDisplay tdkMapDisplay, Coordinate coordinate) {
        double d = 3.0 / tdkMapDisplay.getPixelSize();
        Envelope envelope = new Envelope(coordinate.x - d, coordinate.x + d, coordinate.y - d, coordinate.y + d);
        TdkViewGeographicObjectGIDSet tdkViewGeographicObjectGIDSet = new TdkViewGeographicObjectGIDSet(tdkMapDisplay.getView());
        MultiPolygon multiPolygon = this.boxToMultiPolygon(envelope);
        try {
            TdkSetup.getGraphicalService().pickObjectOnTop(tdkMapDisplay.getView(), multiPolygon, tdkMapDisplay.getScale(), tdkViewGeographicObjectGIDSet);
        }
        catch (TdkNullPointerException tdkNullPointerException) {
            _logger.error((Object)tdkNullPointerException.getStackTrace());
        }
        catch (TdkDatabaseException tdkDatabaseException) {
            _logger.error((Object)tdkDatabaseException.getStackTrace());
        }
        catch (TdkException tdkException) {
            _logger.error((Object)tdkException.getStackTrace());
        }
        return tdkViewGeographicObjectGIDSet;
    }

    @Override
    public void handleBox(TdkMapDisplay tdkMapDisplay, Envelope envelope, int n) {
        TdkViewGeographicObjectGIDSet tdkViewGeographicObjectGIDSet = new TdkViewGeographicObjectGIDSet(tdkMapDisplay.getView());
        MultiPolygon multiPolygon = this.boxToMultiPolygon(envelope);
        _logger.debug((Object)("pick box x1: " + envelope.getMinX() + " x2:" + envelope.getMaxX() + " y1: " + envelope.getMinY() + " y2: " + envelope.getMaxY()));
        try {
            TdkSetup.getGraphicalService().pickObjectsInCache(tdkMapDisplay.getView(), multiPolygon, tdkMapDisplay.getScale(), tdkViewGeographicObjectGIDSet);
        }
        catch (TdkNullPointerException tdkNullPointerException) {
            _logger.error((Object)tdkNullPointerException.getStackTrace());
        }
        catch (TdkDatabaseException tdkDatabaseException) {
            _logger.error((Object)tdkDatabaseException.getStackTrace());
        }
        catch (TdkException tdkException) {
            _logger.error((Object)tdkException.getStackTrace());
        }
        if ((n & 0xC0) == 64) {
            this._context.addSelectedObjects(tdkViewGeographicObjectGIDSet);
            _logger.debug((Object)"shift pressed");
        } else if ((n & 0xC0) == 128) {
            TdkViewGeographicObjectGIDSet tdkViewGeographicObjectGIDSet2 = new TdkViewGeographicObjectGIDSet(tdkMapDisplay.getView());
            this._context.getSelectedObjects().setIntersection(tdkViewGeographicObjectGIDSet, tdkViewGeographicObjectGIDSet2);
            this._context.addSelectedObjects(tdkViewGeographicObjectGIDSet);
            this._context.removeSelectedObjects(tdkViewGeographicObjectGIDSet2);
            _logger.debug((Object)"ctrl pressed");
        } else {
            this._context.setSelectedObjects(tdkViewGeographicObjectGIDSet);
        }
    }

    protected MultiPolygon boxToMultiPolygon(Envelope envelope) {
        if (envelope == null || envelope.isNull()) {
            return null;
        }
        GeometryFactory geometryFactory = new GeometryFactory();
        Coordinate coordinate = new Coordinate(envelope.getMinX(), envelope.getMinY());
        Coordinate coordinate2 = new Coordinate(envelope.getMaxX(), envelope.getMinY());
        Coordinate coordinate3 = new Coordinate(envelope.getMaxX(), envelope.getMaxY());
        Coordinate coordinate4 = new Coordinate(envelope.getMinX(), envelope.getMaxY());
        Coordinate coordinate5 = new Coordinate(envelope.getMinX(), envelope.getMinY());
        Coordinate[] coordinateArray = new Coordinate[]{coordinate, coordinate2, coordinate3, coordinate4, coordinate5};
        LinearRing linearRing = geometryFactory.createLinearRing(coordinateArray);
        Polygon polygon = geometryFactory.createPolygon(linearRing, null);
        Polygon[] polygonArray = new Polygon[]{polygon};
        MultiPolygon multiPolygon = geometryFactory.createMultiPolygon(polygonArray);
        return multiPolygon;
    }
}

