/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.map.tool;

import com.vividsolutions.jts.geom.Coordinate;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.desktop.components.map.TdkMapDisplay;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkInteractor;

public class TdkPointInteractor
extends TdkInteractor {
    private static Logger _logger = Logger.getLogger(TdkPointInteractor.class);
    protected Coordinate _coord;
    protected boolean _drawFeedback;

    TdkPointInteractor(TdkMapDisplay tdkMapDisplay) {
        this(tdkMapDisplay, false);
    }

    TdkPointInteractor(TdkMapDisplay tdkMapDisplay, boolean bl) {
        super(tdkMapDisplay);
        this.setDrawFeedback(bl);
    }

    public void setDrawFeedback(boolean bl) {
        this._drawFeedback = bl;
    }

    public boolean getDrawFeedback() {
        return this._drawFeedback;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.changeCoord(this.getWindowCoord(mouseEvent), mouseEvent.getModifiersEx());
    }

    protected void changeCoord(Coordinate coordinate, int n) {
        this.draw();
        this._coord = coordinate;
        this.dispatchCoord(this._coord, n);
        this.draw();
    }

    @Override
    public void reset() {
        this._coord = null;
    }

    public void draw() {
        if (!this._drawFeedback || this._coord == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)this._mapDisplay.getGraphics();
        graphics2D.setXORMode(Color.CYAN);
        Coordinate coordinate = new Coordinate();
        this._mapDisplay.window2viewport(this._coord, coordinate);
        graphics2D.fillOval((int)coordinate.x, (int)coordinate.y, 4, 4);
    }

    @Override
    public void mapDrawn(boolean bl, Object object) {
        this.draw();
    }
}

