/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.map.tool;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.desktop.components.map.TdkMapDisplay;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkInteractor;

public class TdkPolyLineInteractor
extends TdkInteractor {
    private static Logger _logger = Logger.getLogger(TdkPolyLineInteractor.class);
    protected Coordinate _currentPoint;
    protected CoordinateList _pointsList = new CoordinateList();
    protected boolean _isEditing = false;
    protected boolean _isValid = false;
    protected BasicStroke _lineStyle = new BasicStroke(1.0f);
    private final int POINT_LENTH = 4;

    public TdkPolyLineInteractor(TdkMapDisplay tdkMapDisplay) {
        super(tdkMapDisplay);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Coordinate coordinate = this.getWindowCoord(mouseEvent);
        if (coordinate == null) {
            return;
        }
        if (mouseEvent.getButton() == 1) {
            this.draw();
            if (!this._isEditing) {
                this._pointsList.add(coordinate, false);
                this._currentPoint = null;
                this.draw();
            } else if (this._currentPoint != null) {
                this._isEditing = false;
                this._pointsList.add(this._currentPoint, false);
                this._currentPoint = null;
                this.draw();
            }
        } else {
            this.draw();
            this._pointsList.add(coordinate, false);
            this.reset();
        }
        this.fire(mouseEvent.getModifiersEx());
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this._isEditing = true;
        this.draw();
        this._currentPoint = this.getWindowCoord(mouseEvent);
        if (this._pointsList.size() == 0) {
            this._pointsList.add(this._currentPoint, false);
        }
        this.draw();
        this.fire(mouseEvent.getModifiersEx());
    }

    private void fire(int n) {
        GeometryFactory geometryFactory = new GeometryFactory();
        LineString lineString = null;
        CoordinateList coordinateList = this._pointsList;
        if (this._currentPoint != null) {
            coordinateList = new CoordinateList();
            for (int i = 0; i < this._pointsList.size(); ++i) {
                coordinateList.add(this._pointsList.getCoordinate(i), false);
            }
            coordinateList.add(this._currentPoint, false);
        }
        if (coordinateList.size() > 1) {
            lineString = geometryFactory.createLineString(coordinateList.toCoordinateArray());
        }
        this.dispatchLineString(lineString, n);
    }

    @Override
    public void reset() {
        this._pointsList.clear();
        this._currentPoint = null;
        this._isEditing = false;
        this._isValid = false;
    }

    public void draw() {
        Graphics2D graphics2D = (Graphics2D)this._mapDisplay.getGraphics();
        graphics2D.setXORMode(Color.WHITE);
        graphics2D.setTransform(this._mapDisplay.getWindowTransform());
        this._mapDisplay.setStrokeForWindow(graphics2D, this._lineStyle);
        if (this._pointsList.size() > 0) {
            Line2D.Double double_;
            Object object;
            int n;
            Coordinate coordinate = this._pointsList.getCoordinate(0);
            if (this._pointsList.size() > 1) {
                for (n = 1; n < this._pointsList.size(); ++n) {
                    object = this._pointsList.getCoordinate(n);
                    double_ = new Line2D.Double(coordinate.x, coordinate.y, object.x, object.y);
                    graphics2D.draw(double_);
                    coordinate = object;
                }
            }
            if (this._currentPoint != null) {
                Coordinate coordinate2 = this._pointsList.getCoordinate(this._pointsList.size() - 1);
                object = new Line2D.Double(coordinate2.x, coordinate2.y, this._currentPoint.x, this._currentPoint.y);
                graphics2D.draw((Shape)object);
            }
            graphics2D.setXORMode(Color.CYAN);
            graphics2D.setTransform(this._mapDisplay.getViewportTransform());
            this._mapDisplay.setStrokeForViewport(graphics2D, this._lineStyle);
            for (n = 0; n < this._pointsList.size(); ++n) {
                object = this._pointsList.getCoordinate(n);
                double_ = new Coordinate();
                this._mapDisplay.window2viewport((Coordinate)object, (Coordinate)double_);
                Rectangle2D.Double double_2 = new Rectangle2D.Double(((Coordinate)double_).x - 2.0, ((Coordinate)double_).y - 2.0, 4.0, 4.0);
                graphics2D.fill(double_2);
            }
        }
    }

    @Override
    public void mapDrawn(boolean bl, Object object) {
        this.draw();
    }

    public void setLineStyle(BasicStroke basicStroke) {
        this._lineStyle = basicStroke;
    }
}

