/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.map.tool;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.desktop.components.map.TdkMapDisplay;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkInteractor;

public class TdkPolygonInteractor
extends TdkInteractor {
    private static Logger _logger = Logger.getLogger(TdkPolygonInteractor.class);
    protected Coordinate _currentPoint;
    protected CoordinateList _vertexList = new CoordinateList();
    protected boolean _isEditing = false;
    protected boolean _isValid = false;
    protected BasicStroke _polygonStyle = new BasicStroke(1.0f);

    public TdkPolygonInteractor(TdkMapDisplay tdkMapDisplay) {
        super(tdkMapDisplay);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this._isEditing = true;
        if (this._vertexList.size() == 0) {
            this._vertexList.add(this.getWindowCoord(mouseEvent), false);
        } else {
            this.draw();
        }
        this._currentPoint = this.getWindowCoord(mouseEvent);
        this.draw();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this._isEditing = true;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Coordinate coordinate = this.getWindowCoord(mouseEvent);
        if (coordinate == null) {
            return;
        }
        if (mouseEvent.getButton() == 1) {
            if (!this._isValid) {
                this._vertexList.add(coordinate, false);
                this._currentPoint = coordinate;
                this._isValid = true;
            }
            if (this._isEditing) {
                this.draw();
            }
            this._vertexList.add(coordinate, false);
            this._currentPoint = null;
            this._isEditing = true;
            if (this._vertexList.size() >= 3) {
                CoordinateList coordinateList = (CoordinateList)this._vertexList.clone();
                coordinateList.closeRing();
                GeometryFactory geometryFactory = new GeometryFactory();
                LinearRing linearRing = geometryFactory.createLinearRing(coordinateList.toCoordinateArray());
                Polygon polygon = geometryFactory.createPolygon(linearRing, null);
                this.dispatchPolygon(polygon, mouseEvent.getModifiersEx());
            }
            this.draw();
            return;
        }
        if (!this._isEditing) {
            return;
        }
        CoordinateList coordinateList = (CoordinateList)this._vertexList.clone();
        coordinateList.closeRing();
        GeometryFactory geometryFactory = new GeometryFactory();
        LinearRing linearRing = geometryFactory.createLinearRing(coordinateList.toCoordinateArray());
        Polygon polygon = geometryFactory.createPolygon(linearRing, null);
        this.dispatchPolygon(polygon, mouseEvent.getModifiersEx());
        this.draw();
        this.reset();
    }

    @Override
    public void reset() {
        this._vertexList.clear();
        this._currentPoint = null;
        this._isEditing = false;
        this._isValid = false;
    }

    public void draw() {
        Graphics2D graphics2D = (Graphics2D)this._mapDisplay.getGraphics();
        GeneralPath generalPath = new GeneralPath();
        generalPath.reset();
        graphics2D.setColor(Color.DARK_GRAY);
        graphics2D.setXORMode(Color.BLACK);
        graphics2D.setTransform(this._mapDisplay.getWindowTransform());
        this._mapDisplay.setStrokeForWindow(graphics2D, this._polygonStyle);
        boolean bl = true;
        for (int i = 0; i < this._vertexList.size(); ++i) {
            Coordinate coordinate = this._vertexList.getCoordinate(i);
            if (bl) {
                generalPath.moveTo((float)coordinate.x, (float)coordinate.y);
                bl = false;
                continue;
            }
            generalPath.lineTo((float)coordinate.x, (float)coordinate.y);
        }
        if (this._currentPoint != null) {
            generalPath.lineTo((float)this._currentPoint.x, (float)this._currentPoint.y);
        }
        generalPath.closePath();
        graphics2D.draw(generalPath);
        graphics2D.fill(generalPath);
    }

    public void setRectStyle(BasicStroke basicStroke) {
        this._polygonStyle = basicStroke;
    }
}

