/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.map.tool;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.desktop.components.map.TdkMapDisplay;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkInteractor;

public class TdkRectInteractor
extends TdkInteractor {
    private static Logger _logger = Logger.getLogger(TdkRectInteractor.class);
    protected Envelope _rect = new Envelope();
    protected Coordinate _first = new Coordinate();
    protected boolean _isDragged = false;
    protected BasicStroke _rectStyle = new BasicStroke(1.0f);

    public TdkRectInteractor(TdkMapDisplay tdkMapDisplay) {
        super(tdkMapDisplay);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() != 1) {
            return;
        }
        this._isDragged = true;
        this._first = this.getWindowCoord(mouseEvent);
        this._rect.init(this._first.x, this._first.x, this._first.y, this._first.y);
        this.draw();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this._isDragged) {
            return;
        }
        this.draw();
        Coordinate coordinate = this.getWindowCoord(mouseEvent);
        this._rect.init(this._first, coordinate);
        this.draw();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() != 1) {
            return;
        }
        if (mouseEvent.getClickCount() == 1) {
            this.dispatchCoord(this.getWindowCoord(mouseEvent), mouseEvent.getModifiersEx());
            this.reset();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this._isDragged) {
            return;
        }
        this.draw();
        Coordinate coordinate = this.getWindowCoord(mouseEvent);
        this._rect.init(this._first, coordinate);
        double d = 0.001;
        if (this._rect.getWidth() > d && this._rect.getHeight() > d) {
            this.dispatchBox(this._rect, mouseEvent.getModifiersEx());
        }
        this.reset();
    }

    @Override
    public void reset() {
        this._rect.init(-1.0, -1.0, -1.0, -1.0);
        this._first.x = -1.0;
        this._first.y = -1.0;
        this._isDragged = false;
    }

    public void draw() {
        if (this._rect.getWidth() == 0.0 || this._rect.getHeight() == 0.0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)this._mapDisplay.getGraphics();
        graphics2D.setXORMode(Color.WHITE);
        graphics2D.setTransform(this._mapDisplay.getWindowTransform());
        Rectangle2D.Double double_ = new Rectangle2D.Double(this._rect.getMinX(), this._rect.getMinY(), this._rect.getWidth(), this._rect.getHeight());
        this._mapDisplay.setStrokeForWindow(graphics2D, this._rectStyle);
        graphics2D.draw(double_);
    }

    public void setRectStyle(BasicStroke basicStroke) {
        this._rectStyle = basicStroke;
    }

    public Envelope getCurrentRect() {
        return new Envelope(this._rect);
    }
}

