/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.map.tool;

import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import org.tecgraf.jtdk.core.swig.IntVector;
import org.tecgraf.jtdk.core.swig.TdkGeographicObjectGID;
import org.tecgraf.jtdk.core.swig.TdkLayerGID;
import org.tecgraf.jtdk.core.swig.TdkSetup;
import org.tecgraf.jtdk.core.swig.TdkThemeGeographicObjectGIDSet;
import org.tecgraf.jtdk.core.swig.TdkThemeGeographicObjectGIDSetIterator;
import org.tecgraf.jtdk.core.swig.TdkViewGeographicObjectGIDSet;
import org.tecgraf.jtdk.desktop.components.TdkComponentsI18n;
import org.tecgraf.jtdk.desktop.components.TdkObjectSelectionContext;
import org.tecgraf.jtdk.desktop.components.map.TdkMapDisplay;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkSimpleTool;

public class TdkRemoveSelectedFromLayerTool
extends TdkSimpleTool {
    private TdkObjectSelectionContext _context;
    private TdkLayerGID _layerGID;
    public static final String BTN_REMOVE_SELETED = "remove_selected";

    public TdkRemoveSelectedFromLayerTool(TdkMapDisplay tdkMapDisplay, TdkObjectSelectionContext tdkObjectSelectionContext, TdkLayerGID tdkLayerGID) {
        this(tdkMapDisplay, tdkObjectSelectionContext);
        this.setLayerGID(tdkLayerGID);
    }

    public TdkRemoveSelectedFromLayerTool(TdkMapDisplay tdkMapDisplay, TdkObjectSelectionContext tdkObjectSelectionContext) {
        this.setMapDisplay(tdkMapDisplay);
        this._context = tdkObjectSelectionContext;
        this.setIcon(new ImageIcon(this.getClass().getResource("/org/tecgraf/jtdk/desktop/components/icons/delete.PNG")));
        this.setBorder(BorderFactory.createBevelBorder(0));
        this.setToolTipText(TdkComponentsI18n.getString("NAV_TOOL_BAR_REMOVE_SELECTED_TIP"));
    }

    public void setLayerGID(TdkLayerGID tdkLayerGID) {
        this._layerGID = tdkLayerGID;
    }

    public void removeSelectedObjectsFromLayer() {
        TdkViewGeographicObjectGIDSet tdkViewGeographicObjectGIDSet;
        if (this._context != null && this._layerGID != null && (tdkViewGeographicObjectGIDSet = this._context.getSelectedObjects()).size() != 0) {
            IntVector intVector = tdkViewGeographicObjectGIDSet.getThemeIds();
            int n = 0;
            while ((long)n < intVector.size()) {
                TdkThemeGeographicObjectGIDSet tdkThemeGeographicObjectGIDSet = tdkViewGeographicObjectGIDSet.getTdkThemeGeographicObjectGIDSet(intVector.get(n));
                TdkThemeGeographicObjectGIDSetIterator tdkThemeGeographicObjectGIDSetIterator = tdkThemeGeographicObjectGIDSet.getIterator();
                while (tdkThemeGeographicObjectGIDSetIterator.hasNext()) {
                    TdkGeographicObjectGID tdkGeographicObjectGID = tdkThemeGeographicObjectGIDSetIterator.next();
                    if (!this._layerGID.getDBKey().equals(tdkThemeGeographicObjectGIDSet.getThemeDBKey()) || this._layerGID.getId() != tdkGeographicObjectGID.getLayerId()) continue;
                    TdkSetup.getPersistenceService().removeGeographicObject(tdkGeographicObjectGID);
                }
                ++n;
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.removeSelectedObjectsFromLayer();
        this.getMapDisplay().redraw();
    }
}

