/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.map.tool;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.tecgraf.jtdk.desktop.components.TdkComponentsI18n;

public class TdkRulerDialog
extends JDialog {
    private static final long serialVersionUID = -1028873491809031799L;
    private ActionListener _finishListener = null;
    private JButton okBtn_;
    private JTextField totalDistanceTxtFld_;
    private JTextField segmentDistanceTxtFld_;
    private JTextField azimuthTxtFld_;
    private static TdkRulerDialog instance_ = null;

    public TdkRulerDialog(Frame frame, ActionListener actionListener) {
        super(frame);
        this.dialogInit();
        this.initComponents();
        this.createListeners();
        this.createButtonListeners();
        this._finishListener = actionListener;
    }

    @Override
    protected void dialogInit() {
        super.dialogInit();
        JLayeredPane jLayeredPane = this.getLayeredPane();
        jLayeredPane.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "close-it");
        jLayeredPane.getActionMap().put("close-it", new AbstractAction(){
            private static final long serialVersionUID = -981293722133215719L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() instanceof JLayeredPane && TdkRulerDialog.this._finishListener != null) {
                    TdkRulerDialog.this._finishListener.actionPerformed(null);
                    TdkRulerDialog.this.dispose();
                    TdkRulerDialog.this.hideDialog();
                }
            }
        });
    }

    public void showDialog() {
        this.setDistance(0.0);
        this.setTotalDistance(0.0);
        this.setAzimuth(0.0);
        this.setVisible(true);
    }

    public void hideDialog() {
        this.setVisible(false);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    public String getId() {
        return Long.toString(-1028873491809031799L);
    }

    public void setDistance(double d) {
        this.segmentDistanceTxtFld_.setText(String.valueOf(d));
    }

    public void setTotalDistance(double d) {
        this.totalDistanceTxtFld_.setText(String.valueOf(d));
    }

    public void setAzimuth(double d) {
        this.azimuthTxtFld_.setText(String.valueOf(d));
    }

    private void initComponents() {
        this.setTitle(TdkComponentsI18n.getString("NAV_TOOL_BAR_RULER_DLG_TITLE"));
        this.setDefaultCloseOperation(2);
        this.setResizable(true);
        this.setSize(170, 245);
        this.setModal(false);
        Dimension dimension = this.getToolkit().getScreenSize();
        this.setLocation(dimension.width / 2 - this.getWidth() / 2, dimension.height / 2 - this.getHeight() / 2);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(this.createBodyPanel());
        this.getContentPane().add(this.createBottomPanel());
    }

    private JPanel createBodyPanel() {
        this.totalDistanceTxtFld_ = new JTextField(15);
        this.totalDistanceTxtFld_.setToolTipText(TdkComponentsI18n.getString("NAV_TOOL_BAR_RULER_DLG_TOTAL_TIP"));
        this.totalDistanceTxtFld_.setEditable(false);
        JLabel jLabel = new JLabel(TdkComponentsI18n.getString("NAV_TOOL_BAR_RULER_DLG_TOTAL_LBL"));
        jLabel.setLabelFor(this.totalDistanceTxtFld_);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new EmptyBorder(5, 8, 0, 8));
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 100.0, 100.0, 11, 2, new Insets(0, 0, 3, 0), 0, 0);
        jPanel.add((Component)this.createSegmentPanel(), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this.totalDistanceTxtFld_, gridBagConstraints);
        return jPanel;
    }

    private JPanel createSegmentPanel() {
        this.segmentDistanceTxtFld_ = new JTextField(15);
        this.segmentDistanceTxtFld_.setToolTipText(TdkComponentsI18n.getString("NAV_TOOL_BAR_RULER_DLG_SEG_TIP"));
        this.segmentDistanceTxtFld_.setEditable(false);
        JLabel jLabel = new JLabel(TdkComponentsI18n.getString("NAV_TOOL_BAR_RULER_DLG_SEG_LBL"));
        jLabel.setLabelFor(this.segmentDistanceTxtFld_);
        this.azimuthTxtFld_ = new JTextField(15);
        this.azimuthTxtFld_.setToolTipText(TdkComponentsI18n.getString("NAV_TOOL_BAR_RULER_DLG_SEG_LBL"));
        this.azimuthTxtFld_.setEditable(false);
        JLabel jLabel2 = new JLabel(TdkComponentsI18n.getString("NAV_TOOL_BAR_RULER_DLG_AZM_LBL"));
        jLabel2.setLabelFor(this.segmentDistanceTxtFld_);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(TdkComponentsI18n.getString("NAV_TOOL_BAR_RULER_DLG_SEG_TEXT")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 100.0, 0.0, 11, 2, new Insets(0, 5, 3, 5), 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.segmentDistanceTxtFld_, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        jPanel.add((Component)this.azimuthTxtFld_, gridBagConstraints);
        return jPanel;
    }

    private JPanel createBottomPanel() {
        this.okBtn_ = new JButton(TdkComponentsI18n.getString("DLG_BTN_OK"));
        this.okBtn_.setMnemonic(TdkComponentsI18n.getString("DLG_BTN_OK_MNEMONIC").charAt(0));
        this.okBtn_.setPreferredSize(new Dimension(75, 23));
        this.getRootPane().setDefaultButton(this.okBtn_);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new EmptyBorder(1, 1, 1, 1));
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 3, 1, 100.0, 0.0, 13, 2, new Insets(8, 0, 0, 0), 0, 0);
        jPanel.add((Component)new JSeparator(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(8, 3, 8, 8);
        jPanel.add((Component)this.okBtn_, gridBagConstraints);
        return jPanel;
    }

    private void createListeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (windowEvent.getSource() instanceof TdkRulerDialog && TdkRulerDialog.this._finishListener != null) {
                    TdkRulerDialog.this._finishListener.actionPerformed(null);
                    TdkRulerDialog.this.dispose();
                    TdkRulerDialog.this.hideDialog();
                }
            }
        });
    }

    private void createButtonListeners() {
        this.okBtn_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() instanceof JButton && TdkRulerDialog.this._finishListener != null) {
                    TdkRulerDialog.this._finishListener.actionPerformed(null);
                    TdkRulerDialog.this.dispose();
                    TdkRulerDialog.this.hideDialog();
                }
            }
        });
    }
}

