/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.map.tool;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LineString;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.core.TdkJavaProcessingService;
import org.tecgraf.jtdk.core.algorithms.TdkCalcOrthodromicDistance;
import org.tecgraf.jtdk.core.exceptions.TdkInvalidParamValueException;
import org.tecgraf.jtdk.core.swig.TdkSetup;
import org.tecgraf.jtdk.core.swig.TdkView;
import org.tecgraf.jtdk.core.swig.TeProjection;
import org.tecgraf.jtdk.desktop.components.TdkComponentsI18n;
import org.tecgraf.jtdk.desktop.components.map.TdkMapDisplay;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkInteractorAdapter;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkInteractorTool;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkPolyLineInteractor;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkRulerDialog;
import org.tecgraf.jtdk.desktop.components.util.TdkDialogUtil;

public class TdkRulerTool
extends TdkInteractorTool {
    private Logger _logger = Logger.getLogger(TdkRulerTool.class);
    private Cursor _cursor;
    public static final String CURSOR_NAME = "zoom_ruler";
    public static final String BTN_RULER = "ruler";
    TdkRulerDialog _dialog = null;

    public TdkRulerTool(TdkMapDisplay tdkMapDisplay) {
        this.setMapDisplay(tdkMapDisplay);
        this.setInteractor(new TdkPolyLineInteractor(this.getMapDisplay()));
        this.setInteractorListener(new MyActionHandler());
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.getImage(this.getClass().getResource("/org/tecgraf/jtdk/desktop/components/icons/ruler_cursor.gif"));
        this._cursor = toolkit.createCustomCursor(image, new Point(10, 10), CURSOR_NAME);
        this.setName(BTN_RULER);
        this.setIcon(new ImageIcon(this.getClass().getResource("/org/tecgraf/jtdk/desktop/components/icons/ruler.gif")));
        this.setBorder(BorderFactory.createBevelBorder(0));
        this.setToolTipText(TdkComponentsI18n.getString("NAV_TOOL_BAR_RULER_TIP"));
        this.getInteractor().addInteractorListener(this.getInteractorListener());
        this._logger.debug((Object)"created");
    }

    @Override
    public void start() {
        this.getInteractor().setDefaultCursor(this._cursor);
        TdkPolyLineInteractor tdkPolyLineInteractor = (TdkPolyLineInteractor)this.getInteractor();
        tdkPolyLineInteractor.reset();
        this._dialog = new TdkRulerDialog(TdkDialogUtil.getFrameParent((Component)((Object)this.getMapDisplay())), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TdkRulerTool.this.finish();
            }
        });
        TdkDialogUtil.centralize(this._dialog);
        this._dialog.setModal(false);
        this._dialog.showDialog();
        this._logger.debug((Object)"started");
    }

    @Override
    public void finish() {
        TdkPolyLineInteractor tdkPolyLineInteractor = (TdkPolyLineInteractor)this.getInteractor();
        tdkPolyLineInteractor.reset();
        if (this._dialog != null) {
            this._dialog.setVisible(false);
        }
        this._logger.debug((Object)"finished");
    }

    private class MyActionHandler
    extends TdkInteractorAdapter {
        private MyActionHandler() {
        }

        @Override
        public void handleLineString(TdkMapDisplay tdkMapDisplay, LineString lineString, int n) {
            if (!TdkRulerTool.this._dialog.isVisible()) {
                TdkRulerTool.this._dialog.setVisible(true);
            }
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            if (lineString != null && lineString.getCoordinates().length > 1 && TdkRulerTool.this.getMapDisplay().getView() != null) {
                TdkJavaProcessingService tdkJavaProcessingService = new TdkJavaProcessingService();
                TdkView tdkView = TdkSetup.getPersistenceService().getView(TdkRulerTool.this.getMapDisplay().getView());
                TeProjection teProjection = tdkView.getProjection();
                double d4 = lineString.getCoordinates()[lineString.getCoordinates().length - 2].x;
                double d5 = lineString.getCoordinates()[lineString.getCoordinates().length - 2].y;
                double d6 = lineString.getCoordinates()[lineString.getCoordinates().length - 1].x;
                double d7 = lineString.getCoordinates()[lineString.getCoordinates().length - 1].y;
                d = tdkJavaProcessingService.calcAzimuth(d4, d5, d6, d7);
                try {
                    d2 = TdkCalcOrthodromicDistance.calcDistanceInMeters((Coordinate)new Coordinate(d4, d5), (Coordinate)new Coordinate(d6, d7), (TeProjection)teProjection);
                }
                catch (TdkInvalidParamValueException tdkInvalidParamValueException) {
                    TdkRulerTool.this._logger.debug((Object)"invalid values on distance tool");
                    return;
                }
                Coordinate coordinate = lineString.getCoordinates()[0];
                for (int i = 1; i < lineString.getCoordinates().length; ++i) {
                    Coordinate coordinate2 = lineString.getCoordinates()[i];
                    try {
                        d3 += TdkCalcOrthodromicDistance.calcDistanceInMeters((Coordinate)coordinate, (Coordinate)coordinate2, (TeProjection)teProjection);
                    }
                    catch (TdkInvalidParamValueException tdkInvalidParamValueException) {
                        TdkRulerTool.this._logger.debug((Object)"invalid values on distance tool");
                        return;
                    }
                    coordinate = coordinate2;
                }
                TdkRulerTool.this._logger.debug((Object)("point added to path, total distance: " + d3));
            }
            TdkRulerTool.this._dialog.setAzimuth(d);
            TdkRulerTool.this._dialog.setDistance(d2);
            TdkRulerTool.this._dialog.setTotalDistance(d3);
        }
    }
}

