/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.map.tool;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.MultiPolygon;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import org.tecgraf.jtdk.core.swig.IntVector;
import org.tecgraf.jtdk.core.swig.TdkGeographicObjectGID;
import org.tecgraf.jtdk.core.swig.TdkSetup;
import org.tecgraf.jtdk.core.swig.TdkThemeGeographicObjectGIDSet;
import org.tecgraf.jtdk.core.swig.TdkThemeGeographicObjectGIDSetIterator;
import org.tecgraf.jtdk.core.swig.TdkViewGeographicObjectGIDSet;
import org.tecgraf.jtdk.desktop.components.TdkObjectSelectionContext;
import org.tecgraf.jtdk.desktop.components.map.TdkMapDisplay;
import org.tecgraf.jtdk.desktop.components.map.TdkMapDisplayAdapter;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkPickObjectsActionHandler;

public class TdkToolTipHandler
extends TdkPickObjectsActionHandler {
    private BufferedImage _snapshot;
    private TdkMapDisplay _display;
    private final int HORIZONTAL_ENLARGE = 10;
    private Rectangle _lastTooltipRectangle = null;

    public TdkToolTipHandler(TdkObjectSelectionContext tdkObjectSelectionContext, TdkMapDisplay tdkMapDisplay) {
        super(tdkObjectSelectionContext);
        this._display = tdkMapDisplay;
        if (this._display.isConnectedToNativeCanvas()) {
            this._snapshot = tdkMapDisplay.getSnapshot(true);
        }
        this._display.addMapDisplayListener(new MyMapDisplayListener());
    }

    @Override
    public void handleBox(TdkMapDisplay tdkMapDisplay, Envelope envelope, int n) {
    }

    @Override
    public void handleCoord(TdkMapDisplay tdkMapDisplay, Coordinate coordinate, int n) {
        this.drawSnapshot();
        if (coordinate == null) {
            return;
        }
        Coordinate coordinate2 = new Coordinate();
        tdkMapDisplay.viewport2window(coordinate, coordinate2);
        double d = 3.0 / tdkMapDisplay.getPixelSize();
        Envelope envelope = new Envelope(coordinate2.x - d, coordinate2.x + d, coordinate2.y - d, coordinate2.y + d);
        MultiPolygon multiPolygon = this.boxToMultiPolygon(envelope);
        String string = TdkSetup.getGraphicalService().pickTooltipOnTop(tdkMapDisplay.getView(), tdkMapDisplay.getScale(), multiPolygon);
        if (string.length() > 0) {
            this.drawToolTip(string, Double.valueOf(coordinate.x).intValue(), Double.valueOf(coordinate.y).intValue());
        }
    }

    private void drawSnapshot() {
        if (this._snapshot == null && this._display.isConnectedToNativeCanvas()) {
            this._snapshot = this._display.getSnapshot(true);
            this._lastTooltipRectangle = null;
        }
        if (this._snapshot != null) {
            if (this._display.getGraphics() == null) {
                return;
            }
            if (this._lastTooltipRectangle == null) {
                this._display.getGraphics().drawImage(this._snapshot, 0, 0, null);
            } else {
                this._display.getGraphics().drawImage(this._snapshot, this._lastTooltipRectangle.x, this._lastTooltipRectangle.y, this._lastTooltipRectangle.x + this._lastTooltipRectangle.width + 1, this._lastTooltipRectangle.y + this._lastTooltipRectangle.height + 1, this._lastTooltipRectangle.x, this._lastTooltipRectangle.y, this._lastTooltipRectangle.x + this._lastTooltipRectangle.width + 1, this._lastTooltipRectangle.y + this._lastTooltipRectangle.height + 1, null);
            }
        }
    }

    private void drawToolTip(String string, int n, int n2) {
        FontMetrics fontMetrics = this._display.getFontMetrics(this._display.getFont());
        int n3 = fontMetrics.stringWidth(string) + 10;
        int n4 = fontMetrics.getHeight();
        Color color = this._display.getGraphics().getColor();
        Graphics graphics = this._display.getGraphics();
        Rectangle rectangle = new Rectangle(n + 2, n2 - 12, n3 - 1, n4 - 1);
        graphics.setColor(new Color(255, 255, 220));
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(color);
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.drawString(string, n + 5, n2 - 1);
        this._lastTooltipRectangle = rectangle;
    }

    public Object[] getObjectGid(TdkMapDisplay tdkMapDisplay, Coordinate coordinate) {
        TdkViewGeographicObjectGIDSet tdkViewGeographicObjectGIDSet = this.pickPointer(tdkMapDisplay, coordinate);
        IntVector intVector = tdkViewGeographicObjectGIDSet.getThemeIds();
        int n = 0;
        while ((long)n < intVector.size()) {
            int n2 = intVector.get(n);
            if (n2 >= 0) {
                TdkThemeGeographicObjectGIDSet tdkThemeGeographicObjectGIDSet = tdkViewGeographicObjectGIDSet.getTdkThemeGeographicObjectGIDSet(n2);
                TdkThemeGeographicObjectGIDSetIterator tdkThemeGeographicObjectGIDSetIterator = tdkThemeGeographicObjectGIDSet.getIterator();
                while (tdkThemeGeographicObjectGIDSetIterator.hasNext()) {
                    TdkGeographicObjectGID tdkGeographicObjectGID = tdkThemeGeographicObjectGIDSetIterator.next();
                    if (tdkGeographicObjectGID == null) continue;
                    Object[] objectArray = new Object[]{n2, tdkGeographicObjectGID};
                    return objectArray;
                }
            }
            ++n;
        }
        return null;
    }

    private class MyMapDisplayListener
    extends TdkMapDisplayAdapter {
        private MyMapDisplayListener() {
        }

        @Override
        public void mapDrawn(boolean bl, Object object) {
            this.updateSnapshot(bl);
        }

        private void updateSnapshot(boolean bl) {
            if (!bl) {
                TdkToolTipHandler.this._lastTooltipRectangle = null;
                if (TdkToolTipHandler.this._display.isConnectedToNativeCanvas()) {
                    TdkToolTipHandler.this._snapshot = TdkToolTipHandler.this._display.getSnapshot(true);
                }
            }
        }
    }
}

