/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.treeview;

import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.core.exceptions.TdkDatabaseException;
import org.tecgraf.jtdk.core.exceptions.TdkException;
import org.tecgraf.jtdk.core.exceptions.TdkNullPointerException;
import org.tecgraf.jtdk.core.swig.TdkSetup;
import org.tecgraf.jtdk.core.swig.TdkThemeGID;
import org.tecgraf.jtdk.core.swig.TeGroupingMode;
import org.tecgraf.jtdk.core.swig.TeLegendEntry;
import org.tecgraf.jtdk.desktop.components.TdkComponentsI18n;
import org.tecgraf.jtdk.desktop.components.treeview.TdkCellRenderingParams;
import org.tecgraf.jtdk.desktop.components.treeview.TdkLegendElement;
import org.tecgraf.jtdk.desktop.components.treeview.TdkThemeLegendElement;
import org.tecgraf.jtdk.desktop.components.treeview.TdkTreeView;

public class TdkThematicLegendElement
extends TdkLegendElement {
    private static final int _LEGEND_ICON_HIEGHT = 16;
    private static final int _LEGEND_ICON_WIDTH = 16;
    TeLegendEntry _legend;
    TeGroupingMode _groupingMode;
    int _rep;
    private static Logger _logger = Logger.getLogger(TdkThematicLegendElement.class);

    public TdkThematicLegendElement(TdkTreeView tdkTreeView, TeLegendEntry teLegendEntry, TeGroupingMode teGroupingMode, int n) {
        this(tdkTreeView, true, true, teLegendEntry, teGroupingMode, n);
    }

    public TdkThematicLegendElement(TdkTreeView tdkTreeView, boolean bl, boolean bl2, TeLegendEntry teLegendEntry, TeGroupingMode teGroupingMode, int n) {
        super(tdkTreeView, bl, bl2);
        this._legend = teLegendEntry;
        this._groupingMode = teGroupingMode;
        this._rep = n;
        this.buildLegendRenderParams();
        this.buildPopupMenu();
    }

    public TeLegendEntry getLegendEntry() {
        return this._legend;
    }

    public TdkThemeGID getOwnerTheme() {
        TreeNode treeNode = this.getParent();
        if (!(treeNode instanceof TdkThemeLegendElement)) {
            return null;
        }
        TdkThemeLegendElement tdkThemeLegendElement = (TdkThemeLegendElement)treeNode;
        return tdkThemeLegendElement.getGID();
    }

    protected void buildPopupMenu() {
        this.addMenuItem(TdkComponentsI18n.getString("TREE_POP_MENU_THEME_STYLE"), "edit_thematic_style_command");
    }

    protected void buildLegendRenderParams() {
        TdkCellRenderingParams tdkCellRenderingParams = new TdkCellRenderingParams();
        tdkCellRenderingParams.setHasCheckbox(false);
        tdkCellRenderingParams.setSpaceBefore(4);
        tdkCellRenderingParams.setCaption(this._legend.getLabel());
        BufferedImage bufferedImage = new BufferedImage(16, 16, 1);
        try {
            TdkSetup.getGraphicalService().getSampleImage(this._legend, this._rep, bufferedImage);
        }
        catch (TdkNullPointerException tdkNullPointerException) {
            _logger.error((Object)tdkNullPointerException.getMessage());
        }
        catch (TdkDatabaseException tdkDatabaseException) {
            _logger.error((Object)tdkDatabaseException.getMessage());
        }
        catch (TdkException tdkException) {
            _logger.error((Object)tdkException.getMessage());
        }
        ImageIcon imageIcon = new ImageIcon(bufferedImage);
        tdkCellRenderingParams.setIcon(imageIcon);
        this.setRenderParams(tdkCellRenderingParams);
    }
}

