/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.treeview;

import java.awt.Frame;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultTreeModel;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.core.TdkJVipeSetup;
import org.tecgraf.jtdk.core.exceptions.TdkDatabaseException;
import org.tecgraf.jtdk.core.exceptions.TdkException;
import org.tecgraf.jtdk.core.swig.TdkSetup;
import org.tecgraf.jtdk.core.swig.TdkThemeGID;
import org.tecgraf.jtdk.core.swig.TdkThemeGroup;
import org.tecgraf.jtdk.core.swig.TdkThemeGroupGID;
import org.tecgraf.jtdk.core.swig.TdkViewNodeGID;
import org.tecgraf.jtdk.core.swig.TdkViewNodeGIDVector;
import org.tecgraf.jtdk.desktop.components.TdkComponentsI18n;
import org.tecgraf.jtdk.desktop.components.treeview.TdkCellRenderingParams;
import org.tecgraf.jtdk.desktop.components.treeview.TdkDummyLegendElement;
import org.tecgraf.jtdk.desktop.components.treeview.TdkLegendElement;
import org.tecgraf.jtdk.desktop.components.treeview.TdkLegendElementFactory;
import org.tecgraf.jtdk.desktop.components.treeview.TdkThemeLegendElement;
import org.tecgraf.jtdk.desktop.components.treeview.TdkTreeView;
import org.tecgraf.jtdk.desktop.components.util.TdkDialogUtil;

public class TdkThemeGroupLegendElement
extends TdkLegendElement {
    private static Logger _logger = Logger.getLogger(TdkThemeGroupLegendElement.class);
    protected TdkThemeGroupGID _gid;
    TdkViewNodeGIDVector _viewNodeGIDs;

    public TdkThemeGroupLegendElement(TdkTreeView tdkTreeView, TdkThemeGroupGID tdkThemeGroupGID) {
        this(tdkTreeView, true, true, tdkThemeGroupGID);
    }

    public TdkThemeGroupLegendElement(TdkTreeView tdkTreeView, boolean bl, boolean bl2, TdkThemeGroupGID tdkThemeGroupGID) {
        super(tdkTreeView, bl, bl2);
        this._gid = tdkThemeGroupGID;
        TdkThemeGroup tdkThemeGroup = TdkSetup.getPersistenceService().getThemeGroup(tdkThemeGroupGID);
        this.setRenderParams(new TdkCellRenderingParams());
        super.getRenderParams().setCaption(tdkThemeGroup.getName());
        super.getRenderParams().setCheckboxGrayBackground(true);
        super.getRenderParams().setHasCheckbox(true);
        super.getRenderParams().setIcon(new ImageIcon(this.getClass().getResource("/org/tecgraf/jtdk/desktop/components/icons/folder.png")));
        super.getRenderParams().setOpenIcon(new ImageIcon(this.getClass().getResource("/org/tecgraf/jtdk/desktop/components/icons/folder-open.png")));
        this._viewNodeGIDs = tdkThemeGroup.getViewNodeIdVector();
        this.setAllowsChildren(true);
        if (tdkThemeGroup.getViewNodeIdVector().size() > 0L) {
            this.add(new TdkDummyLegendElement());
        }
        this.buildPopupMenu();
    }

    protected void buildPopupMenu() {
        if (this.isRemovable()) {
            this.getPopupMenu().addSeparator();
            this.addMenuItem(TdkComponentsI18n.getString("TREE_POP_MENU_GROUP_DELETE"), "group_delete_command");
        }
        this.getPopupMenu().setLightWeightPopupEnabled(false);
    }

    public TdkViewNodeGIDVector getViewNodeIds() {
        return this._viewNodeGIDs;
    }

    @Override
    public Vector<TdkLegendElement> makeChildren() {
        TdkLegendElementFactory tdkLegendElementFactory = this._treeView.getFactory();
        if (tdkLegendElementFactory == null) {
            return null;
        }
        Vector<TdkLegendElement> vector = new Vector<TdkLegendElement>();
        TdkThemeGroup tdkThemeGroup = TdkSetup.getPersistenceService().getThemeGroup(this._gid);
        this._viewNodeGIDs = tdkThemeGroup.getViewNodeIdVector();
        int n = 0;
        while ((long)n < this._viewNodeGIDs.size()) {
            TdkThemeGID tdkThemeGID;
            TdkViewNodeGID tdkViewNodeGID = this._viewNodeGIDs.get(n);
            boolean bl = this._treeView.isNodesEditable();
            boolean bl2 = this._treeView.isRemovable();
            if (bl2) {
                bl2 = this.isEditable();
            }
            if (tdkViewNodeGID instanceof TdkThemeGID) {
                tdkThemeGID = (TdkThemeGID)tdkViewNodeGID;
                vector.add(tdkLegendElementFactory.makeThemeElement(this._treeView, bl, bl2, tdkThemeGID));
            } else if (tdkViewNodeGID instanceof TdkThemeGroupGID) {
                tdkThemeGID = (TdkThemeGroupGID)tdkViewNodeGID;
                vector.add(tdkLegendElementFactory.makeThemeGroupElement(this._treeView, bl, bl2, (TdkThemeGroupGID)tdkThemeGID));
            }
            ++n;
        }
        return vector;
    }

    public TdkThemeGroupGID getGID() {
        return this._gid;
    }

    @Override
    public boolean equals(Object object) {
        if (this._gid == null) {
            return super.equals(object);
        }
        if (!(object instanceof TdkThemeGroupLegendElement)) {
            return false;
        }
        TdkThemeGroupGID tdkThemeGroupGID = ((TdkThemeGroupLegendElement)object).getGID();
        if (this._gid.getDBKey() == null) {
            return this._gid.getId() == tdkThemeGroupGID.getId();
        }
        return this._gid.getId() == tdkThemeGroupGID.getId() && this._gid.getDBKey().equals(tdkThemeGroupGID.getDBKey());
    }

    @Override
    public int hashCode() {
        if (this._gid == null) {
            return super.hashCode();
        }
        if (this._gid.getDBKey() == null) {
            return this._gid.getIdStr().hashCode();
        }
        String string = this._gid.getIdStr() + this._gid.getDBKey();
        return string.hashCode();
    }

    @Override
    public TdkCellRenderingParams getRenderParams() {
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < this.getChildren().size(); ++i) {
            TdkLegendElement tdkLegendElement = this.getChildren().get(i);
            if (!(tdkLegendElement instanceof TdkThemeLegendElement) && !(tdkLegendElement instanceof TdkThemeGroupLegendElement)) continue;
            if (!tdkLegendElement.isChecked()) {
                bl = true;
                continue;
            }
            bl2 = true;
        }
        if (!bl2) {
            bl = false;
        }
        super.getRenderParams().setCheckboxGrayBackground(bl);
        return super.getRenderParams();
    }

    @Override
    public boolean isChecked() {
        for (int i = 0; i < this.getChildren().size(); ++i) {
            TdkLegendElement tdkLegendElement = this.getChildren().get(i);
            if (!(tdkLegendElement instanceof TdkThemeLegendElement) && !(tdkLegendElement instanceof TdkThemeGroupLegendElement) || !tdkLegendElement.isChecked()) continue;
            return true;
        }
        return false;
    }

    public void delete() {
        Object object;
        TdkLegendElement tdkLegendElement = (TdkLegendElement)this.getParent();
        Frame frame = TdkDialogUtil.getFrameParent(this._treeView);
        this._treeView.fireRemovedNodeEvent(true, tdkLegendElement.getTreePath(), this);
        boolean bl = false;
        try {
            object = TdkJVipeSetup.getInstance().getActionWorkflowService();
            bl = object.removeThemeGroup(frame, this.getGID());
        }
        catch (TdkDatabaseException tdkDatabaseException) {
            _logger.error((Object)tdkDatabaseException.getMessage());
        }
        catch (TdkException tdkException) {
            _logger.error((Object)tdkException.getMessage());
        }
        if (bl) {
            ((DefaultTreeModel)this._treeView.getModel()).removeNodeFromParent(this);
            if (tdkLegendElement instanceof TdkLegendElement) {
                object = tdkLegendElement;
                ((TdkLegendElement)object).getChildren().remove(this);
            }
            this._treeView.repaint();
            this._treeView.fireRemovedNodeEvent(false, tdkLegendElement.getTreePath(), this);
        }
    }
}

