/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.treeview;

import java.awt.Frame;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultTreeModel;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.core.TdkJVipeSetup;
import org.tecgraf.jtdk.core.exceptions.TdkDatabaseException;
import org.tecgraf.jtdk.core.exceptions.TdkException;
import org.tecgraf.jtdk.core.exceptions.TdkNullPointerException;
import org.tecgraf.jtdk.core.swig.TdkSetup;
import org.tecgraf.jtdk.core.swig.TdkTheme;
import org.tecgraf.jtdk.core.swig.TdkThemeGID;
import org.tecgraf.jtdk.core.swig.TeGroupingMode;
import org.tecgraf.jtdk.core.swig.TeLegendEntryVector;
import org.tecgraf.jtdk.desktop.components.TdkComponentsI18n;
import org.tecgraf.jtdk.desktop.components.treeview.TdkCellRenderingParams;
import org.tecgraf.jtdk.desktop.components.treeview.TdkDummyLegendElement;
import org.tecgraf.jtdk.desktop.components.treeview.TdkLegendElement;
import org.tecgraf.jtdk.desktop.components.treeview.TdkLegendElementFactory;
import org.tecgraf.jtdk.desktop.components.treeview.TdkTreeView;
import org.tecgraf.jtdk.desktop.components.treeview.TdkUpdateThemeEvent;
import org.tecgraf.jtdk.desktop.components.util.TdkDialogUtil;

public class TdkThemeLegendElement
extends TdkLegendElement {
    private static final int _LEGEND_ICON_HIEGHT = 16;
    private static final int _LEGEND_ICON_WIDTH = 16;
    private static Logger _logger = Logger.getLogger(TdkThemeLegendElement.class);
    protected TdkThemeGID _gid;
    protected TeGroupingMode _groupingMode;
    public static final String ACT_CMD_ZOOM_IN = "zoom_in_command";
    public static final String ACT_CMD_ZOOM_OUT = "zoom_out_command";
    public static final String ACT_CMD_ZOOM_RECT = "zoom_rect_command";
    public static final String ACT_CMD_PAN = "pan_command";
    public static final String ACT_CMD_FIT = "fit_command";
    public static final String ACT_CMD_FIT_SELECTED = "fit_selected_command";
    public static final String ACT_CMD_REFRESH = "refresh_command";

    public TdkThemeLegendElement(TdkTreeView tdkTreeView, TdkThemeGID tdkThemeGID) {
        this(tdkTreeView, true, true, tdkThemeGID);
    }

    public TdkThemeLegendElement(TdkTreeView tdkTreeView, boolean bl, boolean bl2, TdkThemeGID tdkThemeGID) {
        super(tdkTreeView, bl, bl2);
        this._gid = tdkThemeGID;
        TdkTheme tdkTheme = TdkSetup.getPersistenceService().getTheme(this._gid);
        this.setRenderParams(new TdkCellRenderingParams());
        this.buildDefaultRenderParams();
        this._groupingMode = tdkTheme.getGroupingMode();
        if (this._groupingMode == TeGroupingMode.TeNoGrouping) {
            this.setAllowsChildren(false);
        } else if (tdkTheme.getLegends().size() > 0L) {
            this.setThematicProperties();
            this.add(new TdkDummyLegendElement());
        } else {
            _logger.error((Object)("invalid thematic state in theme " + tdkTheme.getName()));
        }
        this.buildPopupMenu();
    }

    private void setThematicProperties() {
        this.setAllowsChildren(true);
    }

    public void buildDefaultRenderParams() {
        TdkTheme tdkTheme = TdkSetup.getPersistenceService().getTheme(this._gid);
        if (!tdkTheme.hasRaster()) {
            BufferedImage bufferedImage = new BufferedImage(16, 16, 1);
            int n = tdkTheme.getDefaultLegend().getGroup();
            try {
                TdkSetup.getGraphicalService().getSampleImage(this._gid, n, bufferedImage);
                ImageIcon imageIcon = new ImageIcon(bufferedImage);
                this.getRenderParams().setIcon(imageIcon);
            }
            catch (TdkNullPointerException tdkNullPointerException) {
                _logger.error((Object)tdkNullPointerException.getMessage());
            }
            catch (TdkDatabaseException tdkDatabaseException) {
                _logger.error((Object)tdkDatabaseException.getMessage());
            }
            catch (TdkException tdkException) {
                _logger.error((Object)tdkException.getMessage());
            }
        } else {
            super.getRenderParams().setIcon(new ImageIcon(this.getClass().getResource("/org/tecgraf/jtdk/desktop/components/icons/camera.png")));
        }
        if (tdkTheme.getVisibility() == 3) {
            super.setChecked(true);
        } else {
            super.setChecked(false);
        }
        this.getRenderParams().setCaption(tdkTheme.getName());
        this.getRenderParams().setHasCheckbox(true);
    }

    @Override
    public Object getUserObject() {
        return this.getRenderParams().getCaption();
    }

    @Override
    public void setUserObject(Object object) {
        if (object instanceof String) {
            TdkUpdateThemeEvent tdkUpdateThemeEvent = new TdkUpdateThemeEvent();
            tdkUpdateThemeEvent.setNameChanged(true);
            this._treeView.fireThemeChangeEvent(true, this, tdkUpdateThemeEvent);
            this.getRenderParams().setCaption((String)object);
            TdkTheme tdkTheme = TdkSetup.getPersistenceService().getTheme(this._gid);
            tdkTheme.setName((String)object);
            this._treeView.fireThemeChangeEvent(false, this, tdkUpdateThemeEvent);
            this._treeView.repaint();
        }
    }

    public void changeVisibility(boolean bl) {
        this.changeVisibility(bl, !this.isThemeVisible());
    }

    public boolean isThemeVisible() {
        TdkTheme tdkTheme = TdkSetup.getPersistenceService().getTheme(this._gid);
        return (tdkTheme.getVisibility() & 1) == 1;
    }

    public boolean changeVisibility(boolean bl, boolean bl2) {
        if (this.isThemeVisible() == bl2) {
            return false;
        }
        TdkUpdateThemeEvent tdkUpdateThemeEvent = new TdkUpdateThemeEvent();
        tdkUpdateThemeEvent.setVisibilityChanged(true);
        if (bl) {
            this._treeView.fireThemeChangeEvent(true, this, tdkUpdateThemeEvent);
        }
        TdkTheme tdkTheme = TdkSetup.getPersistenceService().getTheme(this._gid);
        tdkTheme.setVisible(bl2);
        super.setChecked(bl2);
        if (bl) {
            this._treeView.fireThemeChangeEvent(false, this, tdkUpdateThemeEvent);
        }
        return true;
    }

    protected void buildPopupMenu() {
        if (this.isEditable()) {
            this.getPopupMenu().addSeparator();
            this.addMenuItem(TdkComponentsI18n.getString("TREE_POP_MENU_THEME_STYLE"), "theme_style_command");
            this.addMenuItem(TdkComponentsI18n.getString("TREE_POP_MENU_SEL_OBJ_THEME_STYLE"), "sel_obj_theme_style_command");
            this.getPopupMenu().addSeparator();
            this.addMenuItem(TdkComponentsI18n.getString("TREE_POP_MENU_THEMATIC"), "thematic_command");
            this.getPopupMenu().addSeparator();
            this.addMenuItem(TdkComponentsI18n.getString("TREE_POP_MENU_PROPERTIES"), "properties_command");
            this.addMenuItem(TdkComponentsI18n.getString("TREE_POP_MENU_FIX_BOUNDING"), "fix_bounding_command");
        }
        if (this.isRemovable()) {
            this.getPopupMenu().addSeparator();
            this.addMenuItem(TdkComponentsI18n.getString("TREE_POP_MENU_THEME_DELETE"), "theme_delete_command");
        }
        this.getPopupMenu().addSeparator();
        this.addMenuItem(TdkComponentsI18n.getString("TREE_POP_MENU_MOVE_UP"), "move_up_command");
        this.addMenuItem(TdkComponentsI18n.getString("TREE_POP_MENU_MOVE_DOWN"), "move_down_command");
        this.getPopupMenu().setLightWeightPopupEnabled(false);
    }

    public void delete() {
        Object object;
        TdkLegendElement tdkLegendElement = (TdkLegendElement)this.getParent();
        Frame frame = TdkDialogUtil.getFrameParent(this._treeView);
        this._treeView.fireRemovedNodeEvent(true, tdkLegendElement.getTreePath(), this);
        boolean bl = false;
        try {
            object = TdkJVipeSetup.getInstance().getActionWorkflowService();
            bl = object.removeTheme(frame, this.getGID());
        }
        catch (TdkDatabaseException tdkDatabaseException) {
            _logger.error((Object)tdkDatabaseException.getMessage());
        }
        catch (TdkException tdkException) {
            _logger.error((Object)tdkException.getMessage());
        }
        if (bl) {
            ((DefaultTreeModel)this._treeView.getModel()).removeNodeFromParent(this);
            if (tdkLegendElement instanceof TdkLegendElement) {
                object = tdkLegendElement;
                ((TdkLegendElement)object).getChildren().remove(this);
            }
            this._treeView.repaint();
            this._treeView.fireRemovedNodeEvent(false, tdkLegendElement.getTreePath(), this);
        }
    }

    public TdkThemeGID getGID() {
        return this._gid;
    }

    @Override
    public boolean equals(Object object) {
        if (this._gid == null) {
            return super.equals(object);
        }
        if (!(object instanceof TdkThemeLegendElement)) {
            return false;
        }
        TdkThemeGID tdkThemeGID = ((TdkThemeLegendElement)object).getGID();
        if (this._gid.getDBKey() == null) {
            return this._gid.getId() == tdkThemeGID.getId();
        }
        return this._gid.getId() == tdkThemeGID.getId() && this._gid.getDBKey().equals(tdkThemeGID.getDBKey());
    }

    @Override
    public int hashCode() {
        if (this._gid == null) {
            return super.hashCode();
        }
        if (this._gid.getDBKey() == null) {
            return this._gid.getIdStr().hashCode();
        }
        String string = this._gid.getIdStr() + this._gid.getDBKey();
        return string.hashCode();
    }

    @Override
    public Vector<TdkLegendElement> makeChildren() {
        if (this._groupingMode == TeGroupingMode.TeNoGrouping) {
            return null;
        }
        TdkTheme tdkTheme = TdkSetup.getPersistenceService().getTheme(this._gid);
        boolean bl = this._treeView.isNodesEditable();
        boolean bl2 = this._treeView.isRemovable();
        Vector<TdkLegendElement> vector = new Vector<TdkLegendElement>();
        TeLegendEntryVector teLegendEntryVector = tdkTheme.getLegends();
        int n = 0;
        while ((long)n < teLegendEntryVector.size()) {
            int n2 = tdkTheme.getVisibleRepresentation();
            int n3 = 0;
            if ((n2 & 4) != 0) {
                n3 |= 4;
            }
            if ((n2 & 2) != 0) {
                n3 |= 2;
            }
            if ((n2 & 1) != 0) {
                n3 |= 1;
            }
            if ((n2 & 0x80) != 0) {
                n3 |= 0x80;
            }
            vector.add(new TdkLegendElementFactory().makeLegendEntryElement(this._treeView, bl, bl2, teLegendEntryVector.get((long)n), tdkTheme.getGroupingMode(), n3));
            ++n;
        }
        return vector;
    }
}

