/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.treeview;

import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.core.swig.TdkThemeGID;
import org.tecgraf.jtdk.core.swig.TdkThemeGroupGID;
import org.tecgraf.jtdk.core.swig.TdkViewGID;
import org.tecgraf.jtdk.core.swig.TdkViewNodeGID;
import org.tecgraf.jtdk.desktop.components.TdkViewChangeListener;
import org.tecgraf.jtdk.desktop.components.treeview.TdkDummyLegendElement;
import org.tecgraf.jtdk.desktop.components.treeview.TdkLegendElement;
import org.tecgraf.jtdk.desktop.components.treeview.TdkLegendElementFactory;
import org.tecgraf.jtdk.desktop.components.treeview.TdkThemeGroupLegendElement;
import org.tecgraf.jtdk.desktop.components.treeview.TdkThemeLegendElement;
import org.tecgraf.jtdk.desktop.components.treeview.TdkTreeViewFunctor;
import org.tecgraf.jtdk.desktop.components.treeview.TdkTreeViewListener;
import org.tecgraf.jtdk.desktop.components.treeview.TdkTreeViewRenderer;
import org.tecgraf.jtdk.desktop.components.treeview.TdkUpdateThemeEvent;
import org.tecgraf.jtdk.desktop.components.treeview.TdkUpdateViewEvent;
import org.tecgraf.jtdk.desktop.components.treeview.TdkViewLegendElement;
import org.tecgraf.jtdk.desktop.components.util.TdkDnDTree;

public class TdkTreeView
extends TdkDnDTree
implements TreeExpansionListener,
TreeWillExpandListener,
MouseListener,
TreeSelectionListener {
    private static Logger _logger = Logger.getLogger(TdkTreeView.class);
    protected TdkLegendElementFactory _factory;
    protected TdkViewGID _viewGid;
    protected TdkViewLegendElement _viewRoot;
    protected TdkLegendElement _current;
    protected TdkTreeViewFunctor _functor;
    protected Vector<TdkTreeViewListener> _treeListeners;
    protected Vector<TdkViewChangeListener> _viewListeners;
    protected HashSet<TreePath> _expanded = new HashSet();
    protected boolean _removable;
    private boolean _editable;

    public TdkTreeView(TdkLegendElementFactory tdkLegendElementFactory) {
        this(tdkLegendElementFactory, true, true);
    }

    public TdkTreeView(TdkLegendElementFactory tdkLegendElementFactory, boolean bl, boolean bl2) {
        this.setNodesEditable(bl);
        this.setRemovable(bl2);
        this._factory = tdkLegendElementFactory;
        this._viewRoot = null;
        this._treeListeners = new Vector();
        this._viewListeners = new Vector();
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(new TdkDummyLegendElement());
        this.setModel(defaultTreeModel);
        this.setRootVisible(false);
        this.setShowsRootHandles(false);
        this.setCellRenderer(new TdkTreeViewRenderer());
        this._functor = new TdkTreeViewFunctor(this);
        this.addTreeExpansionListener(this);
        this.addTreeWillExpandListener(this);
        this.addMouseListener(this);
        this.addTreeSelectionListener(this);
    }

    protected void initializeTree() {
        if (this.getDefaultModel().getRoot() instanceof TdkDummyLegendElement) {
            throw new RuntimeException("Root is not valid. Please, cal setView() method to initialize the tree");
        }
        Stack<TdkLegendElement> stack = new Stack<TdkLegendElement>();
        stack.add((TdkLegendElement)this.getDefaultModel().getRoot());
        while (stack.size() > 0) {
            TdkLegendElement tdkLegendElement = (TdkLegendElement)stack.pop();
            if (tdkLegendElement.needsToLoadChildren()) {
                this.loadElementChildren(tdkLegendElement);
            }
            for (TdkLegendElement tdkLegendElement2 : tdkLegendElement.getChildren()) {
                if (tdkLegendElement2 instanceof TdkThemeGroupLegendElement) {
                    stack.add(tdkLegendElement2);
                    continue;
                }
                if (!tdkLegendElement2.needsToLoadChildren()) continue;
                this.loadElementChildren(tdkLegendElement2);
            }
        }
    }

    protected void registerPopupActionListener(ActionListener actionListener, TdkLegendElement tdkLegendElement) {
        JPopupMenu jPopupMenu = tdkLegendElement.getPopupMenu();
        for (int i = 0; i < jPopupMenu.getComponentCount(); ++i) {
            if (!(jPopupMenu.getComponent(i) instanceof JMenuItem) || ((ActionListener[])jPopupMenu.getComponent(i).getListeners(ActionListener.class)).length != 0) continue;
            ((JMenuItem)jPopupMenu.getComponent(i)).addActionListener(actionListener);
        }
    }

    protected DefaultTreeModel getDefaultModel() {
        return (DefaultTreeModel)this.getModel();
    }

    public void setView(TdkViewGID tdkViewGID) {
        this._viewGid = tdkViewGID;
        this._viewRoot = this._factory.makeViewElement(this, this.isNodesEditable(), this.isRemovable(), tdkViewGID);
        this.removeAll();
        this.getDefaultModel().setRoot(this._viewRoot);
        this.setRootVisible(true);
        this.loadElementChildren(this._viewRoot);
        this.updateUI();
        _logger.debug((Object)("new view set: " + tdkViewGID));
    }

    public TdkViewGID getGID() {
        return this._viewGid;
    }

    public TdkLegendElementFactory getFactory() {
        return this._factory;
    }

    public void setFactory(TdkLegendElementFactory tdkLegendElementFactory) {
        this._factory = tdkLegendElementFactory;
    }

    protected void loadElementChildren(TdkLegendElement tdkLegendElement) {
        tdkLegendElement.removeAllChildren();
        tdkLegendElement.killChildren();
        Vector<TdkLegendElement> vector = tdkLegendElement.getChildren();
        if (vector == null || vector.size() == 0) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            tdkLegendElement.add(vector.elementAt(i));
        }
        this.getDefaultModel().reload();
    }

    @Override
    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        this._expanded.add(treeExpansionEvent.getPath());
        this.updateTree(new TreePath(this._viewRoot));
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        TreePath treePath = treeExpansionEvent.getPath();
        try {
            TdkLegendElement tdkLegendElement = (TdkLegendElement)treePath.getLastPathComponent();
            if (tdkLegendElement.needsToLoadChildren()) {
                this.loadElementChildren(tdkLegendElement);
            }
        }
        catch (ClassCastException classCastException) {
            return;
        }
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        this._expanded.remove(treeExpansionEvent.getPath());
    }

    private void nodeChecked(TdkLegendElement tdkLegendElement) {
        this._functor.changeVisibilityActionPerformed();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath != null && treePath.getLastPathComponent() instanceof TdkLegendElement) {
            TdkLegendElement tdkLegendElement;
            this._current = tdkLegendElement = (TdkLegendElement)treePath.getLastPathComponent();
            if (mouseEvent.getClickCount() == 1 && tdkLegendElement.getRenderParams().hasCheckbox()) {
                int n = new JCheckBox().getPreferredSize().width;
                if (mouseEvent.getX() > this.getPathBounds((TreePath)treePath).x + n) {
                    return;
                }
                this.nodeChecked(tdkLegendElement);
                this.repaint();
            }
            if (mouseEvent.getClickCount() == 2) {
                this.nodeChecked(tdkLegendElement);
                this.repaint();
            }
        }
    }

    protected void updateTree(TreePath treePath) {
        if (!this._expanded.contains(treePath) && treePath.getParentPath() != null) {
            this.collapsePath(treePath);
            return;
        }
        Object object = treePath.getLastPathComponent();
        TreeModel treeModel = this.getModel();
        if (!treeModel.isLeaf(object) && treeModel.getChildCount(object) >= 0) {
            for (int i = 0; i < treeModel.getChildCount(object); ++i) {
                Object object2 = treeModel.getChild(object, i);
                TreePath treePath2 = treePath.pathByAddingChild(object2);
                this.updateTree(treePath2);
            }
        }
        if (this._expanded.contains(treePath)) {
            this.expandPath(treePath);
        }
    }

    public void rebuild() {
        this.loadElementChildren(this._viewRoot);
        this.updateTree(new TreePath(this._viewRoot));
        this.invalidate();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        TdkLegendElement tdkLegendElement;
        int n;
        int n2;
        TreePath treePath;
        if (mouseEvent.isPopupTrigger() && (treePath = this.getPathForLocation(n2 = mouseEvent.getX(), n = mouseEvent.getY())) != null && (tdkLegendElement = (TdkLegendElement)treePath.getLastPathComponent()).getPopupMenu() != null) {
            this._current = tdkLegendElement;
            this.registerPopupActionListener(this._functor, tdkLegendElement);
            tdkLegendElement.getPopupMenu().show(this, n2, n);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public TdkLegendElement getCurrentElement() {
        return this._current;
    }

    public void addTreeViewListener(TdkTreeViewListener tdkTreeViewListener) {
        _logger.debug((Object)("added object as treeview listener: " + tdkTreeViewListener));
        if (tdkTreeViewListener != null) {
            this._treeListeners.add(tdkTreeViewListener);
        }
    }

    public void removeTreeViewListener(TdkTreeViewListener tdkTreeViewListener) {
        _logger.debug((Object)("removed treeview listener: " + tdkTreeViewListener));
        this._treeListeners.remove(tdkTreeViewListener);
    }

    public void addViewChangeListener(TdkViewChangeListener tdkViewChangeListener) {
        _logger.debug((Object)("added view change listener: " + tdkViewChangeListener));
        if (tdkViewChangeListener != null) {
            this._viewListeners.add(tdkViewChangeListener);
        }
    }

    public void removeViewChangeListener(TdkViewChangeListener tdkViewChangeListener) {
        _logger.debug((Object)("removed view change listener: " + tdkViewChangeListener));
        this._viewListeners.remove(tdkViewChangeListener);
    }

    public void fireThemeChangeEvent(boolean bl, TdkThemeLegendElement tdkThemeLegendElement, TdkUpdateThemeEvent tdkUpdateThemeEvent) {
        for (int i = 0; i < this._viewListeners.size(); ++i) {
            this._viewListeners.get(i).updateTheme(bl, this, tdkThemeLegendElement.getGID(), tdkUpdateThemeEvent);
        }
    }

    public void fireThemesChangeEvent(boolean bl, Collection<TdkThemeLegendElement> collection, TdkUpdateThemeEvent tdkUpdateThemeEvent) {
        for (int i = 0; i < this._viewListeners.size(); ++i) {
            ArrayList<TdkThemeGID> arrayList = new ArrayList<TdkThemeGID>();
            Iterator<TdkThemeLegendElement> iterator = collection.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next().getGID());
            }
            this._viewListeners.get(i).updateThemeSet(bl, this, arrayList, tdkUpdateThemeEvent);
        }
    }

    public void fireViewChangeEvent(boolean bl, TdkViewLegendElement tdkViewLegendElement, TdkUpdateViewEvent tdkUpdateViewEvent) {
        for (int i = 0; i < this._viewListeners.size(); ++i) {
            this._viewListeners.get(i).updateView(bl, this, tdkViewLegendElement.getGID(), tdkUpdateViewEvent);
        }
    }

    public void fireViewSavedEvent(boolean bl, TdkViewLegendElement tdkViewLegendElement, TdkUpdateViewEvent tdkUpdateViewEvent) {
        for (int i = 0; i < this._viewListeners.size(); ++i) {
            this._viewListeners.get(i).saveView(bl, this, tdkViewLegendElement.getGID(), tdkUpdateViewEvent);
        }
    }

    public void fireAddedNodeEvent(boolean bl, TreePath treePath, TdkLegendElement tdkLegendElement) {
        TdkThemeGroupGID tdkThemeGroupGID = null;
        if (treePath.getLastPathComponent() instanceof TdkThemeGroupLegendElement) {
            tdkThemeGroupGID = ((TdkThemeGroupLegendElement)treePath.getLastPathComponent()).getGID();
        }
        TdkThemeGID tdkThemeGID = null;
        if (tdkLegendElement instanceof TdkThemeLegendElement) {
            tdkThemeGID = ((TdkThemeLegendElement)tdkLegendElement).getGID();
        } else if (tdkLegendElement instanceof TdkThemeGroupLegendElement) {
            tdkThemeGID = ((TdkThemeGroupLegendElement)tdkLegendElement).getGID();
        } else {
            return;
        }
        for (int i = 0; i < this._viewListeners.size(); ++i) {
            this._viewListeners.get(i).addViewNode(bl, this, this._viewGid, tdkThemeGroupGID, (TdkViewNodeGID)tdkThemeGID);
        }
    }

    public void fireNewElementEvent(TdkLegendElement tdkLegendElement) {
        if (tdkLegendElement == null) {
            throw new IllegalArgumentException("Element can`t be null");
        }
        for (int i = 0; i < this._treeListeners.size(); ++i) {
            this._treeListeners.get(i).legendElementCreated(this, tdkLegendElement);
        }
    }

    public void fireRemovedNodeEvent(boolean bl, TreePath treePath, TdkLegendElement tdkLegendElement) {
        TdkThemeGroupGID tdkThemeGroupGID = null;
        if (treePath.getLastPathComponent() instanceof TdkThemeGroupLegendElement) {
            tdkThemeGroupGID = ((TdkThemeGroupLegendElement)treePath.getLastPathComponent()).getGID();
        }
        TdkThemeGID tdkThemeGID = null;
        if (tdkLegendElement instanceof TdkThemeLegendElement) {
            tdkThemeGID = ((TdkThemeLegendElement)tdkLegendElement).getGID();
        } else if (tdkLegendElement instanceof TdkThemeGroupLegendElement) {
            tdkThemeGID = ((TdkThemeGroupLegendElement)tdkLegendElement).getGID();
        } else {
            return;
        }
        for (int i = 0; i < this._viewListeners.size(); ++i) {
            this._viewListeners.get(i).removeViewNode(bl, this, this._viewGid, tdkThemeGroupGID, (TdkViewNodeGID)tdkThemeGID);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = treeSelectionEvent.getOldLeadSelectionPath();
        TdkLegendElement tdkLegendElement = null;
        if (treePath != null) {
            tdkLegendElement = (TdkLegendElement)treePath.getLastPathComponent();
        }
        treePath = treeSelectionEvent.getNewLeadSelectionPath();
        TdkLegendElement tdkLegendElement2 = null;
        if (treePath != null) {
            tdkLegendElement2 = (TdkLegendElement)treePath.getLastPathComponent();
        }
        for (int i = 0; i < this._treeListeners.size(); ++i) {
            this._treeListeners.get(i).selectionChanged(this, tdkLegendElement, tdkLegendElement2);
        }
    }

    protected boolean validadeDrop(TreePath treePath, TreePath treePath2, int n) {
        if (treePath == null || treePath.getParentPath() == null) {
            return false;
        }
        if (treePath2 == null) {
            return false;
        }
        if (treePath.isDescendant(treePath2)) {
            return false;
        }
        TdkLegendElement tdkLegendElement = (TdkLegendElement)treePath2.getLastPathComponent();
        if (!(tdkLegendElement instanceof TdkThemeGroupLegendElement) && !(tdkLegendElement instanceof TdkViewLegendElement)) {
            return false;
        }
        if (tdkLegendElement instanceof TdkThemeGroupLegendElement && !((TdkThemeGroupLegendElement)tdkLegendElement).isEditable()) {
            return false;
        }
        TdkLegendElement tdkLegendElement2 = (TdkLegendElement)treePath.getLastPathComponent();
        TdkLegendElement tdkLegendElement3 = (TdkLegendElement)treePath.getParentPath().getLastPathComponent();
        return !tdkLegendElement3.equals(tdkLegendElement) || tdkLegendElement3.getIndex(tdkLegendElement2) != n && tdkLegendElement3.getIndex(tdkLegendElement2) + 1 != n;
    }

    @Override
    protected boolean isDropAcceptable(TreePath treePath, TreePath treePath2, boolean bl) {
        if (treePath2 == null || treePath2.getLastPathComponent() == null) {
            return false;
        }
        Object[] objectArray = this.getPosition(treePath, treePath2, bl);
        return this.validadeDrop(treePath, (TreePath)objectArray[0], (Integer)objectArray[1]);
    }

    private Object[] getPosition(TreePath treePath, TreePath treePath2, boolean bl) {
        Object[] objectArray = new Object[2];
        if (treePath2.getLastPathComponent() instanceof TdkThemeGroupLegendElement && !bl) {
            objectArray[0] = treePath2;
            objectArray[1] = 0;
        } else if (this.isExpanded(treePath2) && !bl) {
            objectArray[0] = treePath2;
            objectArray[1] = 0;
        } else if (!bl) {
            objectArray[0] = treePath2.getParentPath();
            TdkLegendElement tdkLegendElement = (TdkLegendElement)treePath2.getParentPath().getLastPathComponent();
            objectArray[1] = tdkLegendElement.getIndex((TreeNode)treePath2.getLastPathComponent()) + 1;
        } else if (treePath2.getLastPathComponent() instanceof TdkViewLegendElement) {
            objectArray[0] = treePath2;
            objectArray[1] = 0;
        } else {
            objectArray[0] = treePath2.getParentPath();
            TdkLegendElement tdkLegendElement = (TdkLegendElement)treePath2.getParentPath().getLastPathComponent();
            objectArray[1] = tdkLegendElement.getIndex((TreeNode)treePath2.getLastPathComponent());
        }
        return objectArray;
    }

    @Override
    protected boolean isRootPath(TreePath treePath) {
        if (!(treePath.getLastPathComponent() instanceof TdkViewLegendElement) || this._viewGid == null || treePath == null) {
            return false;
        }
        return ((TdkViewLegendElement)treePath.getLastPathComponent()).getGID().equals(this._viewGid);
    }

    @Override
    protected void updateTreeNodes(TreePath treePath, TreePath treePath2, boolean bl) {
        Object[] objectArray = this.getPosition(treePath, treePath2, bl);
        TdkLegendElement tdkLegendElement = (TdkLegendElement)treePath.getLastPathComponent();
        TdkLegendElement tdkLegendElement2 = (TdkLegendElement)treePath.getParentPath().getLastPathComponent();
        TdkLegendElement tdkLegendElement3 = (TdkLegendElement)((TreePath)objectArray[0]).getLastPathComponent();
        int n = (Integer)objectArray[1];
        int n2 = tdkLegendElement2.getIndex(tdkLegendElement);
        this._functor.moveNode(tdkLegendElement, tdkLegendElement2, n2, tdkLegendElement3, n);
        this.rebuild();
        this.updateUI();
    }

    @Override
    public boolean canDrag(TreePath treePath) {
        TdkLegendElement tdkLegendElement = (TdkLegendElement)treePath.getLastPathComponent();
        if (tdkLegendElement.getParent() instanceof TdkThemeGroupLegendElement && !((TdkThemeGroupLegendElement)tdkLegendElement.getParent()).isEditable()) {
            return false;
        }
        if (tdkLegendElement instanceof TdkThemeLegendElement) {
            return true;
        }
        return tdkLegendElement instanceof TdkThemeGroupLegendElement;
    }

    public boolean isRemovable() {
        return this._removable;
    }

    public void setRemovable(boolean bl) {
        this._removable = bl;
    }

    public void setNodesEditable(boolean bl) {
        this._editable = bl;
    }

    public boolean isNodesEditable() {
        return this._editable;
    }
}

