/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.treeview;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Stack;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.tree.DefaultTreeModel;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.core.TdkJVipeSetup;
import org.tecgraf.jtdk.core.exceptions.TdkActionWorkflowServiceNotInitializedException;
import org.tecgraf.jtdk.core.exceptions.TdkDatabaseException;
import org.tecgraf.jtdk.core.exceptions.TdkException;
import org.tecgraf.jtdk.core.exceptions.TdkNullPointerException;
import org.tecgraf.jtdk.core.swig.TdkAbstractPersistenceService;
import org.tecgraf.jtdk.core.swig.TdkSetup;
import org.tecgraf.jtdk.core.swig.TdkTheme;
import org.tecgraf.jtdk.core.swig.TdkThemeGID;
import org.tecgraf.jtdk.core.swig.TdkThemeGroup;
import org.tecgraf.jtdk.core.swig.TdkThemeGroupGID;
import org.tecgraf.jtdk.core.swig.TdkView;
import org.tecgraf.jtdk.core.swig.TdkViewGID;
import org.tecgraf.jtdk.core.swig.TdkViewNodeGID;
import org.tecgraf.jtdk.core.swig.TdkViewNodeHandlingUtils;
import org.tecgraf.jtdk.core.swig.TeLegendEntry;
import org.tecgraf.jtdk.core.swig.TeProjection;
import org.tecgraf.jtdk.desktop.components.TdkComponentsI18n;
import org.tecgraf.jtdk.desktop.components.TdkDefaultActionWorkflowService;
import org.tecgraf.jtdk.desktop.components.dialogs.TdkCreateGroupDialog;
import org.tecgraf.jtdk.desktop.components.dialogs.TdkProgressBarDialog;
import org.tecgraf.jtdk.desktop.components.dialogs.TdkShowProjectionInfoDialog;
import org.tecgraf.jtdk.desktop.components.dialogs.TdkThemePropertiesDialog;
import org.tecgraf.jtdk.desktop.components.dialogs.style.TdkMainStyleDlg;
import org.tecgraf.jtdk.desktop.components.dialogs.thematic.TdkThematicDialog;
import org.tecgraf.jtdk.desktop.components.dialogs.thematic.TdkThematicDialogCallback;
import org.tecgraf.jtdk.desktop.components.dialogs.thematic.TdkThematicDialogManager;
import org.tecgraf.jtdk.desktop.components.treeview.TdkLegendElement;
import org.tecgraf.jtdk.desktop.components.treeview.TdkThematicLegendElement;
import org.tecgraf.jtdk.desktop.components.treeview.TdkThemeGroupLegendElement;
import org.tecgraf.jtdk.desktop.components.treeview.TdkThemeLegendElement;
import org.tecgraf.jtdk.desktop.components.treeview.TdkTreeView;
import org.tecgraf.jtdk.desktop.components.treeview.TdkUpdateThemeEvent;
import org.tecgraf.jtdk.desktop.components.treeview.TdkUpdateViewEvent;
import org.tecgraf.jtdk.desktop.components.treeview.TdkViewLegendElement;
import org.tecgraf.jtdk.desktop.components.util.TdkDialogUtil;

public class TdkTreeViewFunctor
implements ActionListener {
    private static Logger _logger = Logger.getLogger(TdkTreeViewFunctor.class);
    TdkTreeView _treeView;
    public static final String ACT_CMD_SHOW_THEME = "show_theme_commmand";
    public static final String ACT_CMD_THEME_STYLE = "theme_style_command";
    public static final String ACT_CMD_SEL_OBJ_THEME_STYLE = "sel_obj_theme_style_command";
    public static final String ACT_CMD_THEMATIC = "thematic_command";
    public static final String ACT_CMD_PROPERTIES = "properties_command";
    public static final String ACT_CMD_REFERENCE_SCALE = "reference_scale_command";
    public static final String ACT_CMD_FIX_BOUNDING = "fix_bounding_command";
    public static final String ACT_CMD_EXP_SHAPE = "exp_shape_command";
    public static final String ACT_CMD_THEME_DELETE = "theme_delete_command";
    public static final String ACT_CMD_MOVE_UP = "move_up_command";
    public static final String ACT_CMD_MOVE_DOWN = "move_down_command";
    public static final String ACT_CMD_VIEW_ACTIVE = "view_active_command";
    public static final String ACT_CMD_FIT_VIEW = "fit_view_command";
    public static final String ACT_CMD_NEW_THEME = "new_theme_command";
    public static final String ACT_CMD_NEW_GROUP = "new_group_command";
    public static final String ACT_CMD_VIEW_PROJ_EDIT = "view_proj_edit_command";
    public static final String ACT_CMD_VIEW_SAVE = "view_save_command";
    public static final String ACT_CMD_VIEW_SHOW_PROJ = "show_proj_command";
    public static final String ACT_CMD_THEMATIC_STYLE = "edit_thematic_style_command";
    public static final String ACT_CMD_GROUP_DELETE = "group_delete_command";
    public static final String ACT_CMD_VIEW_SHOW_ALL_THEMES = "view_show_all_command";
    public static final String ACT_CMD_VIEW_HIDE_ALL_THEMES = "view_hide_all_command";

    public TdkTreeViewFunctor(TdkTreeView tdkTreeView) {
        this._treeView = tdkTreeView;
    }

    public void showThemeActionPerformed() {
        TdkThemeLegendElement tdkThemeLegendElement = (TdkThemeLegendElement)this._treeView.getCurrentElement();
        JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)tdkThemeLegendElement.getMenuItem(ACT_CMD_SHOW_THEME);
        if (tdkThemeLegendElement != null) {
            tdkThemeLegendElement.changeVisibility(true);
            jCheckBoxMenuItem.setSelected(tdkThemeLegendElement.isThemeVisible());
            _logger.debug((Object)"vibility theme");
            tdkThemeLegendElement.buildDefaultRenderParams();
            this._treeView.repaint();
        }
    }

    public void themeStyleActionPerformed() {
        TdkThemeLegendElement tdkThemeLegendElement = (TdkThemeLegendElement)this._treeView.getCurrentElement();
        TdkThemeGID tdkThemeGID = tdkThemeLegendElement.getGID();
        TdkTheme tdkTheme = TdkSetup.getPersistenceService().getTheme(tdkThemeGID);
        int n = tdkTheme.getVisibleRepresentation();
        TdkUpdateThemeEvent tdkUpdateThemeEvent = new TdkUpdateThemeEvent();
        tdkUpdateThemeEvent.setSetDefaultStyleChanged(true);
        this._treeView.fireThemeChangeEvent(true, tdkThemeLegendElement, tdkUpdateThemeEvent);
        TeLegendEntry teLegendEntry = tdkTheme.getDefaultLegend();
        if (this.editStyle(teLegendEntry, tdkThemeGID.getDBKey(), n)) {
            this._treeView.fireThemeChangeEvent(false, tdkThemeLegendElement, tdkUpdateThemeEvent);
            tdkThemeLegendElement.buildDefaultRenderParams();
            this._treeView.repaint();
        }
    }

    public boolean editStyle(TeLegendEntry teLegendEntry, String string, int n) {
        if (teLegendEntry == null) {
            return false;
        }
        Frame frame = TdkDialogUtil.getFrameParent(this._treeView);
        TdkMainStyleDlg tdkMainStyleDlg = new TdkMainStyleDlg(frame, teLegendEntry, string, n);
        TdkDialogUtil.centralize(tdkMainStyleDlg, frame);
        tdkMainStyleDlg.setVisible(true);
        if (!tdkMainStyleDlg.cancelled()) {
            teLegendEntry = tdkMainStyleDlg.getEditedLegendEntry();
            return true;
        }
        return false;
    }

    public void selObjThemeStyleThemeActionPerformed() {
        TdkThemeLegendElement tdkThemeLegendElement = (TdkThemeLegendElement)this._treeView.getCurrentElement();
        TdkThemeGID tdkThemeGID = tdkThemeLegendElement.getGID();
        TdkTheme tdkTheme = TdkSetup.getPersistenceService().getTheme(tdkThemeGID);
        int n = tdkTheme.getVisibleRepresentation();
        TdkUpdateThemeEvent tdkUpdateThemeEvent = new TdkUpdateThemeEvent();
        tdkUpdateThemeEvent.setSelectedStyleChanged(true);
        this._treeView.fireThemeChangeEvent(true, tdkThemeLegendElement, tdkUpdateThemeEvent);
        TeLegendEntry teLegendEntry = tdkTheme.getQueryLegend();
        if (this.editStyle(teLegendEntry, tdkThemeGID.getDBKey(), n)) {
            this._treeView.fireThemeChangeEvent(false, tdkThemeLegendElement, tdkUpdateThemeEvent);
        }
    }

    public void thematicActionPerformed() {
        TdkThemeLegendElement tdkThemeLegendElement = (TdkThemeLegendElement)this._treeView.getCurrentElement();
        TdkThematicDialogManager tdkThematicDialogManager = new TdkThematicDialogManager(tdkThemeLegendElement.getGID());
        TdkThematicDialogCallback tdkThematicDialogCallback = tdkThematicDialogManager.getCallback();
        TdkThematicDialog tdkThematicDialog = new TdkThematicDialog(TdkDialogUtil.getFrameParent(this._treeView), tdkThematicDialogCallback, tdkThemeLegendElement.getGID());
        tdkThematicDialog.setInput(tdkThematicDialogManager.getInput());
        tdkThematicDialog.setValue(tdkThematicDialogManager.getInitialState());
        tdkThematicDialog.setModal(true);
        tdkThematicDialog.setVisible(true);
        TdkUpdateThemeEvent tdkUpdateThemeEvent = tdkThematicDialogCallback.getUpdateThemeEvent();
        if (tdkUpdateThemeEvent.legendVectorChanged()) {
            TdkSetup.getGraphicalService().clearThemeBlocks(tdkThemeLegendElement.getGID(), true, true);
            this._treeView.rebuild();
            this._treeView.fireThemeChangeEvent(false, tdkThemeLegendElement, tdkUpdateThemeEvent);
        }
    }

    public void propertiesActionPerformed() {
        _logger.debug((Object)"properties action");
        Frame frame = TdkDialogUtil.getFrameParent(this._treeView);
        TdkThemePropertiesDialog tdkThemePropertiesDialog = new TdkThemePropertiesDialog(frame);
        TdkDialogUtil.centralize(tdkThemePropertiesDialog, frame);
        TdkThemeLegendElement tdkThemeLegendElement = (TdkThemeLegendElement)this._treeView.getCurrentElement();
        TdkTheme tdkTheme = TdkSetup.getPersistenceService().getTheme(tdkThemeLegendElement.getGID());
        TdkUpdateThemeEvent tdkUpdateThemeEvent = tdkThemePropertiesDialog.editThemeProperties(tdkThemeLegendElement.getGID());
        if (tdkUpdateThemeEvent.tooltipChanged() || tdkUpdateThemeEvent.minMaxScaleChanged()) {
            TdkSetup.getGraphicalService().clearThemeBlocks(tdkThemeLegendElement.getGID(), true, true);
        }
        if (tdkUpdateThemeEvent.nameChanged()) {
            tdkThemeLegendElement.buildDefaultRenderParams();
            this._treeView.repaint();
        }
        this._treeView.fireThemeChangeEvent(false, tdkThemeLegendElement, tdkUpdateThemeEvent);
    }

    public void changeVisibilityActionPerformed() {
        TdkLegendElement tdkLegendElement = this._treeView.getCurrentElement();
        if (tdkLegendElement instanceof TdkThemeLegendElement) {
            TdkThemeLegendElement tdkThemeLegendElement;
            tdkThemeLegendElement.setChecked(!(tdkThemeLegendElement = (TdkThemeLegendElement)tdkLegendElement).isChecked());
            tdkThemeLegendElement.changeVisibility(true);
        } else if (tdkLegendElement instanceof TdkThemeGroupLegendElement) {
            Object object;
            boolean bl;
            ArrayList<TdkThemeLegendElement> arrayList = new ArrayList<TdkThemeLegendElement>();
            Stack<TdkThemeGroupLegendElement> stack = new Stack<TdkThemeGroupLegendElement>();
            stack.push((TdkThemeGroupLegendElement)tdkLegendElement);
            boolean bl2 = bl = !((TdkThemeGroupLegendElement)tdkLegendElement).isChecked();
            while (stack.size() > 0) {
                object = (TdkThemeGroupLegendElement)stack.pop();
                for (int i = 0; i < ((TdkLegendElement)object).getChildren().size(); ++i) {
                    TdkLegendElement tdkLegendElement2 = ((TdkLegendElement)object).getChildren().get(i);
                    if (tdkLegendElement2 instanceof TdkThemeGroupLegendElement) {
                        stack.push((TdkThemeGroupLegendElement)tdkLegendElement2);
                        continue;
                    }
                    TdkThemeLegendElement tdkThemeLegendElement = (TdkThemeLegendElement)tdkLegendElement2;
                    if (bl == tdkThemeLegendElement.isThemeVisible()) continue;
                    arrayList.add(tdkThemeLegendElement);
                }
            }
            object = new TdkUpdateThemeEvent();
            ((TdkUpdateThemeEvent)object).setVisibilityChanged(true);
            this._treeView.fireThemesChangeEvent(true, arrayList, (TdkUpdateThemeEvent)object);
            for (TdkThemeLegendElement tdkThemeLegendElement : arrayList) {
                tdkThemeLegendElement.changeVisibility(false, bl);
            }
            this._treeView.fireThemesChangeEvent(false, arrayList, (TdkUpdateThemeEvent)object);
        }
    }

    public void moveNode(TdkLegendElement tdkLegendElement, TdkLegendElement tdkLegendElement2, int n, TdkLegendElement tdkLegendElement3, int n2) {
        TdkLegendElement tdkLegendElement4;
        if (!(tdkLegendElement2 instanceof TdkViewLegendElement) && !(tdkLegendElement2 instanceof TdkThemeGroupLegendElement) || !(tdkLegendElement3 instanceof TdkViewLegendElement) && !(tdkLegendElement3 instanceof TdkThemeGroupLegendElement) || !(tdkLegendElement instanceof TdkThemeLegendElement) && !(tdkLegendElement instanceof TdkThemeGroupLegendElement) || tdkLegendElement.isNodeDescendant(tdkLegendElement3)) {
            throw new IllegalArgumentException();
        }
        TdkUpdateViewEvent tdkUpdateViewEvent = new TdkUpdateViewEvent();
        tdkUpdateViewEvent.setLegendVectorChanged(true);
        this._treeView.fireViewChangeEvent(true, (TdkViewLegendElement)tdkLegendElement2.getRoot(), tdkUpdateViewEvent);
        TdkAbstractPersistenceService tdkAbstractPersistenceService = TdkSetup.getPersistenceService();
        TdkThemeGID tdkThemeGID = null;
        if (tdkLegendElement instanceof TdkThemeLegendElement) {
            tdkLegendElement4 = (TdkThemeLegendElement)tdkLegendElement;
            tdkThemeGID = ((TdkThemeLegendElement)tdkLegendElement4).getGID();
        } else if (tdkLegendElement instanceof TdkThemeGroupLegendElement) {
            tdkLegendElement4 = (TdkThemeGroupLegendElement)tdkLegendElement;
            tdkThemeGID = ((TdkThemeGroupLegendElement)tdkLegendElement4).getGID();
        }
        if (tdkLegendElement2 instanceof TdkViewLegendElement) {
            tdkLegendElement4 = (TdkViewLegendElement)tdkLegendElement2;
            TdkViewGID tdkViewGID = ((TdkViewLegendElement)tdkLegendElement4).getGID();
            TdkView tdkView = tdkAbstractPersistenceService.getView(tdkViewGID);
            if (tdkLegendElement3 instanceof TdkViewLegendElement) {
                tdkView.moveNodeTo((TdkViewNodeGID)tdkThemeGID, n2);
            } else if (tdkLegendElement3 instanceof TdkThemeGroupLegendElement) {
                TdkThemeGroupLegendElement tdkThemeGroupLegendElement = (TdkThemeGroupLegendElement)tdkLegendElement3;
                TdkThemeGroupGID tdkThemeGroupGID = tdkThemeGroupLegendElement.getGID();
                TdkThemeGroup tdkThemeGroup = tdkAbstractPersistenceService.getThemeGroup(tdkThemeGroupGID);
                TdkViewNodeHandlingUtils.moveNodeFromViewToGroup((TdkView)tdkView, (TdkThemeGroup)tdkThemeGroup, (TdkViewNodeGID)tdkThemeGID, (int)n2);
            }
        } else if (tdkLegendElement2 instanceof TdkThemeGroupLegendElement) {
            tdkLegendElement4 = (TdkThemeGroupLegendElement)tdkLegendElement2;
            TdkThemeGroupGID tdkThemeGroupGID = ((TdkThemeGroupLegendElement)tdkLegendElement4).getGID();
            TdkThemeGroup tdkThemeGroup = tdkAbstractPersistenceService.getThemeGroup(tdkThemeGroupGID);
            if (tdkLegendElement3 instanceof TdkThemeGroupLegendElement) {
                TdkThemeGroupLegendElement tdkThemeGroupLegendElement = (TdkThemeGroupLegendElement)tdkLegendElement3;
                TdkThemeGroupGID tdkThemeGroupGID2 = tdkThemeGroupLegendElement.getGID();
                TdkThemeGroup tdkThemeGroup2 = tdkAbstractPersistenceService.getThemeGroup(tdkThemeGroupGID2);
                TdkViewNodeHandlingUtils.moveNodeFromGroupToGroup((TdkThemeGroup)tdkThemeGroup, (TdkThemeGroup)tdkThemeGroup2, (TdkViewNodeGID)tdkThemeGID, (int)n2);
            } else if (tdkLegendElement3 instanceof TdkViewLegendElement) {
                TdkViewLegendElement tdkViewLegendElement = (TdkViewLegendElement)tdkLegendElement3;
                TdkViewGID tdkViewGID = tdkViewLegendElement.getGID();
                TdkView tdkView = tdkAbstractPersistenceService.getView(tdkViewGID);
                TdkViewNodeHandlingUtils.moveNodeFromGroupToView((TdkThemeGroup)tdkThemeGroup, (TdkView)tdkView, (TdkViewNodeGID)tdkThemeGID, (int)n2);
            }
        }
        this._treeView.fireViewChangeEvent(false, (TdkViewLegendElement)tdkLegendElement2.getRoot(), tdkUpdateViewEvent);
    }

    public void referenceScaleActionPerformed() {
    }

    public void fixBoundingActionPerformed() {
        TdkThemeLegendElement tdkThemeLegendElement = (TdkThemeLegendElement)this._treeView.getCurrentElement();
        TdkThemeGID tdkThemeGID = tdkThemeLegendElement.getGID();
        TdkTheme tdkTheme = TdkSetup.getPersistenceService().getTheme(tdkThemeGID);
        TdkUpdateThemeEvent tdkUpdateThemeEvent = new TdkUpdateThemeEvent();
        tdkTheme.updateThemeBox();
    }

    public void expShapeActionPerformed() {
    }

    private void themeDeleteActionPerformed() {
        TdkThemeLegendElement tdkThemeLegendElement = (TdkThemeLegendElement)this._treeView.getCurrentElement();
        tdkThemeLegendElement.delete();
    }

    public void viewActiveActionPerformed() {
        System.err.println("view active action");
    }

    public void fitViewActionPerformed() {
        System.err.println("fit view action");
    }

    public void newThemeActionPerformed() {
        TdkViewGID tdkViewGID = this._treeView.getGID();
        TdkTheme tdkTheme = null;
        Frame frame = TdkDialogUtil.getFrameParent(this._treeView);
        try {
            tdkTheme = new TdkDefaultActionWorkflowService().createTheme(frame, tdkViewGID.getDBKey());
        }
        catch (TdkNullPointerException tdkNullPointerException) {
            _logger.error((Object)tdkNullPointerException.getMessage());
        }
        catch (TdkDatabaseException tdkDatabaseException) {
            _logger.error((Object)tdkDatabaseException.getMessage());
        }
        catch (TdkException tdkException) {
            _logger.error((Object)tdkException.getMessage());
        }
        if (tdkTheme != null) {
            TdkThemeLegendElement tdkThemeLegendElement = new TdkThemeLegendElement(this._treeView, new TdkThemeGID(tdkViewGID.getDBKey(), tdkTheme.getId()));
            this._treeView.fireAddedNodeEvent(true, this._treeView.getCurrentElement().getTreePath(), tdkThemeLegendElement);
            TdkViewLegendElement tdkViewLegendElement = (TdkViewLegendElement)this._treeView.getCurrentElement();
            tdkViewLegendElement.add(tdkThemeLegendElement);
            ((DefaultTreeModel)this._treeView.getModel()).reload();
            this._treeView.fireAddedNodeEvent(false, this._treeView.getCurrentElement().getTreePath(), tdkThemeLegendElement);
        }
    }

    public void newGroupActionPerformed() {
        Frame frame = TdkDialogUtil.getFrameParent(this._treeView);
        TdkCreateGroupDialog tdkCreateGroupDialog = new TdkCreateGroupDialog(frame, TdkCreateGroupDialog.DialogMode.CREATION_DIALOG);
        tdkCreateGroupDialog.setGroupName(TdkComponentsI18n.getString("DLG_CREATE_GROUP_DEFAULT_NAME"));
        TdkDialogUtil.centralize(tdkCreateGroupDialog, frame);
        tdkCreateGroupDialog.setVisible(true);
        String string = tdkCreateGroupDialog.getGroupName();
        if (string == null) {
            return;
        }
        TdkViewLegendElement tdkViewLegendElement = (TdkViewLegendElement)this._treeView.getCurrentElement();
        TdkThemeGroup tdkThemeGroup = new TdkThemeGroup(string, tdkViewLegendElement.getGID());
        tdkThemeGroup.setViewId(tdkViewLegendElement.getGID().getId());
        TdkSetup.getPersistenceService().insertThemeGroup(tdkViewLegendElement.getGID().getDBKey(), tdkThemeGroup);
        this._treeView.rebuild();
    }

    public void viewProjEditActionPerformed() {
        try {
            TeProjection teProjection;
            TdkViewLegendElement tdkViewLegendElement = (TdkViewLegendElement)this._treeView.getCurrentElement();
            TdkViewGID tdkViewGID = tdkViewLegendElement.getGID();
            TdkView tdkView = TdkSetup.getPersistenceService().getView(tdkViewGID);
            if (tdkView != null && (teProjection = TdkJVipeSetup.getInstance().getActionWorkflowService().editProjection(tdkView.getProjection())) != null) {
                tdkView.setProjection(teProjection);
                TdkUpdateViewEvent tdkUpdateViewEvent = new TdkUpdateViewEvent();
                tdkUpdateViewEvent.setProjectionChanged(true);
                this._treeView.fireViewChangeEvent(false, tdkViewLegendElement, tdkUpdateViewEvent);
            }
        }
        catch (TdkActionWorkflowServiceNotInitializedException tdkActionWorkflowServiceNotInitializedException) {
            _logger.debug((Object)"action workflow not initialized");
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(ACT_CMD_SHOW_THEME)) {
            this.showThemeActionPerformed();
        } else if (string.equals(ACT_CMD_THEME_STYLE)) {
            this.themeStyleActionPerformed();
        } else if (string.equals(ACT_CMD_THEMATIC_STYLE)) {
            this.thematicStyleActionPerformed();
        } else if (string.equals(ACT_CMD_SEL_OBJ_THEME_STYLE)) {
            this.selObjThemeStyleThemeActionPerformed();
        } else if (string.equals(ACT_CMD_THEMATIC)) {
            this.thematicActionPerformed();
        } else if (string.equals(ACT_CMD_PROPERTIES)) {
            this.propertiesActionPerformed();
        } else if (string.equals(ACT_CMD_REFERENCE_SCALE)) {
            this.referenceScaleActionPerformed();
        } else if (string.equals(ACT_CMD_FIX_BOUNDING)) {
            this.fixBoundingActionPerformed();
        } else if (string.equals(ACT_CMD_EXP_SHAPE)) {
            this.expShapeActionPerformed();
        } else if (string.equals(ACT_CMD_THEME_DELETE)) {
            this.themeDeleteActionPerformed();
        } else if (string.equals(ACT_CMD_VIEW_ACTIVE)) {
            this.viewActiveActionPerformed();
        } else if (string.equals(ACT_CMD_FIT_VIEW)) {
            this.fitViewActionPerformed();
        } else if (string.equals(ACT_CMD_NEW_THEME)) {
            this.newThemeActionPerformed();
        } else if (string.equals(ACT_CMD_NEW_GROUP)) {
            this.newGroupActionPerformed();
        } else if (string.equals(ACT_CMD_VIEW_PROJ_EDIT)) {
            this.viewProjEditActionPerformed();
        } else if (string.equals(ACT_CMD_VIEW_SHOW_PROJ)) {
            this.showProjectionInfo();
        } else if (string.equals(ACT_CMD_VIEW_SAVE)) {
            this.viewSaveActionPerformed();
        } else if (string.equals(ACT_CMD_VIEW_SHOW_ALL_THEMES)) {
            this.showAllActionPerformed();
        } else if (string.equals(ACT_CMD_VIEW_HIDE_ALL_THEMES)) {
            this.hideAllActionPerformed();
        } else if (string.equals(ACT_CMD_GROUP_DELETE)) {
            this.groupDeleteActionPerformed();
        } else if (string.equals(ACT_CMD_MOVE_UP)) {
            this.moveUpActionPerformed();
        } else if (string.equals(ACT_CMD_MOVE_DOWN)) {
            this.moveDownActionPerformed();
        }
    }

    private void setVisibilityOfAllThemes(boolean bl) {
        Object object;
        TdkViewLegendElement tdkViewLegendElement = (TdkViewLegendElement)this._treeView.getCurrentElement();
        TdkViewGID tdkViewGID = tdkViewLegendElement.getGID();
        TdkView tdkView = TdkSetup.getPersistenceService().getView(tdkViewGID);
        ArrayList<TdkThemeLegendElement> arrayList = new ArrayList<TdkThemeLegendElement>();
        Stack<TdkLegendElement> stack = new Stack<TdkLegendElement>();
        stack.addAll(tdkViewLegendElement.getChildren());
        while (stack.size() > 0) {
            Object object2;
            object = (TdkLegendElement)stack.pop();
            if (object instanceof TdkThemeGroupLegendElement) {
                object2 = (TdkThemeGroupLegendElement)object;
                for (int i = 0; i < ((TdkLegendElement)object2).getChildren().size(); ++i) {
                    TdkLegendElement tdkLegendElement = ((TdkLegendElement)object2).getChildren().get(i);
                    stack.push(tdkLegendElement);
                }
                continue;
            }
            object2 = (TdkThemeLegendElement)object;
            if (bl == ((TdkThemeLegendElement)object2).isThemeVisible()) continue;
            arrayList.add((TdkThemeLegendElement)object2);
        }
        object = new TdkUpdateThemeEvent();
        ((TdkUpdateThemeEvent)object).setVisibilityChanged(true);
        this._treeView.fireThemesChangeEvent(true, arrayList, (TdkUpdateThemeEvent)object);
        for (TdkThemeLegendElement tdkThemeLegendElement : arrayList) {
            tdkThemeLegendElement.changeVisibility(false, bl);
        }
        this._treeView.fireThemesChangeEvent(false, arrayList, (TdkUpdateThemeEvent)object);
        this._treeView.repaint();
    }

    private void hideAllActionPerformed() {
        this.setVisibilityOfAllThemes(false);
    }

    private void showAllActionPerformed() {
        this.setVisibilityOfAllThemes(true);
    }

    private void moveDownActionPerformed() {
        TdkLegendElement tdkLegendElement = this._treeView.getCurrentElement();
        TdkLegendElement tdkLegendElement2 = (TdkLegendElement)tdkLegendElement.getParent();
        if (tdkLegendElement2 == null) {
            return;
        }
        int n = tdkLegendElement2.getIndex(tdkLegendElement);
        if (n == tdkLegendElement2.getChildCount() - 1) {
            return;
        }
        this.moveNode(tdkLegendElement, tdkLegendElement2, n, tdkLegendElement2, n + 2);
        this._treeView.rebuild();
    }

    private void moveUpActionPerformed() {
        TdkLegendElement tdkLegendElement = this._treeView.getCurrentElement();
        TdkLegendElement tdkLegendElement2 = (TdkLegendElement)tdkLegendElement.getParent();
        if (tdkLegendElement2 == null) {
            return;
        }
        int n = tdkLegendElement2.getIndex(tdkLegendElement);
        if (n == 0) {
            return;
        }
        this.moveNode(tdkLegendElement, tdkLegendElement2, n, tdkLegendElement2, n - 1);
        this._treeView.rebuild();
    }

    private void groupDeleteActionPerformed() {
        TdkLegendElement tdkLegendElement = this._treeView.getCurrentElement();
        if (tdkLegendElement instanceof TdkThemeGroupLegendElement) {
            TdkThemeGroupLegendElement tdkThemeGroupLegendElement = (TdkThemeGroupLegendElement)tdkLegendElement;
            tdkThemeGroupLegendElement.delete();
        }
    }

    private void showProjectionInfo() {
        TdkViewLegendElement tdkViewLegendElement = (TdkViewLegendElement)this._treeView.getCurrentElement();
        TdkViewGID tdkViewGID = tdkViewLegendElement.getGID();
        TdkView tdkView = TdkSetup.getPersistenceService().getView(tdkViewGID);
        TdkShowProjectionInfoDialog tdkShowProjectionInfoDialog = new TdkShowProjectionInfoDialog(TdkDialogUtil.getFrameParent(this._treeView), tdkView.getProjection());
        tdkShowProjectionInfoDialog.setModal(true);
        TdkDialogUtil.centralize(tdkShowProjectionInfoDialog, TdkDialogUtil.getFrameParent(this._treeView));
        tdkShowProjectionInfoDialog.setVisible(true);
    }

    private void thematicStyleActionPerformed() {
        TdkThematicLegendElement tdkThematicLegendElement = (TdkThematicLegendElement)this._treeView.getCurrentElement();
        TeLegendEntry teLegendEntry = tdkThematicLegendElement.getLegendEntry();
        TdkUpdateThemeEvent tdkUpdateThemeEvent = new TdkUpdateThemeEvent();
        tdkUpdateThemeEvent.setSetDefaultStyleChanged(true);
        TdkThemeGID tdkThemeGID = tdkThematicLegendElement.getOwnerTheme();
        TdkTheme tdkTheme = TdkSetup.getPersistenceService().getTheme(tdkThemeGID);
        int n = tdkTheme.getVisibleRepresentation();
        TdkThemeLegendElement tdkThemeLegendElement = (TdkThemeLegendElement)tdkThematicLegendElement.getParent();
        this._treeView.fireThemeChangeEvent(true, tdkThemeLegendElement, tdkUpdateThemeEvent);
        if (this.editStyle(teLegendEntry, tdkThemeGID.getDBKey(), n)) {
            this._treeView.fireThemeChangeEvent(false, tdkThemeLegendElement, tdkUpdateThemeEvent);
            tdkThematicLegendElement.buildLegendRenderParams();
            this._treeView.repaint();
        }
    }

    private void viewSaveActionPerformed() {
        _logger.debug((Object)"Saving view information");
        if (this._treeView.getCurrentElement() instanceof TdkViewLegendElement) {
            Frame frame = TdkDialogUtil.getFrameParent(this._treeView);
            TdkProgressBarDialog tdkProgressBarDialog = new TdkProgressBarDialog(frame);
            TdkDialogUtil.centralize(tdkProgressBarDialog, frame);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        TdkViewLegendElement tdkViewLegendElement = (TdkViewLegendElement)TdkTreeViewFunctor.this._treeView.getCurrentElement();
                        TdkViewGID tdkViewGID = tdkViewLegendElement.getGID();
                        TdkView tdkView = TdkSetup.getPersistenceService().getView(tdkViewGID);
                        TdkSetup.getPersistenceService().updateView(tdkView);
                        TdkUpdateViewEvent tdkUpdateViewEvent = new TdkUpdateViewEvent();
                        tdkUpdateViewEvent.setPersistenceChanged(true);
                        TdkTreeViewFunctor.this._treeView.fireViewSavedEvent(false, tdkViewLegendElement, tdkUpdateViewEvent);
                    }
                    catch (TdkNullPointerException tdkNullPointerException) {
                        _logger.error((Object)tdkNullPointerException.getMessage());
                    }
                    catch (TdkDatabaseException tdkDatabaseException) {
                        _logger.error((Object)tdkDatabaseException.getMessage());
                    }
                    catch (TdkException tdkException) {
                        _logger.error((Object)tdkException.getMessage());
                    }
                }
            };
            try {
                tdkProgressBarDialog.execute(runnable, null);
            }
            catch (Exception exception) {
                _logger.debug((Object)exception.getMessage());
            }
            _logger.debug((Object)"View Information saved successfully");
        }
    }
}

